/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.internal.concurrent;

import io.netty.channel.EventLoop;
import io.vertx.core.streams.impl.OutboundWriteQueue;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;

public class OutboundMessageQueue<M>
implements Predicate<M> {
    private final EventLoop eventLoop;
    private final AtomicInteger numberOfUnwritableSignals = new AtomicInteger();
    private final OutboundWriteQueue<M> writeQueue;
    private volatile boolean eventuallyClosed;
    private boolean overflow;
    private boolean closed;
    private int reentrant = 0;

    public OutboundMessageQueue(EventLoop eventLoop, Predicate<M> predicate) {
        this.eventLoop = eventLoop;
        this.writeQueue = new OutboundWriteQueue<M>(predicate);
    }

    public OutboundMessageQueue(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
        this.writeQueue = new OutboundWriteQueue(this);
    }

    @Override
    public boolean test(M msg) {
        throw new UnsupportedOperationException();
    }

    public boolean isWritable() {
        return this.numberOfUnwritableSignals.get() <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean write(M message) {
        int flags;
        boolean inEventLoop = this.eventLoop.inEventLoop();
        if (inEventLoop) {
            if (this.closed) {
                this.disposeMessage(message);
                return true;
            }
            ++this.reentrant;
            try {
                flags = this.writeQueue.add(message);
                this.overflow |= (flags & 4) != 0;
                if ((flags & 2) != 0) {
                    this.handleWriteQueueDrained(OutboundWriteQueue.numberOfUnwritableSignals(flags));
                }
            }
            finally {
                --this.reentrant;
            }
            if (this.reentrant == 0 && this.closed) {
                this.releaseMessages();
            }
        } else {
            if (this.eventuallyClosed) {
                this.disposeMessage(message);
                return true;
            }
            flags = this.writeQueue.submit(message);
            if ((flags & 4) != 0) {
                this.eventLoop.execute(this::drainWriteQueue);
            }
        }
        if ((flags & 1) != 0) {
            int val = this.numberOfUnwritableSignals.incrementAndGet();
            return val <= 0;
        }
        return this.numberOfUnwritableSignals.get() <= 0;
    }

    public void drain() {
        assert (this.eventLoop.inEventLoop());
        if (this.overflow) {
            this.startDraining();
            ++this.reentrant;
            try {
                int flags = this.writeQueue.drain();
                boolean bl = this.overflow = (flags & 4) != 0;
                if ((flags & 2) != 0) {
                    this.handleWriteQueueDrained(OutboundWriteQueue.numberOfUnwritableSignals(flags));
                }
            }
            finally {
                --this.reentrant;
            }
            this.stopDraining();
            if (this.reentrant == 0 && this.closed) {
                this.releaseMessages();
            }
        }
    }

    public final void close() {
        assert (this.eventLoop.inEventLoop());
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.eventuallyClosed = true;
        if (this.reentrant > 0) {
            return;
        }
        this.releaseMessages();
    }

    private void drainWriteQueue() {
        if (this.closed) {
            return;
        }
        this.startDraining();
        ++this.reentrant;
        try {
            int flags = this.writeQueue.drain();
            boolean bl = this.overflow = (flags & 4) != 0;
            if ((flags & 2) != 0) {
                this.handleWriteQueueDrained(OutboundWriteQueue.numberOfUnwritableSignals(flags));
            }
        }
        finally {
            --this.reentrant;
        }
        this.stopDraining();
        if (this.reentrant == 0 && this.closed) {
            this.releaseMessages();
        }
    }

    private void handleWriteQueueDrained(int numberOfSignals) {
        int val = this.numberOfUnwritableSignals.addAndGet(-numberOfSignals);
        if (val + numberOfSignals > 0 && val <= 0) {
            this.writeQueueDrained();
        }
    }

    private void releaseMessages() {
        List<M> messages = this.writeQueue.clear();
        for (M elt : messages) {
            this.disposeMessage(elt);
        }
    }

    protected void writeQueueDrained() {
    }

    protected void startDraining() {
    }

    protected void stopDraining() {
    }

    protected void disposeMessage(M msg) {
    }
}

