/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerFileUpload;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.ServerWebSocketHandshake;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.impl.Http1xServerConnection;
import io.vertx.core.http.impl.Http1xServerResponse;
import io.vertx.core.http.impl.HttpEventHandler;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.NettyFileUpload;
import io.vertx.core.http.impl.NettyFileUploadDataFactory;
import io.vertx.core.http.impl.headers.HeadersAdaptor;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.buffer.BufferInternal;
import io.vertx.core.internal.concurrent.InboundMessageQueue;
import io.vertx.core.internal.http.HttpServerRequestInternal;
import io.vertx.core.net.HostAndPort;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.HostAndPortImpl;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.observability.HttpRequest;
import io.vertx.core.spi.tracing.SpanKind;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.streams.impl.InboundBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Http1xServerRequest
extends HttpServerRequestInternal
implements HttpRequest {
    private static final HostAndPort NULL_HOST_AND_PORT = HostAndPort.create("", -1);
    private final Http1xServerConnection conn;
    final ContextInternal context;
    private io.netty.handler.codec.http.HttpRequest request;
    private HttpVersion version;
    private HttpMethod method;
    private HostAndPort authority;
    private String uri;
    private String path;
    private String query;
    Object metric;
    Object trace;
    boolean reportMetricsFailed;
    private Http1xServerResponse response;
    private Charset paramsCharset = StandardCharsets.UTF_8;
    private MultiMap params;
    private boolean semicolonIsNormalCharInParams;
    private MultiMap headers;
    private String absoluteURI;
    private HttpEventHandler eventHandler;
    private Handler<HttpServerFileUpload> uploadHandler;
    private MultiMap attributes;
    private boolean expectMultipart;
    private HttpPostRequestDecoder decoder;
    private boolean ended;
    private long bytesRead;
    private final InboundMessageQueue<Object> queue;

    Http1xServerRequest(final Http1xServerConnection conn, io.netty.handler.codec.http.HttpRequest request, ContextInternal context) {
        this.conn = conn;
        this.context = context;
        this.request = request;
        this.queue = new InboundMessageQueue<Object>(context.eventLoop(), context.executor()){

            @Override
            protected void handleMessage(Object elt) {
                if (elt == InboundBuffer.END_SENTINEL) {
                    Http1xServerRequest.this.onEnd();
                } else {
                    Http1xServerRequest.this.onData((Buffer)elt);
                }
            }

            @Override
            protected void handleResume() {
                conn.doResume();
            }

            @Override
            protected void handlePause() {
                conn.doPause();
            }
        };
    }

    private HttpEventHandler eventHandler(boolean create) {
        if (this.eventHandler == null && create) {
            this.eventHandler = new HttpEventHandler(this.context);
        }
        return this.eventHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    io.netty.handler.codec.http.HttpRequest nettyRequest() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            return this.request;
        }
    }

    void handleBegin(boolean keepAlive) {
        if (Metrics.METRICS_ENABLED) {
            this.reportRequestBegin();
        }
        this.response = new Http1xServerResponse(this.context.owner(), this.context, this.conn, this.request, this.metric, keepAlive);
        if (this.conn.handle100ContinueAutomatically) {
            this.check100();
        }
    }

    void handleContent(Buffer buffer) {
        boolean drain = this.queue.add(buffer);
        if (drain) {
            this.queue.drain();
        }
    }

    void handleEnd() {
        boolean drain = this.queue.add(InboundBuffer.END_SENTINEL);
        if (drain) {
            this.queue.drain();
        }
    }

    private void check100() {
        if (HttpUtil.is100ContinueExpected((HttpMessage)this.request)) {
            this.conn.write100Continue(null);
        }
    }

    @Override
    public Object metric() {
        return this.metric;
    }

    Object trace() {
        return this.trace;
    }

    @Override
    public ContextInternal context() {
        return this.context;
    }

    @Override
    public int id() {
        return 0;
    }

    @Override
    public HttpVersion version() {
        if (this.version == null) {
            io.netty.handler.codec.http.HttpVersion nettyVersion = this.request.protocolVersion();
            if (nettyVersion == io.netty.handler.codec.http.HttpVersion.HTTP_1_0) {
                this.version = HttpVersion.HTTP_1_0;
            } else if (nettyVersion == io.netty.handler.codec.http.HttpVersion.HTTP_1_1) {
                this.version = HttpVersion.HTTP_1_1;
            }
        }
        return this.version;
    }

    @Override
    public HttpMethod method() {
        if (this.method == null) {
            this.method = HttpMethod.fromNetty(this.request.method());
        }
        return this.method;
    }

    @Override
    public String uri() {
        if (this.uri == null) {
            this.uri = this.request.uri();
        }
        return this.uri;
    }

    @Override
    public String path() {
        if (this.path == null) {
            this.path = HttpUtils.parsePath(this.uri());
        }
        return this.path;
    }

    @Override
    public String query() {
        if (this.query == null) {
            this.query = HttpUtils.parseQuery(this.uri());
        }
        return this.query;
    }

    @Override
    public boolean isValidAuthority() {
        HostAndPort authority = this.authority;
        if (authority == NULL_HOST_AND_PORT) {
            return false;
        }
        if (authority != null) {
            return true;
        }
        String host = this.getHeader((CharSequence)HttpHeaderNames.HOST);
        if (host == null || !HostAndPortImpl.isValidAuthority(host)) {
            this.authority = NULL_HOST_AND_PORT;
            return false;
        }
        return true;
    }

    @Override
    public HostAndPort authority() {
        HostAndPort authority = this.authority;
        if (authority == NULL_HOST_AND_PORT) {
            return null;
        }
        if (authority == null) {
            String host = this.getHeader((CharSequence)HttpHeaderNames.HOST);
            if (host == null) {
                this.authority = NULL_HOST_AND_PORT;
                return null;
            }
            this.authority = authority = HostAndPort.parseAuthority(host, -1);
        }
        return authority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long bytesRead() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            return this.bytesRead;
        }
    }

    @Override
    public Http1xServerResponse response() {
        return this.response;
    }

    @Override
    public MultiMap headers() {
        MultiMap headers = this.headers;
        if (headers == null) {
            HttpHeaders reqHeaders = this.request.headers();
            headers = reqHeaders instanceof MultiMap ? (MultiMap)reqHeaders : new HeadersAdaptor(reqHeaders);
            this.headers = headers;
        }
        return headers;
    }

    @Override
    public HttpServerRequest setParamsCharset(String charset) {
        Objects.requireNonNull(charset, "Charset must not be null");
        Charset current = this.paramsCharset;
        this.paramsCharset = Charset.forName(charset);
        if (!this.paramsCharset.equals(current)) {
            this.params = null;
        }
        return this;
    }

    @Override
    public String getParamsCharset() {
        return this.paramsCharset.name();
    }

    @Override
    public MultiMap params(boolean semicolonIsNormalChar) {
        if (this.params == null || semicolonIsNormalChar != this.semicolonIsNormalCharInParams) {
            this.params = HttpUtils.params(this.uri(), this.paramsCharset, semicolonIsNormalChar);
            this.semicolonIsNormalCharInParams = semicolonIsNormalChar;
        }
        return this.params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest handler(Handler<Buffer> handler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            HttpEventHandler eventHandler;
            if (handler != null) {
                this.checkEnded();
            }
            if ((eventHandler = this.eventHandler(handler != null)) != null) {
                eventHandler.chunkHandler(handler);
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest exceptionHandler(Handler<Throwable> handler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            HttpEventHandler eventHandler = this.eventHandler(handler != null);
            if (eventHandler != null) {
                eventHandler.exceptionHandler(handler);
            }
            return this;
        }
    }

    @Override
    public HttpServerRequest pause() {
        this.queue.pause();
        return this;
    }

    @Override
    public HttpServerRequest fetch(long amount) {
        this.queue.fetch(amount);
        return this;
    }

    @Override
    public HttpServerRequest resume() {
        return this.fetch(Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest endHandler(Handler<Void> handler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            HttpEventHandler eventHandler;
            if (handler != null) {
                this.checkEnded();
            }
            if ((eventHandler = this.eventHandler(handler != null)) != null) {
                eventHandler.endHandler(handler);
            }
            return this;
        }
    }

    @Override
    public String scheme() {
        return this.isSSL() ? "https" : "http";
    }

    @Override
    public String absoluteURI() {
        if (this.absoluteURI == null) {
            this.absoluteURI = HttpUtils.absoluteURI(this.conn.serverOrigin(), this);
        }
        return this.absoluteURI;
    }

    @Override
    public SocketAddress remoteAddress() {
        return super.remoteAddress();
    }

    @Override
    public Future<NetSocket> toNetSocket() {
        return this.response.netSocket(this.method(), this.headers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest uploadHandler(Handler<HttpServerFileUpload> handler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (handler != null) {
                this.checkEnded();
            }
            this.uploadHandler = handler;
            return this;
        }
    }

    @Override
    public MultiMap formAttributes() {
        return this.attributes();
    }

    @Override
    public String getFormAttribute(String attributeName) {
        return this.formAttributes().get(attributeName);
    }

    @Override
    public Future<ServerWebSocket> toWebSocket() {
        return this.webSocketHandshake().compose(handshake -> handshake.accept());
    }

    Future<ServerWebSocketHandshake> webSocketHandshake() {
        PromiseInternal<ServerWebSocketHandshake> promise = this.context.promise();
        this.webSocketHandshake(promise);
        return promise.future();
    }

    private void webSocketHandshake(PromiseInternal<ServerWebSocketHandshake> promise) {
        BufferInternal body = BufferInternal.buffer();
        boolean[] failed = new boolean[1];
        this.handler(buff -> {
            if (!failed[0]) {
                body.appendBuffer((Buffer)buff);
                if (body.length() > 8192) {
                    failed[0] = true;
                    this.response.setStatusCode(413).end();
                    this.conn.close();
                }
            }
        });
        this.exceptionHandler(promise::tryFail);
        this.endHandler(v -> {
            if (!failed[0]) {
                this.request = new DefaultFullHttpRequest(this.request.protocolVersion(), this.request.method(), this.request.uri(), body.getByteBuf(), this.request.headers(), (HttpHeaders)EmptyHttpHeaders.INSTANCE);
                this.conn.createWebSocket(this, promise);
            }
        });
        this.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest setExpectMultipart(boolean expect) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkEnded();
            this.expectMultipart = expect;
            if (expect) {
                if (this.decoder == null) {
                    String contentType = this.request.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
                    if (contentType == null) {
                        throw new IllegalStateException("Request must have a content-type header to decode a multipart request");
                    }
                    if (!HttpUtils.isValidMultipartContentType(contentType)) {
                        throw new IllegalStateException("Request must have a valid content-type header to decode a multipart request");
                    }
                    if (!HttpUtils.isValidMultipartMethod(this.request.method())) {
                        throw new IllegalStateException("Request method must be one of POST, PUT, PATCH or DELETE to decode a multipart request");
                    }
                    NettyFileUploadDataFactory factory = new NettyFileUploadDataFactory(this.context, this, () -> this.uploadHandler);
                    HttpServerOptions options = this.conn.options;
                    factory.setMaxLimit(options.getMaxFormAttributeSize());
                    int maxFields = options.getMaxFormFields();
                    int maxBufferedBytes = options.getMaxFormBufferedBytes();
                    this.decoder = new HttpPostRequestDecoder((HttpDataFactory)factory, this.request, HttpConstants.DEFAULT_CHARSET, maxFields, maxBufferedBytes);
                }
            } else {
                this.decoder = null;
            }
            return this;
        }
    }

    @Override
    public synchronized boolean isExpectMultipart() {
        return this.expectMultipart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEnded() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            return this.ended;
        }
    }

    @Override
    public HttpServerRequest customFrameHandler(Handler<HttpFrame> handler) {
        return this;
    }

    @Override
    public HttpConnection connection() {
        return this.conn;
    }

    @Override
    public synchronized Future<Buffer> body() {
        this.checkEnded();
        return this.eventHandler(true).body();
    }

    @Override
    public synchronized Future<Void> end() {
        this.checkEnded();
        return this.eventHandler(true).end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onData(Buffer data) {
        HttpEventHandler handler;
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.bytesRead += (long)data.length();
            if (this.decoder != null) {
                try {
                    this.decoder.offer((HttpContent)new DefaultHttpContent(((BufferInternal)data).getByteBuf()));
                }
                catch (HttpPostRequestDecoder.ErrorDataDecoderException | HttpPostRequestDecoder.TooLongFormFieldException | HttpPostRequestDecoder.TooManyFormFieldsException e) {
                    this.decoder.destroy();
                    this.decoder = null;
                    this.handleException(e);
                }
            }
            handler = this.eventHandler;
        }
        if (handler != null) {
            this.eventHandler.handleChunk(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onEnd() {
        HttpEventHandler handler;
        if (Metrics.METRICS_ENABLED) {
            this.reportRequestComplete();
        }
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (this.decoder != null) {
                this.endDecode();
            }
            this.ended = true;
            handler = this.eventHandler;
        }
        if (handler != null) {
            handler.handleEnd();
        }
    }

    private void reportRequestComplete() {
        HttpServerMetrics metrics = this.conn.metrics;
        if (metrics != null) {
            metrics.requestEnd(this.metric, this, this.bytesRead);
            this.conn.flushBytesRead();
        }
    }

    private void reportRequestBegin() {
        VertxTracer tracer;
        HttpServerMetrics metrics = this.conn.metrics;
        if (metrics != null) {
            this.metric = metrics.requestBegin(this.conn.metric(), this);
        }
        if ((tracer = this.context.tracer()) != null) {
            this.trace = tracer.receiveRequest(this.context, SpanKind.RPC, this.conn.tracingPolicy(), this, this.request.method().name(), (Iterable<Map.Entry<String, String>>)this.request.headers(), HttpUtils.SERVER_REQUEST_TAG_EXTRACTOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endDecode() {
        try {
            this.decoder.offer((HttpContent)LastHttpContent.EMPTY_LAST_CONTENT);
            while (this.decoder.hasNext()) {
                InterfaceHttpData data = this.decoder.next();
                if (!(data instanceof Attribute)) continue;
                Attribute attr = (Attribute)data;
                try {
                    this.attributes().add(attr.getName(), attr.getValue());
                }
                catch (Exception e) {
                    this.handleException(e);
                }
                finally {
                    attr.release();
                }
            }
        }
        catch (HttpPostRequestDecoder.ErrorDataDecoderException | HttpPostRequestDecoder.TooLongFormFieldException | HttpPostRequestDecoder.TooManyFormFieldsException e) {
            this.handleException(e);
        }
        catch (HttpPostRequestDecoder.EndOfDataDecoderException endOfDataDecoderException) {
        }
        finally {
            this.decoder.destroy();
            this.decoder = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleException(Throwable t) {
        HttpEventHandler handler = null;
        Http1xServerResponse resp = null;
        InterfaceHttpData upload = null;
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (!this.isEnded()) {
                handler = this.eventHandler;
                if (this.decoder != null) {
                    upload = this.decoder.currentPartialHttpData();
                }
            }
            if (!this.response.ended()) {
                if (Metrics.METRICS_ENABLED) {
                    this.reportRequestReset(t);
                }
                resp = this.response;
            }
        }
        if (resp != null) {
            resp.handleException(t);
        }
        if (upload instanceof NettyFileUpload) {
            ((NettyFileUpload)upload).handleException(t);
        }
        if (handler != null) {
            handler.handleException(t);
        }
    }

    private void reportRequestReset(Throwable err) {
        VertxTracer tracer;
        if (this.conn.metrics != null) {
            this.conn.metrics.requestReset(this.metric);
        }
        if ((tracer = this.context.tracer()) != null) {
            tracer.sendResponse(this.context, null, this.trace, err, TagExtractor.empty());
        }
    }

    private void checkEnded() {
        if (this.isEnded()) {
            throw new IllegalStateException("Request has already been read");
        }
    }

    private MultiMap attributes() {
        if (this.attributes == null) {
            this.attributes = MultiMap.caseInsensitiveMultiMap();
        }
        return this.attributes;
    }

    @Override
    public HttpServerRequest streamPriorityHandler(Handler<StreamPriority> handler) {
        return this;
    }

    @Override
    public DecoderResult decoderResult() {
        return this.request.decoderResult();
    }

    @Override
    public Set<Cookie> cookies() {
        return this.response.cookies();
    }

    @Override
    public Set<Cookie> cookies(String name) {
        return this.response.cookies().getAll(name);
    }

    @Override
    public Cookie getCookie(String name) {
        return this.response.cookies().get(name);
    }

    @Override
    public Cookie getCookie(String name, String domain, String path) {
        return this.response.cookies().get(name, domain, path);
    }

    @Override
    public HttpServerRequest routed(String route) {
        if (Metrics.METRICS_ENABLED && !this.response.ended() && this.conn.metrics != null) {
            this.conn.metrics.requestRouted(this.metric, route);
        }
        return this;
    }
}

