/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus.impl.clustered;

import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBusOptions;
import io.vertx.core.eventbus.impl.MessageImpl;
import io.vertx.core.eventbus.impl.clustered.ClusteredEventBus;
import io.vertx.core.eventbus.impl.clustered.ClusteredMessage;
import io.vertx.core.eventbus.impl.codecs.PingMessageCodec;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.spi.cluster.NodeInfo;
import io.vertx.core.spi.metrics.EventBusMetrics;
import java.util.ArrayDeque;
import java.util.Queue;

class ConnectionHolder {
    private static final Logger log = LoggerFactory.getLogger(ConnectionHolder.class);
    private static final String PING_ADDRESS = "__vertx_ping";
    private final ClusteredEventBus eventBus;
    private final String remoteNodeId;
    private final VertxInternal vertx;
    private final EventBusMetrics metrics;
    private Queue<MessageWrite> pendingWrites;
    private NetSocket socket;
    private boolean connected;
    private long timeoutID = -1L;
    private long pingTimeoutID = -1L;

    ConnectionHolder(ClusteredEventBus eventBus, String remoteNodeId) {
        this.eventBus = eventBus;
        this.remoteNodeId = remoteNodeId;
        this.vertx = eventBus.vertx();
        this.metrics = eventBus.getMetrics();
    }

    void connect() {
        Promise<NodeInfo> promise = Promise.promise();
        this.eventBus.vertx().getClusterManager().getNodeInfo(this.remoteNodeId, promise);
        promise.future().flatMap(info -> this.eventBus.client().connect(info.port(), info.host())).onComplete(ar -> {
            if (ar.succeeded()) {
                this.connected((NetSocket)ar.result());
            } else {
                log.warn((Object)("Connecting to server " + this.remoteNodeId + " failed"), ar.cause());
                this.close(ar.cause());
            }
        });
    }

    synchronized void writeMessage(MessageImpl<?, ?> message, Promise<Void> writePromise) {
        if (this.connected) {
            Buffer data = ((ClusteredMessage)message).encodeToWire();
            if (this.metrics != null) {
                this.metrics.messageWritten(message.address(), data.length());
            }
            this.socket.write(data).onComplete(writePromise);
        } else {
            if (this.pendingWrites == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Not connected to server " + this.remoteNodeId + " - starting queuing"));
                }
                this.pendingWrites = new ArrayDeque<MessageWrite>();
            }
            this.pendingWrites.add(new MessageWrite(message, writePromise));
        }
    }

    void close() {
        this.close(ConnectionBase.CLOSED_EXCEPTION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(Throwable cause) {
        if (this.timeoutID != -1L) {
            this.vertx.cancelTimer(this.timeoutID);
        }
        if (this.pingTimeoutID != -1L) {
            this.vertx.cancelTimer(this.pingTimeoutID);
        }
        ConnectionHolder connectionHolder = this;
        synchronized (connectionHolder) {
            if (this.pendingWrites != null) {
                MessageWrite msg;
                while ((msg = this.pendingWrites.poll()) != null) {
                    msg.writePromise.tryFail(cause);
                }
            }
        }
        if (this.eventBus.connections().remove(this.remoteNodeId, this) && log.isDebugEnabled()) {
            log.debug((Object)("Cluster connection closed for server " + this.remoteNodeId));
        }
    }

    private void schedulePing() {
        EventBusOptions options = this.eventBus.options();
        this.pingTimeoutID = this.vertx.setTimer(options.getClusterPingInterval(), id1 -> {
            this.timeoutID = this.vertx.setTimer(options.getClusterPingReplyInterval(), id2 -> {
                log.warn((Object)("No pong from server " + this.remoteNodeId + " - will consider it dead"));
                this.close();
            });
            ClusteredMessage<String, String> pingMessage = new ClusteredMessage<String, String>(this.remoteNodeId, PING_ADDRESS, null, null, new PingMessageCodec(), true, this.eventBus);
            Buffer data = pingMessage.encodeToWire();
            this.socket.write(data);
        });
    }

    private synchronized void connected(NetSocket socket) {
        this.socket = socket;
        this.connected = true;
        socket.exceptionHandler(err -> this.close((Throwable)err));
        socket.closeHandler(v -> this.close());
        socket.handler(data -> {
            this.vertx.cancelTimer(this.timeoutID);
            this.schedulePing();
        });
        this.schedulePing();
        if (this.pendingWrites != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Draining the queue for server " + this.remoteNodeId));
            }
            for (MessageWrite ctx : this.pendingWrites) {
                Buffer data2 = ((ClusteredMessage)ctx.message).encodeToWire();
                if (this.metrics != null) {
                    this.metrics.messageWritten(ctx.message.address(), data2.length());
                }
                socket.write(data2).onComplete(ctx.writePromise);
            }
        }
        this.pendingWrites = null;
    }

    private static class MessageWrite {
        final MessageImpl<?, ?> message;
        final Promise<Void> writePromise;

        MessageWrite(MessageImpl<?, ?> message, Promise<Void> writePromise) {
            this.message = message;
            this.writePromise = writePromise;
        }
    }
}

