/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpClientAgent;
import io.vertx.core.http.HttpClientBuilder;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.PoolOptions;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.impl.CleanableHttpClient;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.internal.CloseFuture;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.http.HttpClientInternal;
import io.vertx.core.net.AddressResolver;
import io.vertx.core.net.endpoint.EndpointResolver;
import io.vertx.core.net.endpoint.LoadBalancer;
import io.vertx.core.net.endpoint.impl.EndpointResolverImpl;
import java.util.function.Function;

public final class HttpClientBuilderInternal
implements HttpClientBuilder {
    private final VertxInternal vertx;
    private HttpClientOptions clientOptions;
    private PoolOptions poolOptions;
    private Handler<HttpConnection> connectHandler;
    private Function<HttpClientResponse, Future<RequestOptions>> redirectHandler;
    private AddressResolver addressResolver;
    private LoadBalancer loadBalancer = null;

    public HttpClientBuilderInternal(VertxInternal vertx) {
        this.vertx = vertx;
    }

    @Override
    public HttpClientBuilder with(HttpClientOptions options) {
        this.clientOptions = options;
        return this;
    }

    @Override
    public HttpClientBuilder with(PoolOptions options) {
        this.poolOptions = options;
        return this;
    }

    @Override
    public HttpClientBuilder withConnectHandler(Handler<HttpConnection> handler) {
        this.connectHandler = handler;
        return this;
    }

    @Override
    public HttpClientBuilder withRedirectHandler(Function<HttpClientResponse, Future<RequestOptions>> handler) {
        this.redirectHandler = handler;
        return this;
    }

    @Override
    public HttpClientBuilder withAddressResolver(AddressResolver resolver) {
        this.addressResolver = resolver;
        return this;
    }

    @Override
    public HttpClientBuilder withLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
        return this;
    }

    private CloseFuture resolveCloseFuture() {
        ContextInternal context = this.vertx.getContext();
        return context != null ? context.closeFuture() : this.vertx.closeFuture();
    }

    private EndpointResolver endpointResolver(HttpClientOptions co) {
        LoadBalancer _loadBalancer = this.loadBalancer;
        AddressResolver _addressResolver = this.addressResolver;
        if (_loadBalancer != null) {
            if (_addressResolver == null) {
                _addressResolver = this.vertx.hostnameResolver();
            }
        } else if (_addressResolver != null) {
            _loadBalancer = LoadBalancer.ROUND_ROBIN;
        }
        if (_addressResolver != null) {
            return new EndpointResolverImpl(this.vertx, _addressResolver.endpointResolver(this.vertx), _loadBalancer, co.getKeepAliveTimeout() * 1000);
        }
        return null;
    }

    @Override
    public HttpClientAgent build() {
        Closeable closeable;
        HttpClientAgent client;
        HttpClientOptions co = this.clientOptions != null ? this.clientOptions : new HttpClientOptions();
        PoolOptions po = this.poolOptions != null ? this.poolOptions : new PoolOptions();
        CloseFuture cf = this.resolveCloseFuture();
        EndpointResolver resolver = this.endpointResolver(co);
        if (co.isShared()) {
            CloseFuture closeFuture = new CloseFuture();
            client = this.vertx.createSharedResource("__vertx.shared.httpClients", co.getName(), closeFuture, cf_ -> {
                HttpClientImpl impl = new HttpClientImpl(this.vertx, resolver, co, po);
                cf_.add(completion -> impl.close().onComplete(completion));
                return impl;
            });
            client = new CleanableHttpClient((HttpClientInternal)client, this.vertx.cleaner(), (timeout, timeunit) -> closeFuture.close());
            closeable = closeFuture;
        } else {
            HttpClientImpl impl;
            closeable = impl = new HttpClientImpl(this.vertx, resolver, co, po);
            client = new CleanableHttpClient(impl, this.vertx.cleaner(), impl::shutdown);
        }
        cf.add(closeable);
        if (this.redirectHandler != null) {
            ((HttpClientImpl)((CleanableHttpClient)client).delegate).redirectHandler(this.redirectHandler);
        }
        if (this.connectHandler != null) {
            ((HttpClientImpl)((CleanableHttpClient)client).delegate).connectionHandler(this.connectHandler);
        }
        return client;
    }
}

