/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.Arguments;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.PemTrustOptionsConverter;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.net.impl.KeyStoreHelper;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

@DataObject
@JsonGen(publicConverter=false)
public class PemTrustOptions
implements TrustOptions,
Cloneable {
    private KeyStoreHelper helper;
    private ArrayList<String> certPaths;
    private ArrayList<Buffer> certValues;

    public PemTrustOptions() {
        this.certPaths = new ArrayList();
        this.certValues = new ArrayList();
    }

    public PemTrustOptions(PemTrustOptions other) {
        this.certPaths = new ArrayList<String>(other.getCertPaths());
        this.certValues = new ArrayList<Buffer>(other.getCertValues());
    }

    public PemTrustOptions(JsonObject json) {
        this();
        PemTrustOptionsConverter.fromJson(json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        PemTrustOptionsConverter.toJson(this, json);
        return json;
    }

    public List<String> getCertPaths() {
        return this.certPaths;
    }

    public PemTrustOptions addCertPath(String certPath) throws NullPointerException {
        Objects.requireNonNull(certPath, "No null certificate accepted");
        Arguments.require(!certPath.isEmpty(), "No empty certificate path accepted");
        this.certPaths.add(certPath);
        return this;
    }

    public List<Buffer> getCertValues() {
        return this.certValues;
    }

    public PemTrustOptions addCertValue(Buffer certValue) throws NullPointerException {
        Objects.requireNonNull(certValue, "No null certificate accepted");
        this.certValues.add(certValue);
        return this;
    }

    public KeyStore loadKeyStore(Vertx vertx) throws Exception {
        KeyStoreHelper helper = this.getHelper(vertx);
        return helper != null ? helper.store() : null;
    }

    @Override
    public TrustManagerFactory getTrustManagerFactory(Vertx vertx) throws Exception {
        KeyStoreHelper helper = this.getHelper(vertx);
        return helper != null ? helper.getTrustMgrFactory((VertxInternal)vertx) : null;
    }

    @Override
    public Function<String, TrustManager[]> trustManagerMapper(Vertx vertx) throws Exception {
        KeyStoreHelper helper = this.getHelper(vertx);
        return helper != null ? helper::getTrustMgr : null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            PemTrustOptions that = (PemTrustOptions)obj;
            return Objects.equals(this.certPaths, that.certPaths) && Objects.equals(this.certValues, that.certValues);
        }
        return false;
    }

    public int hashCode() {
        int hashCode = Objects.hashCode(this.certPaths);
        hashCode = 31 * hashCode + Objects.hashCode(this.certValues);
        return hashCode;
    }

    @Override
    public PemTrustOptions copy() {
        return new PemTrustOptions(this);
    }

    public KeyStoreHelper getHelper(Vertx vertx) throws Exception {
        if (this.helper == null) {
            Stream<Buffer> certValues = this.certPaths.stream().map(path -> ((VertxInternal)vertx).resolveFile((String)path).getAbsolutePath()).map(vertx.fileSystem()::readFileBlocking);
            certValues = Stream.concat(certValues, this.certValues.stream());
            this.helper = new KeyStoreHelper(KeyStoreHelper.loadCA(certValues), null, null);
        }
        return this.helper;
    }
}

