/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.internal.concurrent;

import io.vertx.core.impl.EventLoopExecutor;
import io.vertx.core.internal.EventExecutor;
import io.vertx.core.streams.impl.InboundReadQueue;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.Predicate;

public class InboundMessageQueue<M>
implements Predicate<M>,
Runnable {
    private static final AtomicLongFieldUpdater<InboundMessageQueue<?>> DEMAND_UPDATER = AtomicLongFieldUpdater.newUpdater(InboundMessageQueue.class, "demand");
    private final EventExecutor consumer;
    private final EventExecutor producer;
    private final InboundReadQueue<M> readQueue;
    private boolean needsDrain;
    private boolean draining;
    private volatile long demand = Long.MAX_VALUE;

    public InboundMessageQueue(EventExecutor producer, EventExecutor consumer) {
        InboundReadQueue.Factory readQueueFactory = consumer instanceof EventLoopExecutor && producer instanceof EventLoopExecutor && ((EventLoopExecutor)consumer).eventLoop() == ((EventLoopExecutor)producer).eventLoop() ? InboundReadQueue.SINGLE_THREADED : InboundReadQueue.SPSC;
        this.readQueue = readQueueFactory.create(this);
        this.consumer = consumer;
        this.producer = producer;
    }

    public InboundMessageQueue(EventExecutor producer, EventExecutor consumer, InboundReadQueue.Factory readQueueFactory) {
        this.readQueue = readQueueFactory.create(this);
        this.consumer = consumer;
        this.producer = producer;
    }

    public InboundMessageQueue(EventExecutor producer, EventExecutor consumer, int lowWaterMark, int highWaterMark) {
        InboundReadQueue.Factory readQueueFactory = consumer instanceof EventLoopExecutor && producer instanceof EventLoopExecutor && ((EventLoopExecutor)consumer).eventLoop() == ((EventLoopExecutor)producer).eventLoop() ? InboundReadQueue.SINGLE_THREADED : InboundReadQueue.SPSC;
        this.readQueue = readQueueFactory.create(this, lowWaterMark, highWaterMark);
        this.consumer = consumer;
        this.producer = consumer;
    }

    @Override
    public final boolean test(M msg) {
        long d;
        do {
            if ((d = DEMAND_UPDATER.get(this)) != 0L) continue;
            return false;
        } while (d != Long.MAX_VALUE && !DEMAND_UPDATER.compareAndSet(this, d, d - 1L));
        this.handleMessage(msg);
        return true;
    }

    protected void handleResume() {
    }

    protected void handlePause() {
    }

    protected void handleMessage(M msg) {
    }

    public final boolean add(M msg) {
        assert (this.producer.inThread());
        int res = this.readQueue.add(msg);
        if ((res & 2) != 0) {
            this.handlePause();
        }
        return (res & 1) != 0;
    }

    public final void write(Iterable<M> messages) {
        boolean drain = false;
        for (M msg : messages) {
            drain |= this.add(msg);
        }
        if (drain) {
            this.drain();
        }
    }

    public final void write(M msg) {
        if (this.add(msg)) {
            this.drain();
        }
    }

    public final void drain() {
        assert (this.producer.inThread());
        if (this.consumer.inThread()) {
            this.drainInternal();
        } else {
            this.consumer.execute(this::drainInternal);
        }
    }

    @Override
    public void run() {
        assert (this.consumer.inThread());
        if (!this.draining && this.needsDrain) {
            this.drainInternal();
        }
    }

    private void drainInternal() {
        this.draining = true;
        try {
            int res = this.readQueue.drain();
            boolean bl = this.needsDrain = (res & 1) != 0;
            if ((res & 2) != 0) {
                this.producer.execute(this::handleResume);
            }
        }
        finally {
            this.draining = false;
        }
    }

    public final void pause() {
        DEMAND_UPDATER.set(this, 0L);
    }

    public final void fetch(long amount) {
        if (amount < 0L) {
            throw new IllegalArgumentException("Invalid amount: " + amount);
        }
        if (amount > 0L) {
            long next;
            long prev;
            do {
                if ((next = (prev = DEMAND_UPDATER.get(this)) + amount) >= 0L) continue;
                next = Long.MAX_VALUE;
            } while (prev != next && !DEMAND_UPDATER.compareAndSet(this, prev, next));
            this.consumer.execute(this);
        }
    }
}

