/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.Future;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.impl.WorkerTask;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.spi.metrics.PoolMetrics;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;

public class WorkerPool {
    private final ExecutorService pool;
    private final PoolMetrics metrics;

    public WorkerPool(ExecutorService pool, PoolMetrics metrics) {
        this.pool = pool;
        this.metrics = metrics;
    }

    public ExecutorService executor() {
        return this.pool;
    }

    public PoolMetrics metrics() {
        return this.metrics;
    }

    public void close() {
        if (this.metrics != null) {
            this.metrics.close();
        }
        this.pool.shutdownNow();
    }

    public <T> Future<T> executeBlocking(final ContextInternal context, final Callable<T> blockingCodeHandler, TaskQueue queue) {
        final PromiseInternal promise = context.promise();
        Future fut = promise.future();
        final Object queueMetric = this.metrics != null ? this.metrics.enqueue() : null;
        WorkerTask task = new WorkerTask(this.metrics, queueMetric){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void execute() {
                Object result;
                ContextInternal prev = context.beginDispatch();
                try {
                    result = blockingCodeHandler.call();
                }
                catch (Throwable t) {
                    promise.fail(t);
                    return;
                }
                finally {
                    context.endDispatch(prev);
                }
                promise.complete(result);
            }

            @Override
            void reject() {
                if (WorkerPool.this.metrics != null) {
                    WorkerPool.this.metrics.dequeue(queueMetric);
                }
                promise.fail(new RejectedExecutionException());
            }
        };
        try {
            ExecutorService exec = this.executor();
            if (queue != null) {
                queue.execute(task, exec);
            } else {
                exec.execute(task);
            }
        }
        catch (RejectedExecutionException e) {
            task.reject();
            throw e;
        }
        return fut;
    }
}

