/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus.impl;

import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.eventbus.ReplyFailure;
import io.vertx.core.eventbus.impl.DeliveryContextBase;
import io.vertx.core.eventbus.impl.EventBusImpl;
import io.vertx.core.eventbus.impl.MessageImpl;
import io.vertx.core.eventbus.impl.MessageTagExtractor;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.spi.tracing.SpanKind;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingPolicy;
import java.util.function.Consumer;

public abstract class HandlerRegistration<T>
implements Closeable {
    protected final ContextInternal context;
    protected final EventBusImpl bus;
    protected final String address;
    protected final boolean src;
    private Consumer<Promise<Void>> registered;
    private Object metric;

    HandlerRegistration(ContextInternal context, EventBusImpl bus, String address, boolean src) {
        this.context = context;
        this.bus = bus;
        this.src = src;
        this.address = address;
    }

    void receive(MessageImpl msg) {
        if (this.bus.metrics != null) {
            this.bus.metrics.scheduleMessage(this.metric, msg.isLocal());
        }
        this.context.executor().execute(() -> {
            if (!this.doReceive(msg)) {
                this.discard(msg);
            }
        });
    }

    public String address() {
        return this.address;
    }

    protected abstract boolean doReceive(Message<T> var1);

    protected abstract void dispatch(Message<T> var1, ContextInternal var2, Handler<Message<T>> var3);

    synchronized void register(boolean broadcast, boolean localOnly, Promise<Void> promise) {
        if (this.registered != null) {
            throw new IllegalStateException();
        }
        this.registered = this.bus.addRegistration(this.address, this, broadcast, localOnly, promise);
        if (this.bus.metrics != null) {
            this.metric = this.bus.metrics.handlerRegistered(this.address);
        }
    }

    public synchronized boolean isRegistered() {
        return this.registered != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> unregister() {
        PromiseInternal promise = this.context.owner().promise();
        HandlerRegistration handlerRegistration = this;
        synchronized (handlerRegistration) {
            if (this.registered != null) {
                this.registered.accept(promise);
                this.registered = null;
                if (this.bus.metrics != null) {
                    this.bus.metrics.handlerUnregistered(this.metric);
                }
            } else {
                promise.complete();
            }
        }
        return promise.future();
    }

    void dispatch(Handler<Message<T>> theHandler, Message<T> message, ContextInternal context) {
        InboundDeliveryContext deliveryCtx = new InboundDeliveryContext((MessageImpl)message, theHandler, context);
        deliveryCtx.dispatch();
    }

    void discard(Message<T> msg) {
        String replyAddress;
        if (this.bus.metrics != null) {
            this.bus.metrics.discardMessage(this.metric, ((MessageImpl)msg).isLocal(), msg);
        }
        if ((replyAddress = msg.replyAddress()) != null) {
            msg.reply(new ReplyException(ReplyFailure.TIMEOUT, "Discarded the request. address: " + replyAddress + ", repliedAddress: " + msg.address()));
        }
    }

    @Override
    public void close(Promise<Void> completion) {
        this.unregister().onComplete(completion);
    }

    private class InboundDeliveryContext
    extends DeliveryContextBase<T> {
        private final Handler<Message<T>> handler;

        private InboundDeliveryContext(MessageImpl<?, T> message, Handler<Message<T>> handler, ContextInternal context) {
            super(message, message.bus.inboundInterceptors(), context);
            this.handler = handler;
        }

        @Override
        protected void execute() {
            ContextInternal ctx = this.context;
            Object m = HandlerRegistration.this.metric;
            VertxTracer tracer = ctx.tracer();
            if (HandlerRegistration.this.bus.metrics != null) {
                HandlerRegistration.this.bus.metrics.messageDelivered(m, this.message.isLocal());
            }
            if (tracer != null && !HandlerRegistration.this.src) {
                this.message.trace = tracer.receiveRequest(ctx, SpanKind.RPC, TracingPolicy.PROPAGATE, this.message, this.message.isSend() ? "send" : "publish", this.message.headers(), MessageTagExtractor.INSTANCE);
                HandlerRegistration.this.dispatch(this.message, ctx, this.handler);
                Object trace = this.message.trace;
                if (this.message.replyAddress == null && trace != null) {
                    tracer.sendResponse(this.context, null, trace, null, TagExtractor.empty());
                }
            } else {
                HandlerRegistration.this.dispatch(this.message, ctx, this.handler);
            }
        }

        @Override
        public boolean send() {
            return this.message.isSend();
        }

        @Override
        public Object body() {
            return this.message.receivedBody;
        }
    }
}

