/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.core.impl.future.PromiseImpl;

@VertxGen
public interface Promise<T>
extends Completable<T> {
    public static <T> Promise<T> promise() {
        return new PromiseImpl();
    }

    @GenIgnore(value={"permitted-type"})
    default public void handle(AsyncResult<T> asyncResult) {
        if (asyncResult.succeeded()) {
            this.complete(asyncResult.result());
        } else {
            this.fail(asyncResult.cause());
        }
    }

    @Override
    default public void complete(T result, Throwable failure) {
        if (failure != null) {
            this.handle(Future.failedFuture(failure));
        } else {
            this.handle(Future.succeededFuture(result));
        }
    }

    default public void complete(T result) {
        if (!this.tryComplete(result)) {
            throw new IllegalStateException("Result is already complete");
        }
    }

    default public void complete() {
        if (!this.tryComplete()) {
            throw new IllegalStateException("Promise already completed");
        }
    }

    @Override
    default public void succeed(T result) {
        if (!this.tryComplete(result)) {
            throw new IllegalStateException("Promise already completed");
        }
    }

    @Override
    default public void succeed() {
        this.complete(null, null);
    }

    @Override
    default public void fail(Throwable failure) {
        if (!this.tryFail(failure)) {
            throw new IllegalStateException("Promise already completed");
        }
    }

    @Override
    default public void fail(String message) {
        if (!this.tryFail(message)) {
            throw new IllegalStateException("Promise already completed");
        }
    }

    public boolean tryComplete(T var1);

    default public boolean tryComplete() {
        return this.tryComplete(null);
    }

    public boolean tryFail(Throwable var1);

    default public boolean tryFail(String message) {
        return this.tryFail(new NoStackTraceThrowable(message));
    }

    @CacheReturn
    public Future<T> future();
}

