/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.it;

import io.netty.handler.ssl.OpenSslSessionContext;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpTestBase;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.impl.HttpServerImpl;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.impl.SslContextProvider;
import io.vertx.core.net.impl.VertxSslContext;
import io.vertx.test.tls.Cert;
import org.junit.Test;

public class SSLEngineTest
extends HttpTestBase {
    private static boolean OPEN_SSL = Boolean.getBoolean("vertx-test-alpn-openssl");

    private static boolean hasAlpn() {
        return JdkSSLEngineOptions.isAlpnAvailable();
    }

    @Test
    public void testDefaultEngineWithAlpn() {
        this.doTest(null, true, HttpVersion.HTTP_2, SSLEngineTest.hasAlpn() | OPEN_SSL ? null : "ALPN not available for JDK SSL/TLS engine", SSLEngineTest.hasAlpn() ? "jdk" : "openssl", false);
    }

    @Test
    public void testJdkEngineWithAlpn() {
        this.doTest((SSLEngineOptions)new JdkSSLEngineOptions(), true, HttpVersion.HTTP_2, SSLEngineTest.hasAlpn() ? null : "ALPN not available for JDK SSL/TLS engine", "jdk", false);
    }

    @Test
    public void testOpenSSLEngineWithAlpn() {
        this.doTest((SSLEngineOptions)new OpenSSLEngineOptions(), true, HttpVersion.HTTP_2, OPEN_SSL ? null : "OpenSSL is not available", "openssl", true);
    }

    @Test
    public void testDefaultEngine() {
        this.doTest(null, false, HttpVersion.HTTP_1_1, null, "jdk", false);
    }

    @Test
    public void testJdkEngine() {
        this.doTest((SSLEngineOptions)new JdkSSLEngineOptions(), false, HttpVersion.HTTP_1_1, null, "jdk", false);
    }

    @Test
    public void testOpenSSLEngine() {
        this.doTest((SSLEngineOptions)new OpenSSLEngineOptions(), false, HttpVersion.HTTP_1_1, OPEN_SSL ? null : "OpenSSL is not available", "openssl", true);
    }

    private void doTest(SSLEngineOptions engine, boolean useAlpn, HttpVersion version, String error, String expectedSslContext, boolean expectCause) {
        this.server.close();
        HttpServerOptions options = new HttpServerOptions().setSslEngineOptions(engine).setPort(DEFAULT_HTTP_PORT).setHost("localhost").setKeyCertOptions((KeyCertOptions)Cert.SERVER_PEM.get()).setSsl(true).setUseAlpn(useAlpn);
        this.server = this.vertx.createHttpServer(options);
        this.server.requestHandler(req -> {
            this.assertEquals(req.version(), version);
            this.assertTrue(req.isSSL());
            req.response().end();
        });
        try {
            this.startServer();
            if (error != null) {
                this.fail("Was expecting failure: " + error);
            }
        }
        catch (Exception e) {
            if (error == null) {
                this.fail(e);
            }
            this.assertEquals(error, e.getMessage());
            if (expectCause) {
                this.assertNotSame(e, e.getCause());
            }
            return;
        }
        SslContextProvider provider = ((HttpServerImpl)this.server).sslContextProvider();
        VertxSslContext ctx = provider.createContext(false, false);
        switch (expectedSslContext != null ? expectedSslContext : "jdk") {
            case "jdk": {
                this.assertTrue(ctx.sessionContext().getClass().getName().equals("sun.security.ssl.SSLSessionContextImpl"));
                break;
            }
            case "openssl": {
                this.assertTrue(ctx.sessionContext() instanceof OpenSslSessionContext);
            }
        }
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setSslEngineOptions(engine).setSsl(true).setUseAlpn(useAlpn).setTrustAll(true).setProtocolVersion(version));
        this.client.request(HttpMethod.GET, DEFAULT_HTTP_PORT, "localhost", "/somepath", this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.testComplete();
        }))));
        this.await();
    }
}

