/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.spi.tracing;

import io.vertx.core.http.Http2TestBase;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.spi.tracing.HttpTracerTestBase;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.test.faketracer.FakeTracer;
import org.junit.Assert;
import org.junit.Test;

public class Http2TracerTest
extends HttpTracerTestBase {
    private static final String SPAN_KIND_SERVER = "server";
    private static final String SPAN_KIND_CLIENT = "client";
    private static final String SPAN_KIND_KEY = "span_kind";

    @Override
    protected HttpServerOptions createBaseServerOptions() {
        return Http2TestBase.createHttp2ServerOptions(DEFAULT_HTTP_PORT, "localhost");
    }

    @Override
    protected HttpClientOptions createBaseClientOptions() {
        return Http2TestBase.createHttp2ClientOptions();
    }

    @Test
    public void testTracingWorksAfterUpgrading() throws Exception {
        this.client.close();
        FakeTracer fakeTracer = new FakeTracer();
        this.setTracer(fakeTracer);
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setTracingPolicy(TracingPolicy.ALWAYS).setProtocolVersion(HttpVersion.HTTP_2));
        this.server = this.vertx.createHttpServer();
        this.server.requestHandler(req -> req.response().end("Ok"));
        this.startServer(this.testAddress);
        this.waitFor(2);
        this.client.request(this.requestOptions).onSuccess(request -> request.send().onSuccess(response -> this.complete()));
        this.client.request(this.requestOptions).onSuccess(request -> request.send().onSuccess(response -> this.complete()));
        Http2TracerTest.waitUntil(() -> fakeTracer.getFinishedSpans().size() == 4);
        Assert.assertTrue((String)"Span with kind server was not found!", (boolean)fakeTracer.getFinishedSpans().stream().anyMatch(s -> SPAN_KIND_SERVER.equals(s.getTags().get(SPAN_KIND_KEY))));
        Assert.assertTrue((String)"Span with kind client was not found!", (boolean)fakeTracer.getFinishedSpans().stream().anyMatch(s -> SPAN_KIND_CLIENT.equals(s.getTags().get(SPAN_KIND_KEY))));
        fakeTracer.getFinishedSpans().forEach(s -> Assert.assertNull((Object)s.failure()));
        this.await();
    }
}

