/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Expectation;
import io.vertx.core.Future;
import io.vertx.core.FutureTestBase;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.future.FutureImpl;
import io.vertx.core.impl.future.Listener;
import io.vertx.test.core.Repeat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.junit.Test;

public class CompositeFutureTest
extends FutureTestBase {
    private static final int NUM_THREADS = 4;
    private static final BiConsumer<Integer, Promise<String>> MIXED = (x, p) -> {
        if (x % 2 == 0) {
            p.complete((Object)("success-" + x));
        } else {
            p.complete((Object)("failure-" + x));
        }
    };
    private static final BiConsumer<Integer, Promise<String>> SUCCESS = (x, p) -> p.complete((Object)("success-" + x));
    private static final BiConsumer<Integer, Promise<String>> FAILURE = (x, p) -> p.fail("failure-" + x);

    @Repeat(times=100)
    @Test
    public void testConcurrentAllSuccess() throws Exception {
        this.testConcurrentCompletion(SUCCESS, CompositeFuture::all, cf -> this.assertTrue(cf.succeeded()));
    }

    @Repeat(times=100)
    @Test
    public void testConcurrentAllFailure() throws Exception {
        this.testConcurrentCompletion((x, p) -> p.fail("failure-" + x), CompositeFuture::all, cf -> this.assertTrue(cf.failed()));
    }

    @Repeat(times=100)
    @Test
    public void testConcurrentAllMixed() throws Exception {
        this.testConcurrentCompletion(MIXED, CompositeFuture::all, cf -> this.assertTrue(cf.isComplete()));
    }

    @Repeat(times=100)
    @Test
    public void testConcurrentAnySuccess() throws Exception {
        this.testConcurrentCompletion(SUCCESS, CompositeFuture::any, cf -> this.assertTrue(cf.succeeded()));
    }

    @Repeat(times=100)
    @Test
    public void testConcurrentAnyFailure() throws Exception {
        this.testConcurrentCompletion(FAILURE, CompositeFuture::any, cf -> this.assertTrue(cf.failed()));
    }

    @Repeat(times=100)
    @Test
    public void testConcurrentAnyMixed() throws Exception {
        this.testConcurrentCompletion(MIXED, CompositeFuture::any, cf -> this.assertTrue(cf.isComplete()));
    }

    @Repeat(times=100)
    @Test
    public void tesConcurrenttJoinSuccess() throws Exception {
        this.testConcurrentCompletion(SUCCESS, CompositeFuture::join, cf -> this.assertTrue(cf.succeeded()));
    }

    @Repeat(times=100)
    @Test
    public void testConcurrentJoinFailure() throws Exception {
        this.testConcurrentCompletion((x, p) -> p.fail("failure-" + x), CompositeFuture::join, cf -> this.assertTrue(cf.failed()));
    }

    @Repeat(times=100)
    @Test
    public void testConcurrentJoinMixed() throws Exception {
        this.testConcurrentCompletion(MIXED, CompositeFuture::join, cf -> this.assertTrue(cf.isComplete()));
    }

    private void testConcurrentCompletion(BiConsumer<Integer, Promise<String>> completer, Function<List<Future>, CompositeFuture> fact, Consumer<CompositeFuture> check) throws Exception {
        this.disableThreadChecks();
        List promises = IntStream.range(0, 4).mapToObj(i -> Promise.promise()).collect(Collectors.toList());
        List futures = promises.stream().map(Promise::future).collect(Collectors.toList());
        CompositeFuture compositeFuture = fact.apply(futures);
        ExecutorService executorService = Executors.newFixedThreadPool(4);
        CyclicBarrier barrier = new CyclicBarrier(4);
        int i2 = 0;
        while (i2 < 4) {
            int x2 = i2++;
            executorService.submit(() -> {
                Promise promise = (Promise)promises.get(x2);
                try {
                    barrier.await();
                    completer.accept(x2, promise);
                }
                catch (Throwable t) {
                    this.fail(t);
                }
            });
        }
        compositeFuture.onComplete(x -> {
            check.accept(compositeFuture);
            this.testComplete();
        });
        executorService.shutdown();
        executorService.awaitTermination(30L, TimeUnit.SECONDS);
        this.await();
    }

    @Test
    public void testAllSucceeded() {
        this.testAllSucceeded(CompositeFuture::all);
    }

    @Test
    public void testAllSucceededWithList() {
        this.testAllSucceeded((f1, f2) -> CompositeFuture.all(Arrays.asList(f1, f2)));
    }

    private void testAllSucceeded(BiFunction<Future<String>, Future<Integer>, CompositeFuture> all) {
        Promise p1 = Promise.promise();
        Future f1 = p1.future();
        Promise p2 = Promise.promise();
        Future f2 = p2.future();
        CompositeFuture composite = all.apply((Future<String>)f1, (Future<Integer>)f2);
        FutureTestBase.Checker<CompositeFuture> checker = new FutureTestBase.Checker<CompositeFuture>(this, (Future<CompositeFuture>)composite);
        checker.assertNotCompleted();
        this.assertEquals(null, composite.resultAt(0));
        this.assertEquals(null, composite.resultAt(1));
        p1.complete((Object)"something");
        checker.assertNotCompleted();
        this.assertEquals("something", composite.resultAt(0));
        this.assertEquals(null, composite.resultAt(1));
        p2.complete((Object)3);
        checker.assertSucceeded(composite);
        this.assertEquals("something", composite.resultAt(0));
        this.assertEquals(3L, ((Integer)composite.resultAt(1)).intValue());
    }

    @Test
    public void testAllWithEmptyList() {
        CompositeFuture composite = CompositeFuture.all(Collections.emptyList());
        this.assertTrue(composite.isComplete());
    }

    @Test
    public void testAllFailed() {
        this.testAllFailed(CompositeFuture::all);
    }

    @Test
    public void testAllFailedWithList() {
        this.testAllFailed((f1, f2) -> CompositeFuture.all(Arrays.asList(f1, f2)));
    }

    private void testAllFailed(BiFunction<Future<String>, Future<Integer>, CompositeFuture> all) {
        Promise p1 = Promise.promise();
        Future f1 = p1.future();
        Promise p2 = Promise.promise();
        Future f2 = p2.future();
        CompositeFuture composite = all.apply((Future<String>)f1, (Future<Integer>)f2);
        FutureTestBase.Checker checker = new FutureTestBase.Checker(this, composite);
        p1.complete((Object)"s");
        Exception cause = new Exception();
        p2.fail((Throwable)cause);
        checker.assertFailed(cause);
        this.assertEquals("s", composite.resultAt(0));
        this.assertEquals(null, composite.resultAt(1));
    }

    @Test
    public void testAllLargeList() {
        this.testAllLargeList(63);
        this.testAllLargeList(64);
        this.testAllLargeList(65);
        this.testAllLargeList(100);
    }

    private void testAllLargeList(int size) {
        ArrayList<Future> list = new ArrayList<Future>();
        for (int i = 0; i < size; ++i) {
            list.add(Future.succeededFuture());
        }
        CompositeFuture composite = CompositeFuture.all(list);
        FutureTestBase.Checker<CompositeFuture> checker = new FutureTestBase.Checker<CompositeFuture>(this, (Future<CompositeFuture>)composite);
        checker.assertSucceeded(composite);
        for (int i = 0; i < size; ++i) {
            int j;
            list.clear();
            Exception cause = new Exception();
            for (j = 0; j < size; ++j) {
                list.add(i == j ? Future.failedFuture((Throwable)cause) : Future.succeededFuture());
            }
            composite = CompositeFuture.all(list);
            checker = new FutureTestBase.Checker(this, composite);
            checker.assertFailed(cause);
            for (j = 0; j < size; ++j) {
                if (i == j) {
                    this.assertTrue(composite.failed(j));
                    continue;
                }
                this.assertTrue(composite.succeeded(j));
            }
        }
    }

    @Test
    public void testAnySucceeded1() {
        this.testAnySucceeded1(CompositeFuture::any);
    }

    @Test
    public void testAnySucceeded1WithList() {
        this.testAnySucceeded1((f1, f2) -> CompositeFuture.any(Arrays.asList(f1, f2)));
    }

    private void testAnySucceeded1(BiFunction<Future<String>, Future<Integer>, CompositeFuture> any) {
        Promise p1 = Promise.promise();
        Future f1 = p1.future();
        Promise p2 = Promise.promise();
        Future f2 = p2.future();
        CompositeFuture composite = any.apply((Future<String>)f1, (Future<Integer>)f2);
        FutureTestBase.Checker<CompositeFuture> checker = new FutureTestBase.Checker<CompositeFuture>(this, (Future<CompositeFuture>)composite);
        checker.assertNotCompleted();
        this.assertEquals(null, composite.resultAt(0));
        this.assertEquals(null, composite.resultAt(1));
        p1.complete((Object)"something");
        checker.assertSucceeded(composite);
        p2.complete((Object)3);
        checker.assertSucceeded(composite);
    }

    @Test
    public void testAnyWithEmptyList() {
        CompositeFuture composite = CompositeFuture.any(Collections.emptyList());
        this.assertTrue(composite.isComplete());
    }

    @Test
    public void testAnySucceeded2() {
        this.testAnySucceeded2(CompositeFuture::any);
    }

    @Test
    public void testAnySucceeded2WithList() {
        this.testAnySucceeded2(CompositeFuture::any);
    }

    private void testAnySucceeded2(BiFunction<Future<String>, Future<Integer>, CompositeFuture> any) {
        Promise p1 = Promise.promise();
        Future f1 = p1.future();
        Promise p2 = Promise.promise();
        Future f2 = p2.future();
        CompositeFuture composite = any.apply((Future<String>)f1, (Future<Integer>)f2);
        FutureTestBase.Checker<CompositeFuture> checker = new FutureTestBase.Checker<CompositeFuture>(this, (Future<CompositeFuture>)composite);
        p1.fail("failure");
        checker.assertNotCompleted();
        p2.complete((Object)3);
        checker.assertSucceeded(composite);
    }

    @Test
    public void testAnyFailed() {
        this.testAnyFailed(CompositeFuture::any);
    }

    @Test
    public void testAnyFailedWithList() {
        this.testAnyFailed((f1, f2) -> CompositeFuture.any(Arrays.asList(f1, f2)));
    }

    private void testAnyFailed(BiFunction<Future<String>, Future<Integer>, CompositeFuture> any) {
        Promise p1 = Promise.promise();
        Future f1 = p1.future();
        Promise p2 = Promise.promise();
        Future f2 = p2.future();
        CompositeFuture composite = any.apply((Future<String>)f1, (Future<Integer>)f2);
        FutureTestBase.Checker checker = new FutureTestBase.Checker(this, composite);
        p1.fail("failure");
        checker.assertNotCompleted();
        Exception cause = new Exception();
        p2.fail((Throwable)cause);
        checker.assertFailed(cause);
    }

    @Test
    public void testAnyLargeList() {
        this.testAnyLargeList(63);
        this.testAnyLargeList(64);
        this.testAnyLargeList(65);
        this.testAnyLargeList(100);
    }

    private void testAnyLargeList(int size) {
        ArrayList<Future> list = new ArrayList<Future>();
        for (int i = 0; i < size; ++i) {
            list.add(Future.failedFuture((Throwable)new Exception()));
        }
        CompositeFuture composite = CompositeFuture.any(list);
        FutureTestBase.Checker<CompositeFuture> checker = new FutureTestBase.Checker<CompositeFuture>(this, (Future<CompositeFuture>)composite);
        this.assertNotNull(checker.assertFailed());
        for (int i = 0; i < size; ++i) {
            int j;
            list.clear();
            for (j = 0; j < size; ++j) {
                list.add(i == j ? Future.succeededFuture() : Future.failedFuture((Throwable)new RuntimeException()));
            }
            composite = CompositeFuture.any(list);
            checker = new FutureTestBase.Checker(this, composite);
            checker.assertSucceeded(composite);
            for (j = 0; j < size; ++j) {
                if (i == j) {
                    this.assertTrue(composite.succeeded(j));
                    continue;
                }
                this.assertTrue(composite.failed(j));
            }
        }
    }

    @Test
    public void testJoinSucceeded() {
        this.testJoinSucceeded(CompositeFuture::join);
    }

    @Test
    public void testJoinSucceededWithList() {
        this.testJoinSucceeded((f1, f2) -> CompositeFuture.join(Arrays.asList(f1, f2)));
    }

    private void testJoinSucceeded(BiFunction<Future<String>, Future<Integer>, CompositeFuture> join) {
        Promise p1 = Promise.promise();
        Future f1 = p1.future();
        Promise p2 = Promise.promise();
        Future f2 = p2.future();
        CompositeFuture composite = join.apply((Future<String>)f1, (Future<Integer>)f2);
        FutureTestBase.Checker<CompositeFuture> checker = new FutureTestBase.Checker<CompositeFuture>(this, (Future<CompositeFuture>)composite);
        checker.assertNotCompleted();
        p1.complete((Object)"foo");
        checker.assertNotCompleted();
        p2.complete();
        checker.assertSucceeded(composite);
    }

    @Test
    public void testJoinFailed1() {
        this.testJoinFailed1(CompositeFuture::join);
    }

    @Test
    public void testJoinFailed1WithList() {
        this.testJoinFailed1((f1, f2) -> CompositeFuture.join(Arrays.asList(f1, f2)));
    }

    private void testJoinFailed1(BiFunction<Future<String>, Future<Integer>, CompositeFuture> join) {
        Promise p1 = Promise.promise();
        Future f1 = p1.future();
        Promise p2 = Promise.promise();
        Future f2 = p2.future();
        CompositeFuture composite = join.apply((Future<String>)f1, (Future<Integer>)f2);
        FutureTestBase.Checker checker = new FutureTestBase.Checker(this, composite);
        checker.assertNotCompleted();
        p1.complete((Object)"foo");
        checker.assertNotCompleted();
        Throwable cause = new Throwable();
        p2.fail(cause);
        this.assertSame(checker.assertFailed(), cause);
    }

    @Test
    public void testJoinFailed2() {
        this.testJoinFailed2(CompositeFuture::join);
    }

    @Test
    public void testJoinFailed2WithList() {
        this.testJoinFailed2((f1, f2) -> CompositeFuture.join(Arrays.asList(f1, f2)));
    }

    private void testJoinFailed2(BiFunction<Future<String>, Future<Integer>, CompositeFuture> join) {
        Promise p1 = Promise.promise();
        Future f1 = p1.future();
        Promise p2 = Promise.promise();
        Future f2 = p2.future();
        CompositeFuture composite = join.apply((Future<String>)f1, (Future<Integer>)f2);
        FutureTestBase.Checker checker = new FutureTestBase.Checker(this, composite);
        checker.assertNotCompleted();
        Throwable cause = new Throwable();
        p1.fail(cause);
        checker.assertNotCompleted();
        p2.complete((Object)10);
        this.assertSame(cause, checker.assertFailed());
    }

    @Test
    public void testJoinFailed3() {
        this.testJoinFailed3(CompositeFuture::join);
    }

    @Test
    public void testJoinFailed3WithList() {
        this.testJoinFailed3((f1, f2) -> CompositeFuture.join(Arrays.asList(f1, f2)));
    }

    private void testJoinFailed3(BiFunction<Future<String>, Future<Integer>, CompositeFuture> join) {
        Promise p1 = Promise.promise();
        Future f1 = p1.future();
        Promise p2 = Promise.promise();
        Future f2 = p2.future();
        CompositeFuture composite = join.apply((Future<String>)f1, (Future<Integer>)f2);
        FutureTestBase.Checker checker = new FutureTestBase.Checker(this, composite);
        checker.assertNotCompleted();
        Throwable cause1 = new Throwable();
        p1.fail(cause1);
        checker.assertNotCompleted();
        Throwable cause2 = new Throwable();
        p2.fail(cause2);
        this.assertSame(cause1, checker.assertFailed());
    }

    @Test
    public void testJoinWithEmptyList() {
        CompositeFuture composite = CompositeFuture.join(Collections.emptyList());
        this.assertTrue(composite.isComplete());
    }

    @Test
    public void testCompositeFutureToList() {
        Promise p1 = Promise.promise();
        Future f1 = p1.future();
        Promise p2 = Promise.promise();
        Future f2 = p2.future();
        CompositeFuture composite = CompositeFuture.all((Future)f1, (Future)f2);
        this.assertEquals(Arrays.asList(null, null), composite.list());
        p1.complete((Object)"foo");
        this.assertEquals(Arrays.asList("foo", null), composite.list());
        p2.complete((Object)4);
        this.assertEquals(Arrays.asList("foo", 4), composite.list());
    }

    @Test
    public void testCompositeFutureCauses() {
        CompositeFuture composite = CompositeFuture.all((Future)Future.failedFuture((String)"blabla"), (Future)Future.succeededFuture());
        this.assertEquals(2L, composite.causes().size());
        this.assertNotNull(composite.causes().get(0));
        this.assertEquals("blabla", ((Throwable)composite.causes().get(0)).getMessage());
        this.assertNull(composite.causes().get(1));
    }

    @Test
    public void testCompositeFutureMulti() {
        Promise p1 = Promise.promise();
        Future f1 = p1.future();
        Promise p2 = Promise.promise();
        Future f2 = p2.future();
        CompositeFuture composite = CompositeFuture.all((Future)f1, (Future)f2);
        AtomicInteger count = new AtomicInteger();
        composite.onComplete(ar -> count.compareAndSet(0, 1));
        composite.onComplete(ar -> count.compareAndSet(1, 2));
        p1.complete((Object)"foo");
        p2.complete((Object)4);
        this.assertEquals(2L, count.get());
    }

    private void testIndexOutOfBounds(ThrowableAssert.ThrowingCallable throwingCallable) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)throwingCallable).isExactlyInstanceOf(IndexOutOfBoundsException.class)).hasMessage(null);
    }

    @Test
    public void testIndexOutOfBounds() {
        CompositeFuture composite = CompositeFuture.all((Future)Future.succeededFuture(), (Future)Future.succeededFuture());
        this.testIndexOutOfBounds(() -> composite.resultAt(-2));
        this.testIndexOutOfBounds(() -> composite.resultAt(-1));
        this.testIndexOutOfBounds(() -> composite.resultAt(2));
        this.testIndexOutOfBounds(() -> composite.resultAt(3));
    }

    @Test
    public void testToString() {
        this.assertEquals("Future{result=(Future{result=null},Future{result=null})}", CompositeFuture.all((Future)Future.succeededFuture(), (Future)Future.succeededFuture()).toString());
        this.assertEquals("Future{result=(Future{result=true},Future{result=false})}", CompositeFuture.all((Future)Future.succeededFuture((Object)true), (Future)Future.succeededFuture((Object)false)).toString());
    }

    @Test
    public void testAllRemovesListeners1() {
        MonitoringFuture f = new MonitoringFuture();
        Future.all((Future)Future.failedFuture((String)""), (Future)f);
        this.assertEquals(Collections.emptySet(), f.listeners);
    }

    @Test
    public void testAllRemovesListeners2() {
        MonitoringFuture f = new MonitoringFuture();
        Future.all((Future)f, (Future)Future.failedFuture((String)""));
        this.assertEquals(Collections.emptySet(), f.listeners);
    }

    @Test
    public void testAnyRemovesListeners1() {
        MonitoringFuture f = new MonitoringFuture();
        Future.any((Future)Future.succeededFuture(), (Future)f);
        this.assertEquals(Collections.emptySet(), f.listeners);
    }

    @Test
    public void testAnyRemovesListeners2() {
        MonitoringFuture f = new MonitoringFuture();
        Future.any((Future)f, (Future)Future.succeededFuture());
        this.assertEquals(Collections.emptySet(), f.listeners);
    }

    @Test
    public void testCustomFuture() {
        Promise p1 = Promise.promise();
        Promise p2 = Promise.promise();
        Promise p3 = Promise.promise();
        CompositeFuture cf = Future.all((Future)p1.future(), (Future)new MyFuture(p2), (Future)p3.future());
        p1.complete(null);
        p2.complete(null);
        p3.complete(null);
        this.assertTrue(cf.isComplete());
    }

    private static class MyFuture
    implements Future<Void> {
        private final Future<Void> delegate;

        private MyFuture(Promise<Void> promise) {
            this.delegate = promise.future();
        }

        public boolean isComplete() {
            return this.delegate.isComplete();
        }

        public Future<Void> onComplete(Handler<AsyncResult<Void>> handler) {
            return this.delegate.onComplete(handler);
        }

        public Void result() {
            return (Void)this.delegate.result();
        }

        public Throwable cause() {
            return this.delegate.cause();
        }

        public boolean succeeded() {
            return this.delegate.succeeded();
        }

        public boolean failed() {
            return this.delegate.failed();
        }

        public <U> Future<U> compose(Function<Void, Future<U>> successMapper, Function<Throwable, Future<U>> failureMapper) {
            return this.delegate.compose(successMapper, failureMapper);
        }

        public <U> Future<U> transform(Function<AsyncResult<Void>, Future<U>> mapper) {
            return this.delegate.transform(mapper);
        }

        public <U> Future<Void> eventually(Function<Void, Future<U>> function) {
            return this.delegate.eventually(function);
        }

        public <U> Future<U> map(Function<Void, U> mapper) {
            return this.delegate.map(mapper);
        }

        public <V> Future<V> map(V value) {
            return this.delegate.map(value);
        }

        public Future<Void> otherwise(Function<Throwable, Void> mapper) {
            return this.delegate.otherwise(mapper);
        }

        public Future<Void> otherwise(Void value) {
            return this.delegate.otherwise((Object)value);
        }

        public Future<Void> expecting(Expectation<? super Void> expectation) {
            return this.delegate.expecting(expectation);
        }

        public Future<Void> timeout(long delay, TimeUnit unit) {
            return this.delegate.timeout(delay, unit);
        }
    }

    private static final class MonitoringFuture
    extends FutureImpl<Void> {
        Set<Listener<Void>> listeners = new HashSet<Listener<Void>>();

        private MonitoringFuture() {
        }

        public void addListener(Listener<Void> listener) {
            this.listeners.add(listener);
            super.addListener(listener);
        }

        public void removeListener(Listener<Void> listener) {
            this.listeners.remove(listener);
            super.removeListener(listener);
        }
    }
}

