/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.benchmarks;

import io.vertx.benchmarks.BenchmarkBase;
import io.vertx.core.net.impl.pool.CombinerExecutor;
import io.vertx.core.net.impl.pool.Executor;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Benchmark)
@Warmup(iterations=20, time=200, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=200, timeUnit=TimeUnit.MILLISECONDS)
@Threads(value=2)
public class CombinerExecutorBenchmark
extends BenchmarkBase {
    private Executor<Object> exec;
    private Executor.Action<Object> action;
    private CountDownLatch latch = new CountDownLatch(1);

    @Setup
    public void setup() throws Exception {
        this.exec = new CombinerExecutor(new Object());
        this.action = state -> {
            Blackhole.consumeCPU((long)0L);
            return null;
        };
        CountDownLatch l = new CountDownLatch(2);
        new Thread(() -> this.exec.submit(state -> {
            l.countDown();
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return null;
        })).start();
        l.await(20L, TimeUnit.SECONDS);
    }

    @TearDown
    public void tearDown() {
        this.latch.countDown();
    }

    @Benchmark
    public void impl() {
        this.exec.submit(this.action);
    }
}

