/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.vertx.core.impl.VertxInternal;

public final class PartialPooledByteBufAllocator
implements ByteBufAllocator {
    public static final PartialPooledByteBufAllocator INSTANCE = new PartialPooledByteBufAllocator();

    private PartialPooledByteBufAllocator() {
    }

    public ByteBuf buffer() {
        return VertxInternal.UNPOOLED_ALLOCATOR.heapBuffer();
    }

    public ByteBuf buffer(int initialCapacity) {
        return VertxInternal.UNPOOLED_ALLOCATOR.heapBuffer(initialCapacity);
    }

    public ByteBuf buffer(int initialCapacity, int maxCapacity) {
        return VertxInternal.UNPOOLED_ALLOCATOR.heapBuffer(initialCapacity, maxCapacity);
    }

    public ByteBuf ioBuffer() {
        return VertxInternal.POOLED_ALLOCATOR.directBuffer();
    }

    public ByteBuf ioBuffer(int initialCapacity) {
        return VertxInternal.POOLED_ALLOCATOR.directBuffer(initialCapacity);
    }

    public ByteBuf ioBuffer(int initialCapacity, int maxCapacity) {
        return VertxInternal.POOLED_ALLOCATOR.directBuffer(initialCapacity, maxCapacity);
    }

    public ByteBuf heapBuffer() {
        return VertxInternal.UNPOOLED_ALLOCATOR.heapBuffer();
    }

    public ByteBuf heapBuffer(int initialCapacity) {
        return VertxInternal.UNPOOLED_ALLOCATOR.heapBuffer(initialCapacity);
    }

    public ByteBuf heapBuffer(int initialCapacity, int maxCapacity) {
        return VertxInternal.UNPOOLED_ALLOCATOR.heapBuffer(initialCapacity, maxCapacity);
    }

    public ByteBuf directBuffer() {
        return VertxInternal.POOLED_ALLOCATOR.directBuffer();
    }

    public ByteBuf directBuffer(int initialCapacity) {
        return VertxInternal.POOLED_ALLOCATOR.directBuffer(initialCapacity);
    }

    public ByteBuf directBuffer(int initialCapacity, int maxCapacity) {
        return VertxInternal.POOLED_ALLOCATOR.directBuffer(initialCapacity, maxCapacity);
    }

    public CompositeByteBuf compositeBuffer() {
        return VertxInternal.UNPOOLED_ALLOCATOR.compositeHeapBuffer();
    }

    public CompositeByteBuf compositeBuffer(int maxNumComponents) {
        return VertxInternal.UNPOOLED_ALLOCATOR.compositeHeapBuffer(maxNumComponents);
    }

    public CompositeByteBuf compositeHeapBuffer() {
        return VertxInternal.UNPOOLED_ALLOCATOR.compositeHeapBuffer();
    }

    public CompositeByteBuf compositeHeapBuffer(int maxNumComponents) {
        return VertxInternal.UNPOOLED_ALLOCATOR.compositeHeapBuffer(maxNumComponents);
    }

    public CompositeByteBuf compositeDirectBuffer() {
        return VertxInternal.POOLED_ALLOCATOR.compositeDirectBuffer();
    }

    public CompositeByteBuf compositeDirectBuffer(int maxNumComponents) {
        return VertxInternal.POOLED_ALLOCATOR.compositeDirectBuffer();
    }

    public boolean isDirectBufferPooled() {
        return true;
    }

    public int calculateNewCapacity(int minNewCapacity, int maxCapacity) {
        return VertxInternal.POOLED_ALLOCATOR.calculateNewCapacity(minNewCapacity, maxCapacity);
    }
}

