/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.buffer.impl;

import io.netty.buffer.AbstractByteBufAllocator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.internal.PlatformDependent;
import io.vertx.core.buffer.impl.VertxHeapByteBuf;
import io.vertx.core.buffer.impl.VertxUnsafeHeapByteBuf;
import io.vertx.core.impl.VertxInternal;

public abstract class VertxByteBufAllocator
extends AbstractByteBufAllocator {
    private static final VertxByteBufAllocator UNSAFE_IMPL = new VertxByteBufAllocator(){

        protected ByteBuf newHeapBuffer(int initialCapacity, int maxCapacity) {
            return new VertxUnsafeHeapByteBuf((ByteBufAllocator)this, initialCapacity, maxCapacity);
        }
    };
    private static final VertxByteBufAllocator IMPL = new VertxByteBufAllocator(){

        protected ByteBuf newHeapBuffer(int initialCapacity, int maxCapacity) {
            return new VertxHeapByteBuf((ByteBufAllocator)this, initialCapacity, maxCapacity);
        }
    };
    public static final VertxByteBufAllocator DEFAULT = PlatformDependent.hasUnsafe() ? UNSAFE_IMPL : IMPL;

    protected ByteBuf newDirectBuffer(int initialCapacity, int maxCapacity) {
        return VertxInternal.UNPOOLED_ALLOCATOR.directBuffer(initialCapacity, maxCapacity);
    }

    public boolean isDirectBufferPooled() {
        return false;
    }
}

