/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.impl.VertxImpl;
import io.vertx.core.impl.VertxThread;
import io.vertx.core.impl.future.FailedFuture;
import io.vertx.core.impl.future.PromiseImpl;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.future.SucceededFuture;
import io.vertx.core.impl.launcher.VertxCommandLauncher;
import java.util.List;

abstract class AbstractContext
implements ContextInternal {
    AbstractContext() {
    }

    @Override
    public abstract boolean isEventLoopContext();

    @Override
    public final boolean isRunningOnContext() {
        return Vertx.currentContext() == this && this.inThread();
    }

    abstract boolean inThread();

    @Override
    public boolean isWorkerContext() {
        return !this.isEventLoopContext();
    }

    @Override
    public void emit(Handler<Void> task) {
        this.emit(null, task);
    }

    @Override
    public final void execute(Handler<Void> task) {
        this.execute(null, task);
    }

    @Override
    public final void dispatch(Handler<Void> handler) {
        this.dispatch((T)null, (Handler)handler);
    }

    @Override
    public final ContextInternal beginDispatch() {
        VertxThread th = (VertxThread)((Object)Thread.currentThread());
        ContextInternal prev = th.beginEmission(this);
        if (!VertxThread.DISABLE_TCCL) {
            th.setContextClassLoader(this.classLoader());
        }
        return prev;
    }

    @Override
    public final void endDispatch(ContextInternal previous) {
        VertxThread th = (VertxThread)((Object)Thread.currentThread());
        if (!VertxThread.DISABLE_TCCL) {
            th.setContextClassLoader(previous != null ? previous.classLoader() : null);
        }
        th.endEmission(previous);
    }

    @Override
    public long setPeriodic(long delay, Handler<Long> handler) {
        VertxImpl owner = (VertxImpl)this.owner();
        return owner.scheduleTimeout(this, handler, delay, true);
    }

    @Override
    public long setTimer(long delay, Handler<Long> handler) {
        VertxImpl owner = (VertxImpl)this.owner();
        return owner.scheduleTimeout(this, handler, delay, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> void dispatch(T event, Handler<T> handler) {
        ContextInternal prev = this.beginDispatch();
        try {
            handler.handle(event);
        }
        catch (Throwable t) {
            this.reportException(t);
        }
        finally {
            this.endDispatch(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void dispatch(Runnable handler) {
        ContextInternal prev = this.beginDispatch();
        try {
            handler.run();
        }
        catch (Throwable t) {
            this.reportException(t);
        }
        finally {
            this.endDispatch(prev);
        }
    }

    @Override
    public final List<String> processArgs() {
        return VertxCommandLauncher.getProcessArguments();
    }

    @Override
    public final <T> void executeBlockingInternal(Handler<Promise<T>> action, Handler<AsyncResult<T>> resultHandler) {
        Future<T> fut = this.executeBlockingInternal(action);
        AbstractContext.setResultHandler(this, fut, resultHandler);
    }

    @Override
    public <T> void executeBlockingInternal(Handler<Promise<T>> action, boolean ordered, Handler<AsyncResult<T>> resultHandler) {
        Future<T> fut = this.executeBlockingInternal(action, ordered);
        AbstractContext.setResultHandler(this, fut, resultHandler);
    }

    @Override
    public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<T>> resultHandler) {
        Future<T> fut = this.executeBlocking(blockingCodeHandler, ordered);
        AbstractContext.setResultHandler(this, fut, resultHandler);
    }

    @Override
    public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, TaskQueue queue, Handler<AsyncResult<T>> resultHandler) {
        Future<T> fut = this.executeBlocking(blockingCodeHandler, queue);
        AbstractContext.setResultHandler(this, fut, resultHandler);
    }

    @Override
    public final <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, Handler<AsyncResult<T>> resultHandler) {
        this.executeBlocking(blockingCodeHandler, true, resultHandler);
    }

    @Override
    public <T> Future<T> executeBlocking(Handler<Promise<T>> blockingCodeHandler) {
        return this.executeBlocking(blockingCodeHandler, true);
    }

    @Override
    public <T> PromiseInternal<T> promise() {
        return new PromiseImpl(this);
    }

    @Override
    public <T> PromiseInternal<T> promise(Handler<AsyncResult<T>> handler) {
        PromiseInternal<T> promise;
        if (handler instanceof PromiseInternal && (promise = (PromiseInternal<T>)handler).context() != null) {
            return promise;
        }
        promise = this.promise();
        promise.future().onComplete(handler);
        return promise;
    }

    @Override
    public <T> Future<T> succeededFuture() {
        return new SucceededFuture<Object>(this, null);
    }

    @Override
    public <T> Future<T> succeededFuture(T result) {
        return new SucceededFuture<T>(this, result);
    }

    @Override
    public <T> Future<T> failedFuture(Throwable failure) {
        return new FailedFuture((ContextInternal)this, failure);
    }

    @Override
    public <T> Future<T> failedFuture(String message) {
        return new FailedFuture((ContextInternal)this, message);
    }

    @Override
    public final <T> T get(String key) {
        return (T)this.contextData().get(key);
    }

    @Override
    public final void put(String key, Object value) {
        this.contextData().put(key, value);
    }

    @Override
    public final boolean remove(String key) {
        return this.contextData().remove(key) != null;
    }

    @Override
    public final <T> T getLocal(String key) {
        return (T)this.localContextData().get(key);
    }

    @Override
    public final void putLocal(String key, Object value) {
        this.localContextData().put(key, value);
    }

    @Override
    public final boolean removeLocal(String key) {
        return this.localContextData().remove(key) != null;
    }

    private static <T> void setResultHandler(ContextInternal ctx, Future<T> fut, Handler<AsyncResult<T>> resultHandler) {
        if (resultHandler != null) {
            fut.onComplete(resultHandler);
        } else {
            fut.onFailure(ctx::reportException);
        }
    }
}

