/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http2.Http2Headers;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerFileUpload;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.http.impl.Http1xServerRequest;
import io.vertx.core.http.impl.Http2ServerConnection;
import io.vertx.core.http.impl.Http2ServerResponse;
import io.vertx.core.http.impl.Http2ServerStream;
import io.vertx.core.http.impl.HttpEventHandler;
import io.vertx.core.http.impl.HttpServerRequestInternal;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.NettyFileUpload;
import io.vertx.core.http.impl.NettyFileUploadDataFactory;
import io.vertx.core.http.impl.headers.Http2HeadersAdaptor;
import io.vertx.core.http.impl.netty.HttpPostRequestDecoder;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.spi.observability.HttpRequest;
import io.vertx.core.spi.tracing.SpanKind;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingPolicy;
import java.net.URISyntaxException;
import java.nio.channels.ClosedChannelException;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;

public class Http2ServerRequest
extends Http2ServerStream
implements HttpServerRequestInternal,
HttpRequest {
    private static final Logger log = LoggerFactory.getLogger(Http1xServerRequest.class);
    private final String serverOrigin;
    private final MultiMap headersMap;
    private final String scheme;
    private final TracingPolicy tracingPolicy;
    private Object trace;
    private MultiMap params;
    private String absoluteURI;
    private MultiMap attributes;
    private HttpEventHandler eventHandler;
    private boolean streamEnded;
    private boolean ended;
    private Handler<HttpServerFileUpload> uploadHandler;
    private HttpPostRequestDecoder postRequestDecoder;
    private Handler<HttpFrame> customFrameHandler;
    private Handler<StreamPriority> streamPriorityHandler;

    Http2ServerRequest(Http2ServerConnection conn, TracingPolicy tracingPolicy, ContextInternal context, String serverOrigin, Http2Headers headers, String contentEncoding, boolean streamEnded) {
        super(conn, context, headers, contentEncoding, serverOrigin);
        String scheme = headers.get((Object)":scheme") != null ? ((CharSequence)headers.get((Object)":scheme")).toString() : null;
        headers.remove((Object)":method");
        headers.remove((Object)":scheme");
        headers.remove((Object)":path");
        headers.remove((Object)":authority");
        this.serverOrigin = serverOrigin;
        this.streamEnded = streamEnded;
        this.scheme = scheme;
        this.headersMap = new Http2HeadersAdaptor(headers);
        this.tracingPolicy = tracingPolicy;
    }

    private HttpEventHandler eventHandler(boolean create) {
        if (this.eventHandler == null && create) {
            this.eventHandler = new HttpEventHandler(this.context);
        }
        return this.eventHandler;
    }

    @Override
    void dispatch(Handler<HttpServerRequest> handler) {
        VertxTracer tracer = this.context.tracer();
        if (tracer != null) {
            this.trace = tracer.receiveRequest(this.context, SpanKind.RPC, this.tracingPolicy, this, this.method().name(), this.headers(), HttpUtils.SERVER_REQUEST_TAG_EXTRACTOR);
        }
        this.context.emit(this, handler);
    }

    @Override
    void handleWritabilityChanged(boolean writable) {
        this.response.handlerWritabilityChanged(writable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void handleException(Throwable cause) {
        boolean notify;
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            notify = !this.ended;
        }
        if (notify) {
            this.notifyException(cause);
        }
        this.response.handleException(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyException(Throwable failure) {
        HttpEventHandler handler;
        InterfaceHttpData upload = null;
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            if (this.postRequestDecoder != null) {
                upload = this.postRequestDecoder.currentPartialHttpData();
            }
            handler = this.eventHandler;
        }
        if (handler != null) {
            handler.handleException(failure);
        }
        if (upload instanceof NettyFileUpload) {
            ((NettyFileUpload)upload).handleException(failure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void onClose() {
        VertxTracer tracer = this.context.tracer();
        Object trace = this.trace;
        if (tracer != null && trace != null) {
            VertxException failure;
            Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
            synchronized (http2ServerConnection) {
                failure = !this.streamEnded && (!this.ended || !this.response.ended()) ? ConnectionBase.CLOSED_EXCEPTION : null;
            }
            tracer.sendResponse(this.context, failure == null ? this.response : null, trace, failure, HttpUtils.SERVER_RESPONSE_TAG_EXTRACTOR);
        }
        super.onClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void handleClose() {
        boolean notify;
        super.handleClose();
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            notify = !this.streamEnded;
        }
        if (notify) {
            this.notifyException(new ClosedChannelException());
        }
        this.response.handleClose();
    }

    @Override
    void handleCustomFrame(HttpFrame frame) {
        if (this.customFrameHandler != null) {
            this.customFrameHandler.handle(frame);
        }
    }

    @Override
    void handleData(Buffer data) {
        HttpEventHandler handler;
        if (this.postRequestDecoder != null) {
            try {
                this.postRequestDecoder.offer((HttpContent)new DefaultHttpContent(data.getByteBuf()));
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        if ((handler = this.eventHandler) != null) {
            handler.handleChunk(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void handleEnd(MultiMap trailers) {
        HttpEventHandler handler;
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            this.streamEnded = true;
            this.ended = true;
            if (this.postRequestDecoder != null) {
                try {
                    this.postRequestDecoder.offer((HttpContent)LastHttpContent.EMPTY_LAST_CONTENT);
                    while (this.postRequestDecoder.hasNext()) {
                        InterfaceHttpData data = this.postRequestDecoder.next();
                        if (!(data instanceof Attribute)) continue;
                        Attribute attr = (Attribute)data;
                        try {
                            this.formAttributes().add(attr.getName(), attr.getValue());
                        }
                        catch (Exception e) {
                            this.handleException(e);
                        }
                        finally {
                            attr.release();
                        }
                    }
                }
                catch (HttpPostRequestDecoder.EndOfDataDecoderException data) {
                }
                catch (Exception e) {
                    this.handleException(e);
                }
                finally {
                    this.postRequestDecoder.destroy();
                }
            }
            handler = this.eventHandler;
        }
        if (handler != null) {
            handler.handleEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void handleReset(long errorCode) {
        boolean notify;
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            notify = !this.ended;
            this.ended = true;
        }
        if (notify) {
            this.notifyException(new StreamResetException(errorCode));
        }
        this.response.handleReset(errorCode);
    }

    private void checkEnded() {
        if (this.ended) {
            throw new IllegalStateException("Request has already been read");
        }
    }

    @Override
    public Context context() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest exceptionHandler(Handler<Throwable> handler) {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            HttpEventHandler eventHandler = this.eventHandler(handler != null);
            if (eventHandler != null) {
                eventHandler.exceptionHandler(handler);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest handler(Handler<Buffer> handler) {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            HttpEventHandler eventHandler;
            if (handler != null) {
                this.checkEnded();
            }
            if ((eventHandler = this.eventHandler(handler != null)) != null) {
                eventHandler.chunkHandler(handler);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest pause() {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            this.checkEnded();
            this.doPause();
        }
        return this;
    }

    @Override
    public HttpServerRequest resume() {
        return this.fetch(Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest fetch(long amount) {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            this.checkEnded();
            this.doFetch(amount);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest endHandler(Handler<Void> handler) {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            HttpEventHandler eventHandler;
            if (handler != null) {
                this.checkEnded();
            }
            if ((eventHandler = this.eventHandler(handler != null)) != null) {
                eventHandler.endHandler(handler);
            }
        }
        return this;
    }

    @Override
    public HttpVersion version() {
        return HttpVersion.HTTP_2;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String path() {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            return this.uri != null ? HttpUtils.parsePath(this.uri) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String query() {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            return this.uri != null ? HttpUtils.parseQuery(this.uri) : null;
        }
    }

    @Override
    public String scheme() {
        return this.scheme;
    }

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public long bytesRead() {
        return super.bytesRead();
    }

    @Override
    public Http2ServerResponse response() {
        return this.response;
    }

    @Override
    public MultiMap headers() {
        return this.headersMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiMap params() {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            if (this.params == null) {
                this.params = HttpUtils.params(this.uri());
            }
            return this.params;
        }
    }

    @Override
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return ((Http2ServerConnection)this.conn).peerCertificateChain();
    }

    @Override
    public SocketAddress remoteAddress() {
        return ((Http2ServerConnection)this.conn).remoteAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String absoluteURI() {
        if (this.method == HttpMethod.CONNECT) {
            return null;
        }
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            if (this.absoluteURI == null) {
                try {
                    this.absoluteURI = HttpUtils.absoluteURI(this.serverOrigin, this);
                }
                catch (URISyntaxException e) {
                    log.error("Failed to create abs uri", e);
                }
            }
            return this.absoluteURI;
        }
    }

    @Override
    public Future<NetSocket> toNetSocket() {
        return this.response.netSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest setExpectMultipart(boolean expect) {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            this.checkEnded();
            if (expect) {
                if (this.postRequestDecoder == null) {
                    String contentType = this.headersMap.get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
                    if (contentType == null) {
                        throw new IllegalStateException("Request must have a content-type header to decode a multipart request");
                    }
                    if (!HttpUtils.isValidMultipartContentType(contentType)) {
                        throw new IllegalStateException("Request must have a valid content-type header to decode a multipart request");
                    }
                    if (!HttpUtils.isValidMultipartMethod(this.method.toNetty())) {
                        throw new IllegalStateException("Request method must be one of POST, PUT, PATCH or DELETE to decode a multipart request");
                    }
                    DefaultHttpRequest req = new DefaultHttpRequest(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, this.method.toNetty(), this.uri);
                    req.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
                    NettyFileUploadDataFactory factory = new NettyFileUploadDataFactory(this.context, this, () -> this.uploadHandler);
                    factory.setMaxLimit(((Http2ServerConnection)this.conn).options.getMaxFormAttributeSize());
                    this.postRequestDecoder = new HttpPostRequestDecoder((HttpDataFactory)factory, (io.netty.handler.codec.http.HttpRequest)req);
                }
            } else {
                this.postRequestDecoder = null;
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExpectMultipart() {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            return this.postRequestDecoder != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest uploadHandler(@Nullable Handler<HttpServerFileUpload> handler) {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            if (handler != null) {
                this.checkEnded();
            }
            this.uploadHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiMap formAttributes() {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            if (this.attributes == null) {
                this.attributes = MultiMap.caseInsensitiveMultiMap();
            }
            return this.attributes;
        }
    }

    @Override
    public String getFormAttribute(String attributeName) {
        return this.formAttributes().get(attributeName);
    }

    @Override
    public int streamId() {
        return this.stream.id();
    }

    @Override
    public Future<ServerWebSocket> toWebSocket() {
        return this.context.failedFuture("HTTP/2 request cannot be upgraded to a WebSocket");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEnded() {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            return this.ended;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest customFrameHandler(Handler<HttpFrame> handler) {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            this.customFrameHandler = handler;
        }
        return this;
    }

    @Override
    public HttpConnection connection() {
        return this.conn;
    }

    @Override
    public synchronized Future<Buffer> body() {
        this.checkEnded();
        return this.eventHandler(true).body();
    }

    @Override
    public synchronized Future<Void> end() {
        this.checkEnded();
        return this.eventHandler(true).end();
    }

    @Override
    public StreamPriority streamPriority() {
        return this.priority();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest streamPriorityHandler(Handler<StreamPriority> handler) {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            this.streamPriorityHandler = handler;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void handlePriorityChange(StreamPriority streamPriority) {
        Handler<StreamPriority> handler;
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            handler = this.streamPriorityHandler;
        }
        if (handler != null) {
            handler.handle(streamPriority);
        }
    }

    @Override
    public Map<String, Cookie> cookieMap() {
        return this.response.cookies();
    }

    @Override
    public HttpServerRequest routed(String route) {
        super.routed(route);
        return this;
    }
}

