/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.impl.HttpClientRequestBase;
import io.vertx.core.http.impl.HttpClientStream;
import io.vertx.core.http.impl.headers.HeadersAdaptor;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.List;

public class HttpClientResponseImpl
implements HttpClientResponse {
    private static final Logger log = LoggerFactory.getLogger(HttpClientResponseImpl.class);
    private final HttpVersion version;
    private final int statusCode;
    private final String statusMessage;
    private final HttpClientRequestBase request;
    private final HttpConnection conn;
    private final HttpClientStream stream;
    private Handler<Buffer> dataHandler;
    private Handler<HttpFrame> customFrameHandler;
    private Handler<Void> endHandler;
    private Handler<Throwable> exceptionHandler;
    private Handler<StreamPriority> priorityHandler;
    private MultiMap headers;
    private MultiMap trailers;
    private List<String> cookies;

    HttpClientResponseImpl(HttpClientRequestBase request, HttpVersion version, HttpClientStream stream, int statusCode, String statusMessage, MultiMap headers) {
        this.version = version;
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.request = request;
        this.stream = stream;
        this.conn = stream.connection();
        this.headers = headers;
    }

    @Override
    public HttpClientRequestBase request() {
        return this.request;
    }

    @Override
    public HttpVersion version() {
        return this.version;
    }

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    public String statusMessage() {
        return this.statusMessage;
    }

    @Override
    public MultiMap headers() {
        return this.headers;
    }

    @Override
    public String getHeader(String headerName) {
        return this.headers.get(headerName);
    }

    @Override
    public String getHeader(CharSequence headerName) {
        return this.headers.get(headerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiMap trailers() {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            if (this.trailers == null) {
                this.trailers = new HeadersAdaptor((io.netty.handler.codec.http.HttpHeaders)new DefaultHttpHeaders());
            }
            return this.trailers;
        }
    }

    @Override
    public String getTrailer(String trailerName) {
        return this.trailers != null ? this.trailers.get(trailerName) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> cookies() {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            if (this.cookies == null) {
                this.cookies = new ArrayList<String>();
                this.cookies.addAll(this.headers().getAll(HttpHeaders.SET_COOKIE));
                if (this.trailers != null) {
                    this.cookies.addAll(this.trailers.getAll(HttpHeaders.SET_COOKIE));
                }
            }
            return this.cookies;
        }
    }

    private void checkEnded() {
        if (this.trailers != null) {
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientResponse handler(Handler<Buffer> handler) {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            if (handler != null) {
                this.checkEnded();
            }
            this.dataHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientResponse endHandler(Handler<Void> handler) {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            if (handler != null) {
                this.checkEnded();
            }
            this.endHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientResponse exceptionHandler(Handler<Throwable> handler) {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            if (handler != null) {
                this.checkEnded();
            }
            this.exceptionHandler = handler;
            return this;
        }
    }

    @Override
    public HttpClientResponse pause() {
        this.stream.doPause();
        return this;
    }

    @Override
    public HttpClientResponse resume() {
        return this.fetch(Long.MAX_VALUE);
    }

    @Override
    public HttpClientResponse fetch(long amount) {
        this.stream.doFetch(amount);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientResponse customFrameHandler(Handler<HttpFrame> handler) {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            if (this.endHandler != null) {
                this.checkEnded();
            }
            this.customFrameHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleUnknownFrame(HttpFrame frame) {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            if (this.customFrameHandler != null) {
                this.customFrameHandler.handle(frame);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleChunk(Buffer data) {
        Handler<Buffer> handler;
        this.request.dataReceived();
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            handler = this.dataHandler;
            if (handler == null) {
                return;
            }
        }
        this.request.context.emit(data, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleEnd(MultiMap trailers) {
        Handler<Void> handler;
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            this.trailers = trailers;
            handler = this.endHandler;
            this.endHandler = null;
            if (handler == null) {
                return;
            }
        }
        this.request.context.emit(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleException(Throwable e) {
        Handler<Throwable> handler;
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            if (this.trailers != null) {
                return;
            }
            handler = this.exceptionHandler;
            if (handler == null) {
                handler = log::error;
            }
        }
        handler.handle(e);
    }

    @Override
    public HttpClientResponse bodyHandler(Handler<Buffer> bodyHandler) {
        BodyHandler handler = new BodyHandler();
        this.handler((Handler)handler);
        this.endHandler(handler::handleEnd);
        handler.promise.future().onComplete(ar -> {
            if (ar.succeeded()) {
                bodyHandler.handle((Buffer)ar.result());
            }
        });
        return this;
    }

    @Override
    public Future<Buffer> body() {
        BodyHandler handler = new BodyHandler();
        this.handler((Handler)handler);
        this.exceptionHandler(handler::handleException);
        this.endHandler(handler::handleEnd);
        return handler.promise.future();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientResponse streamPriorityHandler(Handler<StreamPriority> handler) {
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            if (handler != null) {
                this.checkEnded();
            }
            this.priorityHandler = handler;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlePriorityChange(StreamPriority streamPriority) {
        Handler<StreamPriority> handler;
        HttpConnection httpConnection = this.conn;
        synchronized (httpConnection) {
            handler = this.priorityHandler;
        }
        if (handler != null) {
            handler.handle(streamPriority);
        }
    }

    private static final class BodyHandler
    implements Handler<Buffer> {
        private Promise<Buffer> promise = Promise.promise();
        private Buffer body = Buffer.buffer();

        private BodyHandler() {
        }

        @Override
        public void handle(Buffer event) {
            this.body.appendBuffer(event);
        }

        void handleEnd(Void v) {
            this.promise.tryComplete(this.body);
        }

        void handleException(Throwable err) {
            this.promise.tryFail(err);
        }
    }
}

