/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.http.impl.Http2ConnectionBase;
import io.vertx.core.http.impl.HttpClientConnection;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.HttpClientRequestBase;
import io.vertx.core.http.impl.HttpClientRequestImpl;
import io.vertx.core.http.impl.HttpClientRequestPushPromise;
import io.vertx.core.http.impl.HttpClientResponseImpl;
import io.vertx.core.http.impl.HttpClientStream;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.VertxHttp2ConnectionHandler;
import io.vertx.core.http.impl.VertxHttp2ConnectionHandlerBuilder;
import io.vertx.core.http.impl.VertxHttp2Stream;
import io.vertx.core.http.impl.headers.Http2HeadersAdaptor;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.net.impl.clientconnection.ConnectionListener;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.core.spi.tracing.VertxTracer;
import java.util.Map;
import java.util.function.BiConsumer;

class Http2ClientConnection
extends Http2ConnectionBase
implements HttpClientConnection {
    private final ConnectionListener<HttpClientConnection> listener;
    private final HttpClientImpl client;
    private final HttpClientMetrics metrics;
    private final Object queueMetric;
    private long expirationTimestamp;

    Http2ClientConnection(ConnectionListener<HttpClientConnection> listener, Object queueMetric, HttpClientImpl client, ContextInternal context, VertxHttp2ConnectionHandler connHandler, HttpClientMetrics metrics) {
        super(context, connHandler);
        this.metrics = metrics;
        this.queueMetric = queueMetric;
        this.client = client;
        this.listener = listener;
    }

    @Override
    synchronized boolean onGoAwaySent(int lastStreamId, long errorCode, ByteBuf debugData) {
        boolean goneAway = super.onGoAwaySent(lastStreamId, errorCode, debugData);
        if (goneAway) {
            this.listener.onEvict();
        }
        return goneAway;
    }

    @Override
    synchronized boolean onGoAwayReceived(int lastStreamId, long errorCode, ByteBuf debugData) {
        boolean goneAway = super.onGoAwayReceived(lastStreamId, errorCode, debugData);
        if (goneAway) {
            this.listener.onEvict();
        }
        return goneAway;
    }

    @Override
    protected void concurrencyChanged(long concurrency) {
        int limit = this.client.getOptions().getHttp2MultiplexingLimit();
        if (limit > 0) {
            concurrency = Math.min(concurrency, (long)limit);
        }
        this.listener.onConcurrencyChange(concurrency);
    }

    @Override
    public HttpClientMetrics metrics() {
        return this.metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void upgradeStream(Object metric, HttpClientRequestImpl req, Promise<NetSocket> netSocketPromise, ContextInternal context, Handler<AsyncResult<HttpClientStream>> completionHandler) {
        Future<Object> fut;
        Http2ClientConnection http2ClientConnection = this;
        synchronized (http2ClientConnection) {
            try {
                StreamImpl stream = this.createStream(context, req, netSocketPromise);
                stream.init(this.handler.connection().stream(1));
                ((Stream)stream).metric = metric;
                fut = Future.succeededFuture(stream);
            }
            catch (Exception e) {
                fut = Future.failedFuture(e);
            }
        }
        completionHandler.handle(fut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createStream(ContextInternal context, HttpClientRequestImpl req, Promise<NetSocket> netSocketPromise, Handler<AsyncResult<HttpClientStream>> completionHandler) {
        Future<Object> fut;
        Http2ClientConnection http2ClientConnection = this;
        synchronized (http2ClientConnection) {
            try {
                StreamImpl stream = this.createStream(context, req, netSocketPromise);
                VertxTracer tracer = context.tracer();
                if (tracer != null) {
                    BiConsumer<String, String> headers = (key, val) -> req.headers().add((String)key, (String)val);
                    ((Stream)stream).trace = tracer.sendRequest(context, req, req.method.name(), headers, HttpUtils.CLIENT_REQUEST_TAG_EXTRACTOR);
                }
                fut = Future.succeededFuture(stream);
            }
            catch (Exception e) {
                fut = Future.failedFuture(e);
            }
        }
        context.dispatch(fut, completionHandler);
    }

    private StreamImpl createStream(ContextInternal context, HttpClientRequestImpl req, Promise<NetSocket> netSocketPromise) {
        return new StreamImpl(this, context, req, netSocketPromise);
    }

    private void recycle() {
        int timeout = this.client.getOptions().getHttp2KeepAliveTimeout();
        long expired = timeout > 0 ? System.currentTimeMillis() + (long)(timeout * 1000) : 0L;
        this.expirationTimestamp = timeout > 0 ? System.currentTimeMillis() + (long)(timeout * 1000) : 0L;
        this.listener.onRecycle();
    }

    @Override
    public boolean isValid() {
        return this.expirationTimestamp == 0L || System.currentTimeMillis() <= this.expirationTimestamp;
    }

    @Override
    protected synchronized void onHeadersRead(int streamId, Http2Headers headers, StreamPriority streamPriority, boolean endOfStream) {
        Stream stream = (Stream)this.stream(streamId);
        if (!stream.stream.isTrailersReceived()) {
            stream.onHeaders(headers, streamPriority);
            if (endOfStream) {
                stream.onEnd();
            }
        } else {
            stream.onEnd(new Http2HeadersAdaptor(headers));
        }
    }

    private void metricsEnd(Stream stream) {
        if (this.metrics != null) {
            this.metrics.responseEnd(stream.metric, stream.response);
        }
    }

    @Override
    public synchronized void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
        Handler<HttpClientRequest> pushHandler;
        StreamImpl stream = (StreamImpl)this.stream(streamId);
        if (stream != null && (pushHandler = stream.pushHandler()) != null) {
            int port;
            String host;
            String rawMethod = headers.method().toString();
            HttpMethod method = HttpMethod.valueOf(rawMethod);
            String uri = headers.path().toString();
            String authority = headers.authority() != null ? headers.authority().toString() : null;
            Http2HeadersAdaptor headersMap = new Http2HeadersAdaptor(headers);
            Http2Stream promisedStream = this.handler.connection().stream(promisedStreamId);
            int pos = authority.indexOf(58);
            if (pos == -1) {
                host = authority;
                port = 80;
            } else {
                host = authority.substring(0, pos);
                port = Integer.parseInt(authority.substring(pos + 1));
            }
            HttpClientRequestPushPromise pushReq = new HttpClientRequestPushPromise(this, this.client, this.isSsl(), method, uri, host, port, headersMap);
            pushReq.getStream().init(promisedStream);
            if (this.metrics != null) {
                ((Stream)pushReq.getStream()).metric = this.metrics.responsePushed(this.queueMetric, this.metric(), this.localAddress(), this.remoteAddress(), pushReq);
            }
            stream.context.emit(pushReq, pushHandler);
            return;
        }
        this.handler.writeReset(promisedStreamId, Http2Error.CANCEL.code());
    }

    @Override
    protected void handleIdle() {
        if (this.handler.connection().local().numActiveStreams() > 0) {
            super.handleIdle();
        }
    }

    public static VertxHttp2ConnectionHandler<Http2ClientConnection> createHttp2ConnectionHandler(HttpClientImpl client, Object queueMetric, ConnectionListener<HttpClientConnection> listener, ContextInternal context, Object socketMetric, BiConsumer<Http2ClientConnection, Long> c) {
        long http2MaxConcurrency = client.getOptions().getHttp2MultiplexingLimit() <= 0 ? Long.MAX_VALUE : (long)client.getOptions().getHttp2MultiplexingLimit();
        HttpClientOptions options = client.getOptions();
        HttpClientMetrics metrics = client.metrics();
        Http2ConnectionHandler handler = new VertxHttp2ConnectionHandlerBuilder().server(false).useCompression(client.getOptions().isTryUseCompression()).gracefulShutdownTimeoutMillis(0L).initialSettings(client.getOptions().getInitialSettings()).connectionFactory(connHandler -> new Http2ClientConnection(listener, queueMetric, client, context, (VertxHttp2ConnectionHandler)((Object)connHandler), metrics)).logEnabled(options.getLogActivity()).build();
        handler.addHandler(conn -> {
            if (options.getHttp2ConnectionWindowSize() > 0) {
                conn.setWindowSize(options.getHttp2ConnectionWindowSize());
            }
            if (metrics != null) {
                Object m = socketMetric;
                if (m == null) {
                    m = metrics.connected(conn.remoteAddress(), conn.remoteName());
                    metrics.endpointConnected(queueMetric, m);
                }
                conn.metric(m);
            }
            long concurrency = conn.remoteSettings().getMaxConcurrentStreams();
            if (http2MaxConcurrency > 0L) {
                concurrency = Math.min(concurrency, http2MaxConcurrency);
            }
            c.accept((Http2ClientConnection)conn, concurrency);
        });
        handler.removeHandler(conn -> {
            if (metrics != null) {
                metrics.endpointDisconnected(queueMetric, conn.metric());
            }
            listener.onEvict();
        });
        return handler;
    }

    static class StreamImpl
    extends Stream
    implements HttpClientStream {
        private HttpClientResponseImpl response;

        StreamImpl(Http2ClientConnection conn, ContextInternal context, HttpClientRequestBase request, Promise<NetSocket> netSocketPromise) {
            super(conn, request, netSocketPromise, context);
        }

        @Override
        public StreamPriority priority() {
            return super.priority();
        }

        @Override
        public void updatePriority(StreamPriority streamPriority) {
            super.updatePriority(streamPriority);
        }

        @Override
        public HttpVersion version() {
            return HttpVersion.HTTP_2;
        }

        @Override
        void handleEnd(MultiMap trailers) {
            this.response.handleEnd(trailers);
        }

        @Override
        void handleData(Buffer buf) {
            this.response.handleChunk(buf);
        }

        @Override
        void handleReset(long errorCode) {
            this.handleException(new StreamResetException(errorCode));
        }

        @Override
        void handleClose() {
            super.handleClose();
        }

        @Override
        void handleWritabilityChanged(boolean writable) {
            if (this.request instanceof HttpClientRequestImpl && writable) {
                ((HttpClientRequestImpl)this.request).handleDrained();
            }
        }

        @Override
        void handleCustomFrame(HttpFrame frame) {
            if (this.response != null) {
                this.response.handleUnknownFrame(frame);
            }
        }

        @Override
        void handlePriorityChange(StreamPriority streamPriority) {
            if (this.response != null) {
                this.response.handlePriorityChange(streamPriority);
            }
        }

        @Override
        void handleContinue() {
            if (this.request instanceof HttpClientRequestImpl) {
                ((HttpClientRequestImpl)this.request).handleContinue();
            }
        }

        @Override
        void handleResponse(HttpClientResponseImpl response) {
            this.response = response;
            this.request.handleResponse(response);
        }

        @Override
        void handleException(Throwable exception) {
            this.request.handleException(exception);
        }

        Handler<HttpClientRequest> pushHandler() {
            return ((HttpClientRequestImpl)this.request).pushHandler();
        }

        @Override
        public void writeHead(HttpMethod method, String uri, MultiMap headers, String authority, boolean chunked, ByteBuf content, boolean end, StreamPriority priority, Handler<AsyncResult<Void>> handler) {
            boolean e;
            DefaultHttp2Headers h = new DefaultHttp2Headers();
            h.method((CharSequence)method.name());
            if (method == HttpMethod.CONNECT) {
                if (authority == null) {
                    throw new IllegalArgumentException("Missing :authority / host header");
                }
                h.authority((CharSequence)authority);
                e = false;
            } else {
                h.path((CharSequence)uri);
                h.scheme((CharSequence)(((Http2ClientConnection)this.conn).isSsl() ? "https" : "http"));
                if (authority != null) {
                    h.authority((CharSequence)authority);
                }
                e = end;
            }
            if (headers != null && headers.size() > 0) {
                for (Map.Entry header : headers) {
                    h.add((Object)HttpUtils.toLowerCase((CharSequence)header.getKey()), header.getValue());
                }
            }
            if (((Http2ClientConnection)this.conn).client.getOptions().isTryUseCompression() && h.get((Object)HttpHeaderNames.ACCEPT_ENCODING) == null) {
                h.set((Object)HttpHeaderNames.ACCEPT_ENCODING, (Object)HttpHeaders.DEFLATE_GZIP);
            }
            this.priority(priority);
            ((Http2ClientConnection)this.conn).context.dispatch(null, arg_0 -> this.lambda$writeHead$0(content, (Http2Headers)h, e, handler, arg_0));
        }

        @Override
        public void writeBuffer(ByteBuf buf, boolean end, Handler<AsyncResult<Void>> listener) {
            ByteBuf chunk = buf == null && end ? Unpooled.EMPTY_BUFFER : buf;
            if (chunk != null) {
                this.writeData(chunk, end, listener);
            }
        }

        @Override
        public ContextInternal getContext() {
            return this.context;
        }

        @Override
        public void doSetWriteQueueMaxSize(int size) {
        }

        @Override
        public void reset(Throwable cause) {
            long code = cause instanceof StreamResetException ? ((StreamResetException)cause).getCode() : 0L;
            ((Http2ClientConnection)this.conn).context.dispatch(code, this::writeReset);
        }

        @Override
        public HttpClientConnection connection() {
            return (HttpClientConnection)((Object)this.conn);
        }

        private /* synthetic */ void lambda$writeHead$0(ByteBuf content, Http2Headers h, boolean e, Handler handler, Object v) {
            if (content != null) {
                this.writeHeaders(h, false, null);
                this.writeBuffer(content, e, handler);
            } else {
                this.writeHeaders(h, e, handler);
            }
        }
    }

    static abstract class Stream
    extends VertxHttp2Stream<Http2ClientConnection> {
        protected final HttpClientRequestBase request;
        private Promise<NetSocket> netSocketPromise;
        private HttpClientResponseImpl response;
        private Object metric;
        private Object trace;
        private boolean requestEnded;
        private boolean responseEnded;

        Stream(Http2ClientConnection conn, HttpClientRequestBase request, Promise<NetSocket> netSocketPromise, ContextInternal context) {
            super(conn, context);
            this.request = request;
            this.netSocketPromise = netSocketPromise;
        }

        void onContinue() {
            this.context.dispatch(null, v -> this.handleContinue());
        }

        void onResponse(HttpClientResponseImpl response) {
            this.context.schedule(response, this::handleResponse);
        }

        abstract void handleResponse(HttpClientResponseImpl var1);

        abstract void handleContinue();

        public Object metric() {
            return this.metric;
        }

        @Override
        void doWriteHeaders(Http2Headers headers, boolean end, Handler<AsyncResult<Void>> handler) {
            Http2Stream stream;
            int id = ((Http2ClientConnection)this.conn).handler.encoder().connection().local().lastStreamCreated();
            id = id == 0 ? 1 : (id += 2);
            try {
                stream = ((Http2ClientConnection)this.conn).handler.encoder().connection().local().createStream(id, false);
            }
            catch (Http2Exception e) {
                if (handler != null) {
                    handler.handle(this.context.failedFuture(e));
                }
                this.request.handleException(e);
                return;
            }
            if (((Http2ClientConnection)this.conn).metrics != null) {
                this.metric = ((Http2ClientConnection)this.conn).metrics.requestBegin(((Http2ClientConnection)this.conn).queueMetric, ((Http2ClientConnection)this.conn).metric(), ((Http2ClientConnection)this.conn).localAddress(), ((Http2ClientConnection)this.conn).remoteAddress(), this.request);
            }
            this.init(stream);
            super.doWriteHeaders(headers, end, handler);
            if (end) {
                this.endRequest();
            }
        }

        @Override
        void doWriteData(ByteBuf chunk, boolean end, Handler<AsyncResult<Void>> handler) {
            if (end) {
                this.endRequest();
            }
            super.doWriteData(chunk, end, handler);
        }

        private void endRequest() {
            this.requestEnded = true;
            if (((Http2ClientConnection)this.conn).metrics != null) {
                ((Http2ClientConnection)this.conn).metrics.requestEnd(this.metric);
            }
        }

        @Override
        void onEnd(MultiMap trailers) {
            ((Http2ClientConnection)this.conn).metricsEnd(this);
            this.responseEnded = true;
            super.onEnd(trailers);
        }

        @Override
        void onReset(long code) {
            if (((Http2ClientConnection)this.conn).metrics != null) {
                ((Http2ClientConnection)this.conn).metrics.requestReset(this.metric);
            }
            super.onReset(code);
        }

        @Override
        void onHeaders(Http2Headers headers, StreamPriority streamPriority) {
            if (streamPriority != null) {
                this.priority(streamPriority);
            }
            if (this.response == null) {
                String statusMessage;
                int status;
                try {
                    status = Integer.parseInt(headers.status().toString());
                    statusMessage = HttpResponseStatus.valueOf((int)status).reasonPhrase();
                }
                catch (Exception e) {
                    this.handleException(e);
                    this.writeReset(1L);
                    return;
                }
                if (status == 100) {
                    this.onContinue();
                    return;
                }
                headers.remove((Object)":status");
                HttpClientResponseImpl resp = new HttpClientResponseImpl(this.request, HttpVersion.HTTP_2, (HttpClientStream)((Object)this), status, statusMessage, new Http2HeadersAdaptor(headers));
                if (((Http2ClientConnection)this.conn).metrics != null) {
                    ((Http2ClientConnection)this.conn).metrics.responseBegin(this.metric, resp);
                }
                this.response = resp;
                this.onResponse(resp);
                Promise<NetSocket> promise = this.netSocketPromise;
                this.netSocketPromise = null;
                if (promise != null) {
                    if (this.response.statusCode() == 200) {
                        NetSocket ns = ((Http2ClientConnection)this.conn).toNetSocket(this);
                        promise.complete(ns);
                    } else {
                        promise.fail("Server responded with " + this.response.statusCode() + " code instead of 200");
                    }
                }
            }
        }

        @Override
        void onClose() {
            VertxTracer tracer;
            if (this.netSocketPromise != null) {
                this.netSocketPromise.fail(ConnectionBase.CLOSED_EXCEPTION);
            }
            if (!(((Http2ClientConnection)this.conn).metrics == null || this.requestEnded && this.responseEnded)) {
                ((Http2ClientConnection)this.conn).metrics.requestReset(this.metric);
            }
            if ((tracer = this.context.tracer()) != null) {
                VertxException err = this.responseEnded && this.requestEnded ? null : ConnectionBase.CLOSED_EXCEPTION;
                tracer.receiveResponse(this.context, this.response, this.trace, err, HttpUtils.CLIENT_RESPONSE_TAG_EXTRACTOR);
            }
            if (!this.responseEnded) {
                this.onError(ConnectionBase.CLOSED_EXCEPTION);
            }
            super.onClose();
            if (this.request instanceof HttpClientRequestImpl) {
                ((Http2ClientConnection)this.conn).recycle();
            }
        }
    }
}

