/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.impl.HttpClientConnection;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.net.impl.clientconnection.Endpoint;
import io.vertx.core.spi.metrics.HttpClientMetrics;

abstract class ClientHttpEndpointBase
extends Endpoint<HttpClientConnection> {
    private final Object metric;
    private final int port;
    private final String host;
    private final HttpClientMetrics metrics;

    ClientHttpEndpointBase(HttpClientMetrics metrics, int port, String host, Object metric, Runnable dispose) {
        super(dispose);
        this.port = port;
        this.host = host;
        this.metric = metric;
        this.metrics = metrics;
    }

    @Override
    public final void requestConnection(ContextInternal ctx, Handler<AsyncResult<HttpClientConnection>> handler) {
        if (this.metrics != null) {
            Object metric = this.metrics != null ? this.metrics.enqueueRequest(this.metric) : null;
            Handler<AsyncResult<HttpClientConnection>> next = handler;
            handler = ar -> {
                if (this.metrics != null) {
                    this.metrics.dequeueRequest(this.metric, metric);
                }
                next.handle((AsyncResult<HttpClientConnection>)ar);
            };
        }
        this.requestConnection2(ctx, handler);
    }

    protected abstract void requestConnection2(ContextInternal var1, Handler<AsyncResult<HttpClientConnection>> var2);

    @Override
    protected void dispose() {
        if (this.metrics != null) {
            this.metrics.closeEndpoint(this.host, this.port, this.metric);
        }
    }

    @Override
    public void close(HttpClientConnection connection) {
        connection.close();
    }
}

