/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.PromiseInternal;
import io.vertx.core.impl.VertxImpl;
import io.vertx.core.impl.WorkerExecutorInternal;
import io.vertx.core.impl.WorkerPool;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.core.spi.metrics.PoolMetrics;

class WorkerExecutorImpl
implements MetricsProvider,
WorkerExecutorInternal {
    private final ContextInternal ctx;
    private final VertxImpl.SharedWorkerPool pool;
    private boolean closed;

    public WorkerExecutorImpl(ContextInternal ctx, VertxImpl.SharedWorkerPool pool) {
        this.ctx = ctx;
        this.pool = pool;
    }

    @Override
    public Metrics getMetrics() {
        return this.pool.metrics();
    }

    @Override
    public boolean isMetricsEnabled() {
        PoolMetrics metrics = this.pool.metrics();
        return metrics != null;
    }

    @Override
    public Vertx vertx() {
        return this.ctx.owner();
    }

    @Override
    public WorkerPool getPool() {
        return this.pool;
    }

    @Override
    public <T> Future<@Nullable T> executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered) {
        if (this.closed) {
            throw new IllegalStateException("Worker executor closed");
        }
        ContextInternal context = this.ctx.owner().getOrCreateContext();
        ContextImpl impl = context instanceof ContextImpl.Duplicated ? ((ContextImpl.Duplicated)context).delegate : (ContextImpl)context;
        return ContextImpl.executeBlocking(context, blockingCodeHandler, this.pool, ordered ? impl.orderedTasks : null);
    }

    @Override
    public synchronized <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<T>> asyncResultHandler) {
        Future<T> fut = this.executeBlocking(blockingCodeHandler, ordered);
        if (asyncResultHandler != null) {
            fut.setHandler(asyncResultHandler);
        }
    }

    @Override
    public Future<Void> close() {
        PromiseInternal<Void> promise = this.ctx.promise();
        this.close(promise);
        return promise.future();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Promise<Void> completion) {
        WorkerExecutorImpl workerExecutorImpl = this;
        synchronized (workerExecutorImpl) {
            if (!this.closed) {
                this.closed = true;
                this.ctx.removeCloseHook(this);
                this.pool.release();
            }
        }
        completion.complete();
    }
}

