/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.netty.channel.EventLoop;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.WorkerPool;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.spi.tracing.VertxTracer;

public class EventLoopContext
extends ContextImpl {
    private static final Logger log = LoggerFactory.getLogger(EventLoopContext.class);

    EventLoopContext(VertxInternal vertx, VertxTracer<?, ?> tracer, WorkerPool internalBlockingPool, WorkerPool workerPool, Deployment deployment, ClassLoader tccl) {
        super(vertx, tracer, internalBlockingPool, workerPool, deployment, tccl);
    }

    public EventLoopContext(VertxInternal vertx, VertxTracer<?, ?> tracer, EventLoop eventLoop, WorkerPool internalBlockingPool, WorkerPool workerPool, Deployment deployment, ClassLoader tccl) {
        super(vertx, tracer, eventLoop, internalBlockingPool, workerPool, deployment, tccl);
    }

    @Override
    void executeAsync(Handler<Void> task) {
        this.nettyEventLoop().execute(() -> this.dispatch(null, task));
    }

    @Override
    public <T> void schedule(T value, Handler<T> task) {
        task.handle(value);
    }

    @Override
    <T> void execute(T value, Handler<T> task) {
        this.dispatch(value, task);
    }

    @Override
    public boolean isEventLoopContext() {
        return true;
    }

    @Override
    public ContextInternal duplicate(ContextInternal in) {
        return new Duplicated(this, in);
    }

    static class Duplicated
    extends ContextImpl.Duplicated<EventLoopContext> {
        Duplicated(EventLoopContext delegate, ContextInternal other) {
            super(delegate, other);
        }

        @Override
        void executeAsync(Handler<Void> task) {
            this.nettyEventLoop().execute(() -> this.dispatch(null, task));
        }

        @Override
        <T> void execute(T value, Handler<T> task) {
            this.dispatch(value, task);
        }

        @Override
        public boolean isEventLoopContext() {
            return true;
        }

        @Override
        public ContextInternal duplicate(ContextInternal context) {
            return new Duplicated((EventLoopContext)this.delegate, context);
        }
    }
}

