/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import java.util.function.Function;

public class CompositeFutureImpl
implements CompositeFuture {
    private static final Handler<AsyncResult<CompositeFuture>> NO_HANDLER = c -> {};
    private static final Function<CompositeFuture, Throwable> ALL = cf -> {
        int size = cf.size();
        for (int i = 0; i < size; ++i) {
            if (cf.succeeded(i)) continue;
            return cf.cause(i);
        }
        return null;
    };
    private final Future[] results;
    private int count;
    private boolean completed;
    private Throwable cause;
    private Handler<AsyncResult<CompositeFuture>> handler;

    public static CompositeFuture all(Future<?> ... results) {
        CompositeFutureImpl composite = new CompositeFutureImpl(results);
        int len = results.length;
        for (int i = 0; i < len; ++i) {
            results[i].setHandler((AsyncResult<T> ar) -> {
                Handler<AsyncResult<CompositeFuture>> handler = null;
                if (ar.succeeded()) {
                    CompositeFutureImpl compositeFutureImpl = composite;
                    synchronized (compositeFutureImpl) {
                        ++composite.count;
                        if (!composite.isComplete() && composite.count == len) {
                            handler = composite.setCompleted(null);
                        }
                    }
                }
                CompositeFutureImpl compositeFutureImpl = composite;
                synchronized (compositeFutureImpl) {
                    if (!composite.isComplete()) {
                        handler = composite.setCompleted(ar.cause());
                    }
                }
                if (handler != null) {
                    handler.handle(composite);
                }
            });
        }
        if (len == 0) {
            composite.setCompleted(null);
        }
        return composite;
    }

    public static CompositeFuture any(Future<?> ... results) {
        CompositeFutureImpl composite = new CompositeFutureImpl(results);
        int len = results.length;
        for (int i = 0; i < len; ++i) {
            results[i].setHandler((AsyncResult<T> ar) -> {
                Handler<AsyncResult<CompositeFuture>> handler = null;
                if (ar.succeeded()) {
                    CompositeFutureImpl compositeFutureImpl = composite;
                    synchronized (compositeFutureImpl) {
                        if (!composite.isComplete()) {
                            handler = composite.setCompleted(null);
                        }
                    }
                }
                CompositeFutureImpl compositeFutureImpl = composite;
                synchronized (compositeFutureImpl) {
                    ++composite.count;
                    if (!composite.isComplete() && composite.count == len) {
                        handler = composite.setCompleted(ar.cause());
                    }
                }
                if (handler != null) {
                    handler.handle(composite);
                }
            });
        }
        if (results.length == 0) {
            composite.setCompleted(null);
        }
        return composite;
    }

    public static CompositeFuture join(Future<?> ... results) {
        return CompositeFutureImpl.join(ALL, results);
    }

    private static CompositeFuture join(Function<CompositeFuture, Throwable> pred, Future<?> ... results) {
        CompositeFutureImpl composite = new CompositeFutureImpl(results);
        int len = results.length;
        for (int i = 0; i < len; ++i) {
            results[i].setHandler((AsyncResult<T> ar) -> {
                Handler<AsyncResult<CompositeFuture>> handler = null;
                CompositeFutureImpl compositeFutureImpl = composite;
                synchronized (compositeFutureImpl) {
                    ++composite.count;
                    if (!composite.isComplete() && composite.count == len) {
                        Throwable failure = (Throwable)pred.apply(composite);
                        handler = composite.setCompleted(failure);
                    }
                }
                if (handler != null) {
                    handler.handle(composite);
                }
            });
        }
        if (len == 0) {
            composite.setCompleted(null);
        }
        return composite;
    }

    private CompositeFutureImpl(Future<?> ... results) {
        this.results = results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompositeFuture setHandler(Handler<AsyncResult<CompositeFuture>> handler) {
        boolean call;
        CompositeFutureImpl compositeFutureImpl = this;
        synchronized (compositeFutureImpl) {
            this.handler = handler;
            call = this.completed;
        }
        if (call) {
            handler.handle(this);
        }
        return this;
    }

    @Override
    public synchronized Handler<AsyncResult<CompositeFuture>> getHandler() {
        return this.handler;
    }

    @Override
    public Throwable cause(int index) {
        return this.future(index).cause();
    }

    @Override
    public boolean succeeded(int index) {
        return this.future(index).succeeded();
    }

    @Override
    public boolean failed(int index) {
        return this.future(index).failed();
    }

    @Override
    public boolean isComplete(int index) {
        return this.future(index).isComplete();
    }

    @Override
    public <T> T resultAt(int index) {
        return this.future(index).result();
    }

    private <T> Future<T> future(int index) {
        if (index < 0 || index > this.results.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.results[index];
    }

    @Override
    public int size() {
        return this.results.length;
    }

    @Override
    public synchronized boolean isComplete() {
        return this.completed;
    }

    @Override
    public synchronized boolean succeeded() {
        return this.completed && this.cause == null;
    }

    @Override
    public synchronized boolean failed() {
        return this.completed && this.cause != null;
    }

    @Override
    public synchronized Throwable cause() {
        return this.completed && this.cause != null ? this.cause : null;
    }

    @Override
    public synchronized CompositeFuture result() {
        return this.completed && this.cause == null ? this : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Handler<AsyncResult<CompositeFuture>> setCompleted(Throwable cause) {
        CompositeFutureImpl compositeFutureImpl = this;
        synchronized (compositeFutureImpl) {
            if (this.completed) {
                return null;
            }
            this.completed = true;
            this.cause = cause;
            return this.handler != null ? this.handler : NO_HANDLER;
        }
    }
}

