/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.net.NetSocket;
import io.vertx.core.streams.ReadStream;
import java.util.List;

@VertxGen
public interface HttpClientResponse
extends ReadStream<Buffer> {
    public HttpClientResponse fetch(long var1);

    public HttpClientResponse resume();

    @Override
    public HttpClientResponse exceptionHandler(Handler<Throwable> var1);

    public HttpClientResponse handler(Handler<Buffer> var1);

    public HttpClientResponse pause();

    public HttpClientResponse endHandler(Handler<Void> var1);

    public HttpVersion version();

    public int statusCode();

    public String statusMessage();

    @CacheReturn
    public MultiMap headers();

    public @Nullable String getHeader(String var1);

    @GenIgnore(value={"permitted-type"})
    public String getHeader(CharSequence var1);

    public @Nullable String getTrailer(String var1);

    @CacheReturn
    public MultiMap trailers();

    @CacheReturn
    public List<String> cookies();

    @Fluent
    public HttpClientResponse bodyHandler(Handler<Buffer> var1);

    @Fluent
    default public HttpClientResponse body(Handler<AsyncResult<Buffer>> handler) {
        Future<Buffer> fut = this.body();
        fut.setHandler(handler);
        return this;
    }

    public Future<Buffer> body();

    @Fluent
    public HttpClientResponse customFrameHandler(Handler<HttpFrame> var1);

    @CacheReturn
    public NetSocket netSocket();

    @CacheReturn
    public HttpClientRequest request();

    @Fluent
    public HttpClientResponse streamPriorityHandler(Handler<StreamPriority> var1);
}

