/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.json.JsonCodec;
import java.util.ArrayList;
import java.util.Map;

public class HttpServerOptionsConverter
implements JsonCodec<HttpServerOptions, JsonObject> {
    public static final HttpServerOptionsConverter INSTANCE = new HttpServerOptionsConverter();

    @Override
    public JsonObject encode(HttpServerOptions value) {
        return value != null ? value.toJson() : null;
    }

    @Override
    public HttpServerOptions decode(JsonObject value) {
        return value != null ? new HttpServerOptions(value) : null;
    }

    @Override
    public Class<HttpServerOptions> getTargetClass() {
        return HttpServerOptions.class;
    }

    static void fromJson(Iterable<Map.Entry<String, Object>> json, HttpServerOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "acceptUnmaskedFrames": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setAcceptUnmaskedFrames((Boolean)member.getValue());
                    break;
                }
                case "alpnVersions": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<HttpVersion> list = new ArrayList<HttpVersion>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add(HttpVersion.valueOf((String)item));
                        }
                    });
                    obj.setAlpnVersions(list);
                    break;
                }
                case "compressionLevel": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setCompressionLevel(((Number)member.getValue()).intValue());
                    break;
                }
                case "compressionSupported": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setCompressionSupported((Boolean)member.getValue());
                    break;
                }
                case "decoderInitialBufferSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setDecoderInitialBufferSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "decompressionSupported": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setDecompressionSupported((Boolean)member.getValue());
                    break;
                }
                case "handle100ContinueAutomatically": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setHandle100ContinueAutomatically((Boolean)member.getValue());
                    break;
                }
                case "http2ConnectionWindowSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setHttp2ConnectionWindowSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "initialSettings": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setInitialSettings(new Http2Settings((JsonObject)member.getValue()));
                    break;
                }
                case "maxChunkSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxChunkSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxHeaderSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxHeaderSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxInitialLineLength": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxInitialLineLength(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxWebsocketFrameSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxWebsocketFrameSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxWebsocketMessageSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxWebsocketMessageSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "perFrameWebsocketCompressionSupported": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setPerFrameWebsocketCompressionSupported((Boolean)member.getValue());
                    break;
                }
                case "perMessageWebsocketCompressionSupported": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setPerMessageWebsocketCompressionSupported((Boolean)member.getValue());
                    break;
                }
                case "websocketAllowServerNoContext": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setWebsocketAllowServerNoContext((Boolean)member.getValue());
                    break;
                }
                case "websocketCompressionLevel": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setWebsocketCompressionLevel(((Number)member.getValue()).intValue());
                    break;
                }
                case "websocketPreferredClientNoContext": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setWebsocketPreferredClientNoContext((Boolean)member.getValue());
                    break;
                }
                case "websocketSubProtocols": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setWebsocketSubProtocols((String)member.getValue());
                }
            }
        }
    }

    static void toJson(HttpServerOptions obj, JsonObject json) {
        HttpServerOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(HttpServerOptions obj, Map<String, Object> json) {
        json.put("acceptUnmaskedFrames", obj.isAcceptUnmaskedFrames());
        if (obj.getAlpnVersions() != null) {
            JsonArray array = new JsonArray();
            obj.getAlpnVersions().forEach(item -> array.add(item.name()));
            json.put("alpnVersions", array);
        }
        json.put("compressionLevel", obj.getCompressionLevel());
        json.put("compressionSupported", obj.isCompressionSupported());
        json.put("decoderInitialBufferSize", obj.getDecoderInitialBufferSize());
        json.put("decompressionSupported", obj.isDecompressionSupported());
        json.put("handle100ContinueAutomatically", obj.isHandle100ContinueAutomatically());
        json.put("http2ConnectionWindowSize", obj.getHttp2ConnectionWindowSize());
        if (obj.getInitialSettings() != null) {
            json.put("initialSettings", obj.getInitialSettings().toJson());
        }
        json.put("maxChunkSize", obj.getMaxChunkSize());
        json.put("maxHeaderSize", obj.getMaxHeaderSize());
        json.put("maxInitialLineLength", obj.getMaxInitialLineLength());
        json.put("maxWebsocketFrameSize", obj.getMaxWebsocketFrameSize());
        json.put("maxWebsocketMessageSize", obj.getMaxWebsocketMessageSize());
        json.put("perFrameWebsocketCompressionSupported", obj.getPerFrameWebsocketCompressionSupported());
        json.put("perMessageWebsocketCompressionSupported", obj.getPerMessageWebsocketCompressionSupported());
        json.put("websocketAllowServerNoContext", obj.getWebsocketAllowServerNoContext());
        json.put("websocketCompressionLevel", obj.getWebsocketCompressionLevel());
        json.put("websocketPreferredClientNoContext", obj.getWebsocketPreferredClientNoContext());
        if (obj.getWebsocketSubProtocols() != null) {
            json.put("websocketSubProtocols", obj.getWebsocketSubProtocols());
        }
    }
}

