/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.shareddata;

import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import java.util.List;
import java.util.Map;
import java.util.Set;

@VertxGen
public interface AsyncMap<K, V> {
    public void get(K var1, Handler<AsyncResult<@Nullable V>> var2);

    default public Future<@Nullable V> get(K k) {
        Promise promise = Promise.promise();
        this.get(k, promise);
        return promise.future();
    }

    public void put(K var1, V var2, Handler<AsyncResult<Void>> var3);

    default public Future<Void> put(K k, V v) {
        Promise<Void> promise = Promise.promise();
        this.put(k, v, promise);
        return promise.future();
    }

    public void put(K var1, V var2, long var3, Handler<AsyncResult<Void>> var5);

    default public Future<Void> put(K k, V v, long ttl) {
        Promise promise = Promise.promise();
        this.put(k, v, ttl);
        return promise.future();
    }

    public void putIfAbsent(K var1, V var2, Handler<AsyncResult<@Nullable V>> var3);

    default public Future<@Nullable V> putIfAbsent(K k, V v) {
        Promise promise = Promise.promise();
        this.putIfAbsent(k, v, promise);
        return promise.future();
    }

    public void putIfAbsent(K var1, V var2, long var3, Handler<AsyncResult<@Nullable V>> var5);

    default public Future<@Nullable V> putIfAbsent(K k, V v, long ttl) {
        Promise promise = Promise.promise();
        this.putIfAbsent(k, v, ttl, promise);
        return promise.future();
    }

    public void remove(K var1, Handler<AsyncResult<@Nullable V>> var2);

    default public Future<@Nullable V> remove(K k) {
        Promise promise = Promise.promise();
        this.remove(k, promise);
        return promise.future();
    }

    public void removeIfPresent(K var1, V var2, Handler<AsyncResult<Boolean>> var3);

    default public Future<Boolean> removeIfPresent(K k, V v) {
        Promise<Boolean> promise = Promise.promise();
        this.removeIfPresent(k, v, promise);
        return promise.future();
    }

    public void replace(K var1, V var2, Handler<AsyncResult<@Nullable V>> var3);

    default public Future<@Nullable V> replace(K k, V v) {
        Promise promise = Promise.promise();
        this.replace(k, v, promise);
        return promise.future();
    }

    public void replaceIfPresent(K var1, V var2, V var3, Handler<AsyncResult<Boolean>> var4);

    default public Future<Boolean> replaceIfPresent(K k, V oldValue, V newValue) {
        Promise<Boolean> promise = Promise.promise();
        this.replaceIfPresent(k, oldValue, newValue, promise);
        return promise.future();
    }

    public void clear(Handler<AsyncResult<Void>> var1);

    default public Future<Void> clear() {
        Promise<Void> promise = Promise.promise();
        this.clear(promise);
        return promise.future();
    }

    public void size(Handler<AsyncResult<Integer>> var1);

    default public Future<Integer> size() {
        Promise<Integer> promise = Promise.promise();
        this.size(promise);
        return promise.future();
    }

    @GenIgnore
    public void keys(Handler<AsyncResult<Set<K>>> var1);

    @GenIgnore
    default public Future<Set<K>> keys() {
        Promise<Set<K>> promise = Promise.promise();
        this.keys(promise);
        return promise.future();
    }

    @GenIgnore
    public void values(Handler<AsyncResult<List<V>>> var1);

    @GenIgnore
    default public Future<List<V>> values() {
        Promise<List<V>> promise = Promise.promise();
        this.values(promise);
        return promise.future();
    }

    @GenIgnore
    public void entries(Handler<AsyncResult<Map<K, V>>> var1);

    @GenIgnore
    default public Future<Map<K, V>> entries() {
        Promise<Map<K, V>> promise = Promise.promise();
        this.entries(promise);
        return promise.future();
    }
}

