/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.net.impl.ConnectionBase;
import java.util.function.Function;

public final class VertxHandler<C extends ConnectionBase>
extends ChannelDuplexHandler {
    private static final Handler<Object> NULL_HANDLER = m -> {};
    private final Function<ChannelHandlerContext, C> connectionFactory;
    private final ContextInternal context;
    private C conn;
    private Handler<C> addHandler;
    private Handler<C> removeHandler;
    private Handler<Object> messageHandler;

    public static ByteBuf safeBuffer(ByteBufHolder holder, ByteBufAllocator allocator) {
        return VertxHandler.safeBuffer(holder.content(), allocator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuf safeBuffer(ByteBuf buf, ByteBufAllocator allocator) {
        if (buf == Unpooled.EMPTY_BUFFER) {
            return buf;
        }
        if (buf.isDirect() || buf instanceof CompositeByteBuf) {
            try {
                if (buf.isReadable()) {
                    ByteBuf buffer = allocator.heapBuffer(buf.readableBytes());
                    buffer.writeBytes(buf);
                    ByteBuf byteBuf = buffer;
                    return byteBuf;
                }
                ByteBuf byteBuf = Unpooled.EMPTY_BUFFER;
                return byteBuf;
            }
            finally {
                buf.release();
            }
        }
        return buf;
    }

    public static <C extends ConnectionBase> VertxHandler<C> create(C connection) {
        return VertxHandler.create(connection.context, ctx -> connection);
    }

    public static <C extends ConnectionBase> VertxHandler<C> create(ContextInternal context, Function<ChannelHandlerContext, C> connectionFactory) {
        return new VertxHandler<C>(context, connectionFactory);
    }

    private VertxHandler(ContextInternal context, Function<ChannelHandlerContext, C> connectionFactory) {
        this.context = context;
        this.connectionFactory = connectionFactory;
    }

    private void setConnection(C connection) {
        this.conn = connection;
        this.messageHandler = arg_0 -> this.conn.handleMessage(arg_0);
        if (this.addHandler != null) {
            this.addHandler.handle(connection);
        }
    }

    void fail(Throwable error) {
        this.messageHandler = NULL_HANDLER;
        ((ConnectionBase)this.conn).chctx.pipeline().fireExceptionCaught(error);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.setConnection((ConnectionBase)this.connectionFactory.apply(ctx));
    }

    public VertxHandler<C> addHandler(Handler<C> handler) {
        this.addHandler = handler;
        return this;
    }

    public VertxHandler<C> removeHandler(Handler<C> handler) {
        this.removeHandler = handler;
        return this;
    }

    public C getConnection() {
        return this.conn;
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        Object conn = this.getConnection();
        this.context.schedule(v -> conn.handleInterestedOpsChanged());
    }

    public void exceptionCaught(ChannelHandlerContext chctx, Throwable t) throws Exception {
        Channel ch = chctx.channel();
        Object connection = this.getConnection();
        if (connection != null) {
            this.context.executeFromIO(v -> {
                try {
                    if (ch.isOpen()) {
                        ch.close();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                connection.handleException(t);
            });
        } else {
            ch.close();
        }
    }

    public void channelInactive(ChannelHandlerContext chctx) throws Exception {
        if (this.removeHandler != null) {
            this.removeHandler.handle(this.conn);
        }
        this.context.schedule(v -> ((ConnectionBase)this.conn).handleClosed());
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ((ConnectionBase)this.conn).endReadAndFlush();
    }

    public void channelRead(ChannelHandlerContext chctx, Object msg) throws Exception {
        ((ConnectionBase)this.conn).setRead();
        this.context.schedule(msg, this.messageHandler);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent && ((IdleStateEvent)evt).state() == IdleState.ALL_IDLE) {
            this.context.schedule(v -> ((ConnectionBase)this.conn).handleIdle());
        } else {
            ctx.fireUserEventTriggered(evt);
        }
    }
}

