/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JksOptions;
import io.vertx.core.spi.json.JsonCodec;
import java.util.Base64;
import java.util.Map;

public class JksOptionsConverter
implements JsonCodec<JksOptions, JsonObject> {
    public static final JksOptionsConverter INSTANCE = new JksOptionsConverter();

    @Override
    public JsonObject encode(JksOptions value) {
        return value != null ? value.toJson() : null;
    }

    @Override
    public JksOptions decode(JsonObject value) {
        return value != null ? new JksOptions(value) : null;
    }

    @Override
    public Class<JksOptions> getTargetClass() {
        return JksOptions.class;
    }

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, JksOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "password": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPassword((String)member.getValue());
                    break;
                }
                case "path": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPath((String)member.getValue());
                    break;
                }
                case "value": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setValue(Buffer.buffer(Base64.getDecoder().decode((String)member.getValue())));
                }
            }
        }
    }

    public static void toJson(JksOptions obj, JsonObject json) {
        JksOptionsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(JksOptions obj, Map<String, Object> json) {
        if (obj.getPassword() != null) {
            json.put("password", obj.getPassword());
        }
        if (obj.getPath() != null) {
            json.put("path", obj.getPath());
        }
        if (obj.getValue() != null) {
            json.put("value", Base64.getEncoder().encodeToString(obj.getValue().getBytes()));
        }
    }
}

