/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.impl.BlockedThreadChecker;
import io.vertx.core.impl.VertxThread;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class VertxThreadFactory
implements ThreadFactory {
    private final String prefix;
    private final AtomicInteger threadCount = new AtomicInteger(0);
    private final BlockedThreadChecker checker;
    private final boolean worker;
    private final long maxExecTime;
    private final TimeUnit maxExecTimeUnit;

    VertxThreadFactory(String prefix, BlockedThreadChecker checker, boolean worker, long maxExecTime, TimeUnit maxExecTimeUnit) {
        this.prefix = prefix;
        this.checker = checker;
        this.worker = worker;
        this.maxExecTime = maxExecTime;
        this.maxExecTimeUnit = maxExecTimeUnit;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        VertxThread t = new VertxThread(runnable, this.prefix + this.threadCount.getAndIncrement(), this.worker, this.maxExecTime, this.maxExecTimeUnit);
        if (this.checker != null) {
            this.checker.registerThread((Thread)((Object)t), t);
        }
        t.setDaemon(false);
        return t;
    }
}

