/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.impl.Http2ServerConnection;
import io.vertx.core.http.impl.Http2ServerResponseImpl;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.VertxHttp2Stream;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.metrics.Metrics;

abstract class Http2ServerStream
extends VertxHttp2Stream<Http2ServerConnection> {
    protected final String rawMethod;
    protected final HttpMethod method;
    protected final String uri;
    protected final String contentEncoding;
    protected final String host;
    protected final Http2ServerResponseImpl response;
    private Object metric;

    Http2ServerStream(Http2ServerConnection conn, Http2Stream stream, String contentEncoding, HttpMethod method, String uri, boolean writable) {
        super(conn, stream, writable);
        this.method = method;
        this.rawMethod = method.name();
        this.contentEncoding = contentEncoding;
        this.uri = uri;
        this.host = null;
        this.response = new Http2ServerResponseImpl(conn, this, method, true, contentEncoding, null);
    }

    Http2ServerStream(Http2ServerConnection conn, Http2Stream stream, Http2Headers headers, String contentEncoding, String serverOrigin, boolean writable) {
        super(conn, stream, writable);
        String host;
        String string = host = headers.get((Object)":authority") != null ? ((CharSequence)headers.get((Object)":authority")).toString() : null;
        if (host == null) {
            int idx = serverOrigin.indexOf("://");
            host = serverOrigin.substring(idx + 3);
        }
        this.host = host;
        this.contentEncoding = contentEncoding;
        this.uri = headers.get((Object)":path") != null ? ((CharSequence)headers.get((Object)":path")).toString() : null;
        this.rawMethod = headers.get((Object)":method") != null ? ((CharSequence)headers.get((Object)":method")).toString() : null;
        this.method = HttpUtils.toVertxMethod(this.rawMethod);
        this.response = new Http2ServerResponseImpl(conn, this, this.method, false, contentEncoding, host);
    }

    void registerMetrics() {
        HttpServerMetrics metrics;
        if (Metrics.METRICS_ENABLED && (metrics = ((Http2ServerConnection)this.conn).metrics()) != null) {
            this.metric = this.response.isPush() ? metrics.responsePushed(((Http2ServerConnection)this.conn).metric(), this.method(), this.uri, this.response) : metrics.requestBegin(((Http2ServerConnection)this.conn).metric(), (HttpServerRequest)((Object)this));
        }
    }

    void writeHead(Http2Headers headers, boolean end, Handler<AsyncResult<Void>> handler) {
        if (Metrics.METRICS_ENABLED && this.metric != null) {
            ((Http2ServerConnection)this.conn).metrics().responseBegin(this.metric, this.response);
        }
        this.writeHeaders(headers, end, handler);
    }

    @Override
    void handleInterestedOpsChanged() {
        if (this.response != null) {
            this.response.writabilityChanged();
        }
    }

    public HttpMethod method() {
        return this.method;
    }

    public String rawMethod() {
        return this.rawMethod;
    }

    @Override
    void handleClose() {
        HttpServerMetrics metrics;
        super.handleClose();
        if (Metrics.METRICS_ENABLED && (metrics = ((Http2ServerConnection)this.conn).metrics()) != null) {
            boolean failed;
            boolean bl = failed = !this.response.ended();
            if (failed) {
                metrics.requestReset(this.metric);
            } else {
                metrics.responseEnd(this.metric, this.response);
            }
        }
    }
}

