/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.netty.channel.EventLoopGroup;
import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.ServiceHelper;
import io.vertx.core.TimeoutStream;
import io.vertx.core.Verticle;
import io.vertx.core.VertxOptions;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.datagram.DatagramSocket;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.dns.DnsClient;
import io.vertx.core.dns.DnsClientOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.file.FileSystem;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.metrics.Measured;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.shareddata.SharedData;
import io.vertx.core.spi.VerticleFactory;
import io.vertx.core.spi.VertxFactory;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

@VertxGen
public interface Vertx
extends Measured {
    @GenIgnore
    public static final VertxFactory factory = ServiceHelper.loadFactory(VertxFactory.class);

    public static Vertx vertx() {
        return factory.vertx();
    }

    public static Vertx vertx(VertxOptions options) {
        return factory.vertx(options);
    }

    public static void clusteredVertx(VertxOptions options, Handler<AsyncResult<Vertx>> resultHandler) {
        factory.clusteredVertx(options, resultHandler);
    }

    public static @Nullable Context currentContext() {
        return factory.context();
    }

    public Context getOrCreateContext();

    public NetServer createNetServer(NetServerOptions var1);

    public NetServer createNetServer();

    public NetClient createNetClient(NetClientOptions var1);

    public NetClient createNetClient();

    public HttpServer createHttpServer(HttpServerOptions var1);

    public HttpServer createHttpServer();

    public HttpClient createHttpClient(HttpClientOptions var1);

    public HttpClient createHttpClient();

    public DatagramSocket createDatagramSocket(DatagramSocketOptions var1);

    public DatagramSocket createDatagramSocket();

    @CacheReturn
    public FileSystem fileSystem();

    @CacheReturn
    public EventBus eventBus();

    public DnsClient createDnsClient(int var1, String var2);

    public DnsClient createDnsClient();

    public DnsClient createDnsClient(DnsClientOptions var1);

    @CacheReturn
    public SharedData sharedData();

    public long setTimer(long var1, Handler<Long> var3);

    public TimeoutStream timerStream(long var1);

    public long setPeriodic(long var1, Handler<Long> var3);

    public TimeoutStream periodicStream(long var1);

    public boolean cancelTimer(long var1);

    public void runOnContext(Handler<Void> var1);

    public void close();

    public void close(Handler<AsyncResult<Void>> var1);

    @GenIgnore(value={"permitted-type"})
    public void deployVerticle(Verticle var1);

    @GenIgnore(value={"permitted-type"})
    public void deployVerticle(Verticle var1, Handler<AsyncResult<String>> var2);

    @GenIgnore(value={"permitted-type"})
    public void deployVerticle(Verticle var1, DeploymentOptions var2);

    @GenIgnore
    public void deployVerticle(Class<? extends Verticle> var1, DeploymentOptions var2);

    @GenIgnore(value={"permitted-type"})
    public void deployVerticle(Supplier<Verticle> var1, DeploymentOptions var2);

    @GenIgnore(value={"permitted-type"})
    public void deployVerticle(Verticle var1, DeploymentOptions var2, Handler<AsyncResult<String>> var3);

    @GenIgnore
    public void deployVerticle(Class<? extends Verticle> var1, DeploymentOptions var2, Handler<AsyncResult<String>> var3);

    @GenIgnore(value={"permitted-type"})
    public void deployVerticle(Supplier<Verticle> var1, DeploymentOptions var2, Handler<AsyncResult<String>> var3);

    public void deployVerticle(String var1);

    public void deployVerticle(String var1, Handler<AsyncResult<String>> var2);

    public void deployVerticle(String var1, DeploymentOptions var2);

    public void deployVerticle(String var1, DeploymentOptions var2, Handler<AsyncResult<String>> var3);

    public void undeploy(String var1);

    public void undeploy(String var1, Handler<AsyncResult<Void>> var2);

    public Set<String> deploymentIDs();

    @GenIgnore(value={"permitted-type"})
    public void registerVerticleFactory(VerticleFactory var1);

    @GenIgnore(value={"permitted-type"})
    public void unregisterVerticleFactory(VerticleFactory var1);

    @GenIgnore(value={"permitted-type"})
    public Set<VerticleFactory> verticleFactories();

    public boolean isClustered();

    public <T> void executeBlocking(Handler<Future<T>> var1, boolean var2, Handler<AsyncResult<@Nullable T>> var3);

    public <T> void executeBlocking(Handler<Future<T>> var1, Handler<AsyncResult<@Nullable T>> var2);

    @GenIgnore(value={"permitted-type"})
    public EventLoopGroup nettyEventLoopGroup();

    public WorkerExecutor createSharedWorkerExecutor(String var1);

    public WorkerExecutor createSharedWorkerExecutor(String var1, int var2);

    public WorkerExecutor createSharedWorkerExecutor(String var1, int var2, long var3);

    public WorkerExecutor createSharedWorkerExecutor(String var1, int var2, long var3, TimeUnit var5);

    @CacheReturn
    public boolean isNativeTransportEnabled();

    @Fluent
    public Vertx exceptionHandler(@Nullable Handler<Throwable> var1);

    @GenIgnore
    public @Nullable Handler<Throwable> exceptionHandler();
}

