/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.impl.ConnectionManager;
import io.vertx.core.http.impl.HttpClientConnection;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.HttpClientRequestBase;
import io.vertx.core.http.impl.HttpClientResponseImpl;
import io.vertx.core.http.impl.HttpClientStream;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetSocket;
import java.util.List;
import java.util.Objects;

public class HttpClientRequestImpl
extends HttpClientRequestBase
implements HttpClientRequest {
    static final Logger log = LoggerFactory.getLogger(ConnectionManager.class);
    private final VertxInternal vertx;
    private Handler<HttpClientResponse> respHandler;
    private Handler<Void> endHandler;
    private boolean chunked = false;
    private String hostHeader;
    private String rawMethod;
    private Handler<Void> continueHandler;
    private Handler<Void> drainHandler;
    private Handler<HttpClientRequest> pushHandler;
    private Handler<HttpConnection> connectionHandler;
    private boolean completed;
    private Handler<Void> completionHandler;
    private Long reset;
    private ByteBuf pendingChunks;
    private int pendingMaxSize = -1;
    private int followRedirects;
    private long written;
    private CaseInsensitiveHeaders headers;
    private HttpClientStream stream;
    private boolean connecting;

    HttpClientRequestImpl(HttpClientImpl client, boolean ssl, HttpMethod method, String host, int port, String relativeURI, VertxInternal vertx) {
        super(client, ssl, method, host, port, relativeURI);
        this.vertx = vertx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int streamId() {
        HttpClientStream s;
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            s = this.stream;
            if (s == null) {
                return -1;
            }
        }
        return s.id();
    }

    @Override
    public synchronized HttpClientRequest handler(Handler<HttpClientResponse> handler) {
        if (handler != null) {
            this.checkComplete();
            this.respHandler = this.checkConnect(this.method, handler);
        } else {
            this.respHandler = null;
        }
        return this;
    }

    @Override
    public HttpClientRequest pause() {
        return this;
    }

    @Override
    public HttpClientRequest resume() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest setFollowRedirects(boolean followRedirects) {
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            this.checkComplete();
            this.followRedirects = followRedirects ? this.client.getOptions().getMaxRedirects() - 1 : 0;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest endHandler(Handler<Void> handler) {
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            if (handler != null) {
                this.checkComplete();
            }
            this.endHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequestImpl setChunked(boolean chunked) {
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            this.checkComplete();
            if (this.written > 0L) {
                throw new IllegalStateException("Cannot set chunked after data has been written on request");
            }
            if (this.client.getOptions().getProtocolVersion() != HttpVersion.HTTP_1_0) {
                this.chunked = chunked;
            }
            return this;
        }
    }

    @Override
    public synchronized boolean isChunked() {
        return this.chunked;
    }

    @Override
    public synchronized String getRawMethod() {
        return this.rawMethod;
    }

    @Override
    public synchronized HttpClientRequest setRawMethod(String method) {
        this.rawMethod = method;
        return this;
    }

    @Override
    public synchronized HttpClientRequest setHost(String host) {
        this.hostHeader = host;
        return this;
    }

    @Override
    public synchronized String getHost() {
        return this.hostHeader;
    }

    @Override
    public synchronized MultiMap headers() {
        if (this.headers == null) {
            this.headers = new CaseInsensitiveHeaders();
        }
        return this.headers;
    }

    @Override
    public synchronized HttpClientRequest putHeader(String name, String value) {
        this.checkComplete();
        this.headers().set(name, value);
        return this;
    }

    @Override
    public synchronized HttpClientRequest putHeader(String name, Iterable<String> values) {
        this.checkComplete();
        this.headers().set(name, values);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest setWriteQueueMaxSize(int maxSize) {
        HttpClientStream s;
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            this.checkComplete();
            s = this.stream;
            if (s == null) {
                this.pendingMaxSize = maxSize;
                return this;
            }
        }
        s.doSetWriteQueueMaxSize(maxSize);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeQueueFull() {
        HttpClientStream s;
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            this.checkComplete();
            s = this.stream;
            if (s == null) {
                return false;
            }
        }
        return s.isNotWritable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest drainHandler(Handler<Void> handler) {
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            if (handler != null) {
                this.checkComplete();
                this.drainHandler = handler;
                HttpClientStream s = this.stream;
                if (s == null) {
                    return this;
                }
                s.getContext().runOnContext(v -> {
                    HttpClientRequestImpl httpClientRequestImpl = this;
                    synchronized (httpClientRequestImpl) {
                        if (!this.stream.isNotWritable()) {
                            this.handleDrained();
                        }
                    }
                });
            } else {
                this.drainHandler = null;
            }
            return this;
        }
    }

    @Override
    public synchronized HttpClientRequest continueHandler(Handler<Void> handler) {
        if (handler != null) {
            this.checkComplete();
        }
        this.continueHandler = handler;
        return this;
    }

    @Override
    public HttpClientRequest sendHead() {
        return this.sendHead(null);
    }

    @Override
    public synchronized HttpClientRequest sendHead(Handler<HttpVersion> headersHandler) {
        this.checkComplete();
        this.checkResponseHandler();
        if (this.stream != null) {
            throw new IllegalStateException("Head already written");
        }
        this.connect(headersHandler);
        return this;
    }

    @Override
    public synchronized HttpClientRequest putHeader(CharSequence name, CharSequence value) {
        this.checkComplete();
        this.headers().set(name, value);
        return this;
    }

    @Override
    public synchronized HttpClientRequest putHeader(CharSequence name, Iterable<CharSequence> values) {
        this.checkComplete();
        this.headers().set(name, values);
        return this;
    }

    @Override
    public synchronized HttpClientRequest pushHandler(Handler<HttpClientRequest> handler) {
        this.pushHandler = handler;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reset(long code) {
        HttpClientStream s;
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            if (this.reset != null) {
                return false;
            }
            this.reset = code;
            if (this.tryComplete() && this.completionHandler != null) {
                this.completionHandler.handle(null);
            }
            s = this.stream;
        }
        if (s != null) {
            s.reset(code);
        }
        return true;
    }

    private boolean tryComplete() {
        if (!this.completed) {
            this.completed = true;
            this.drainHandler = null;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpConnection connection() {
        HttpClientStream s;
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            s = this.stream;
            if (s == null) {
                return null;
            }
        }
        return s.connection();
    }

    @Override
    public synchronized HttpClientRequest connectionHandler(@Nullable Handler<HttpConnection> handler) {
        this.connectionHandler = handler;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized HttpClientRequest writeCustomFrame(int type, int flags, Buffer payload) {
        HttpClientStream s;
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            this.checkComplete();
            s = this.stream;
            if (s == null) {
                throw new IllegalStateException("Not yet connected");
            }
        }
        s.writeFrame(type, flags, payload.getByteBuf());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDrained() {
        Handler<Void> handler;
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            handler = this.drainHandler;
            if (handler == null) {
                return;
            }
        }
        try {
            handler.handle(null);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    private void handleNextRequest(HttpClientRequestImpl next, long timeoutMs) {
        next.handler((Handler)this.respHandler);
        next.exceptionHandler((Handler)this.exceptionHandler());
        this.exceptionHandler((Handler)null);
        next.endHandler((Handler)this.endHandler);
        next.pushHandler = this.pushHandler;
        next.followRedirects = this.followRedirects - 1;
        next.written = this.written;
        if (next.hostHeader == null) {
            next.hostHeader = this.hostHeader;
        }
        if (this.headers != null && next.headers == null) {
            next.headers().addAll(this.headers);
        }
        Future fut = Future.future();
        fut.setHandler(ar -> {
            if (ar.succeeded()) {
                if (timeoutMs > 0L) {
                    next.setTimeout(timeoutMs);
                }
                next.end();
            } else {
                next.handleException(ar.cause());
            }
        });
        if (this.exceptionOccurred != null) {
            fut.fail(this.exceptionOccurred);
        } else if (this.completed) {
            fut.complete();
        } else {
            this.exceptionHandler(err -> {
                if (!fut.isComplete()) {
                    fut.fail((Throwable)err);
                }
            });
            this.completionHandler = v -> {
                if (!fut.isComplete()) {
                    fut.complete();
                }
            };
        }
    }

    @Override
    protected void doHandleResponse(HttpClientResponseImpl resp, long timeoutMs) {
        if (this.reset == null) {
            Future<HttpClientRequest> next;
            int statusCode = resp.statusCode();
            if (this.followRedirects > 0 && statusCode >= 300 && statusCode < 400 && (next = this.client.redirectHandler().apply(resp)) != null) {
                next.setHandler(ar -> {
                    if (ar.succeeded()) {
                        this.handleNextRequest((HttpClientRequestImpl)ar.result(), timeoutMs);
                    } else {
                        this.handleException(ar.cause());
                    }
                });
                return;
            }
            if (statusCode == 100) {
                if (this.continueHandler != null) {
                    this.continueHandler.handle(null);
                }
            } else {
                if (this.respHandler != null) {
                    this.respHandler.handle(resp);
                }
                if (this.endHandler != null) {
                    this.endHandler.handle(null);
                }
            }
        }
    }

    @Override
    protected String hostHeader() {
        return this.hostHeader != null ? this.hostHeader : super.hostHeader();
    }

    private Handler<HttpClientResponse> checkConnect(HttpMethod method, Handler<HttpClientResponse> handler) {
        if (method == HttpMethod.CONNECT) {
            handler = this.connectHandler(handler);
        }
        return handler;
    }

    private Handler<HttpClientResponse> connectHandler(Handler<HttpClientResponse> responseHandler) {
        Objects.requireNonNull(responseHandler, "no null responseHandler accepted");
        return resp -> {
            HttpClientResponse response;
            if (resp.statusCode() == 200) {
                NetSocket socket = resp.netSocket();
                socket.pause();
                response = new HttpClientResponse((HttpClientResponse)resp, socket){
                    private boolean resumed;
                    final /* synthetic */ HttpClientResponse val$resp;
                    final /* synthetic */ NetSocket val$socket;
                    {
                        this.val$resp = httpClientResponse;
                        this.val$socket = netSocket;
                    }

                    @Override
                    public HttpClientRequest request() {
                        return this.val$resp.request();
                    }

                    @Override
                    public int statusCode() {
                        return this.val$resp.statusCode();
                    }

                    @Override
                    public String statusMessage() {
                        return this.val$resp.statusMessage();
                    }

                    @Override
                    public MultiMap headers() {
                        return this.val$resp.headers();
                    }

                    @Override
                    public String getHeader(String headerName) {
                        return this.val$resp.getHeader(headerName);
                    }

                    @Override
                    public String getHeader(CharSequence headerName) {
                        return this.val$resp.getHeader(headerName);
                    }

                    @Override
                    public String getTrailer(String trailerName) {
                        return this.val$resp.getTrailer(trailerName);
                    }

                    @Override
                    public MultiMap trailers() {
                        return this.val$resp.trailers();
                    }

                    @Override
                    public List<String> cookies() {
                        return this.val$resp.cookies();
                    }

                    @Override
                    public HttpVersion version() {
                        return this.val$resp.version();
                    }

                    @Override
                    public HttpClientResponse bodyHandler(Handler<Buffer> bodyHandler) {
                        this.val$resp.bodyHandler(bodyHandler);
                        return this;
                    }

                    @Override
                    public HttpClientResponse customFrameHandler(Handler<HttpFrame> handler) {
                        this.val$resp.customFrameHandler(handler);
                        return this;
                    }

                    @Override
                    public synchronized NetSocket netSocket() {
                        if (!this.resumed) {
                            this.resumed = true;
                            HttpClientRequestImpl.this.vertx.getContext().runOnContext(v -> this.val$socket.resume());
                        }
                        return this.val$socket;
                    }

                    @Override
                    public HttpClientResponse endHandler(Handler<Void> endHandler) {
                        this.val$resp.endHandler((Handler)endHandler);
                        return this;
                    }

                    @Override
                    public HttpClientResponse handler(Handler<Buffer> handler) {
                        this.val$resp.handler((Handler)handler);
                        return this;
                    }

                    @Override
                    public HttpClientResponse pause() {
                        this.val$resp.pause();
                        return this;
                    }

                    @Override
                    public HttpClientResponse resume() {
                        this.val$resp.resume();
                        return this;
                    }

                    @Override
                    public HttpClientResponse exceptionHandler(Handler<Throwable> handler) {
                        this.val$resp.exceptionHandler((Handler)handler);
                        return this;
                    }
                };
            } else {
                response = resp;
            }
            responseHandler.handle(response);
        };
    }

    private synchronized void connect(Handler<HttpVersion> headersHandler) {
        if (!this.connecting) {
            int idx;
            if (this.method == HttpMethod.OTHER && this.rawMethod == null) {
                throw new IllegalStateException("You must provide a rawMethod when using an HttpMethod.OTHER method");
            }
            String peerHost = this.hostHeader != null ? ((idx = this.hostHeader.lastIndexOf(58)) != -1 ? this.hostHeader.substring(0, idx) : this.hostHeader) : this.host;
            Handler<HttpConnection> initializer = this.connectionHandler;
            ContextImpl connectCtx = this.vertx.getOrCreateContext();
            this.connecting = true;
            this.client.getConnectionForRequest(peerHost, this.ssl, this.port, this.host, ar1 -> {
                if (ar1.succeeded()) {
                    HttpClientConnection conn = (HttpClientConnection)ar1.result();
                    if (this.exceptionOccurred != null || this.reset != null) {
                        conn.recycle();
                        return;
                    }
                    ContextImpl ctx = conn.getContext();
                    if (!conn.checkInitialized() && initializer != null) {
                        ctx.executeFromIO(() -> initializer.handle(conn));
                    }
                    conn.createStream(ar2 -> ctx.executeFromIO(() -> {
                        if (ar2.succeeded()) {
                            this.connected(headersHandler, (HttpClientStream)ar2.result());
                        } else {
                            this.handleException(ar2.cause());
                        }
                    }));
                } else {
                    connectCtx.executeFromIO(() -> this.handleException(ar1.cause()));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connected(Handler<HttpVersion> headersHandler, HttpClientStream stream) {
        HttpConnection conn = stream.connection();
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            this.stream = stream;
            stream.beginRequest(this);
            if (this.pendingMaxSize != -1) {
                stream.doSetWriteQueueMaxSize(this.pendingMaxSize);
            }
            if (this.pendingChunks != null) {
                ByteBuf pending = this.pendingChunks;
                this.pendingChunks = null;
                if (this.completed) {
                    stream.writeHead(this.method, this.rawMethod, this.uri, this.headers, this.hostHeader(), this.chunked, pending, true);
                    stream.reportBytesWritten(this.written);
                    stream.endRequest();
                } else {
                    stream.writeHead(this.method, this.rawMethod, this.uri, this.headers, this.hostHeader(), this.chunked, pending, false);
                }
            } else if (this.completed) {
                stream.writeHead(this.method, this.rawMethod, this.uri, this.headers, this.hostHeader(), this.chunked, null, true);
                stream.reportBytesWritten(this.written);
                stream.endRequest();
            } else {
                stream.writeHead(this.method, this.rawMethod, this.uri, this.headers, this.hostHeader(), this.chunked, null, false);
            }
            this.connecting = false;
            this.stream = stream;
        }
        if (headersHandler != null) {
            headersHandler.handle(stream.version());
        }
    }

    private boolean contentLengthSet() {
        return this.headers != null && this.headers().contains(HttpHeaders.CONTENT_LENGTH);
    }

    @Override
    public void end(String chunk) {
        this.end(Buffer.buffer(chunk));
    }

    @Override
    public void end(String chunk, String enc) {
        Objects.requireNonNull(enc, "no null encoding accepted");
        this.end(Buffer.buffer(chunk, enc));
    }

    @Override
    public void end(Buffer chunk) {
        this.write(chunk.getByteBuf(), true);
    }

    @Override
    public void end() {
        this.write(null, true);
    }

    @Override
    public HttpClientRequestImpl write(Buffer chunk) {
        ByteBuf buf = chunk.getByteBuf();
        this.write(buf, false);
        return this;
    }

    @Override
    public HttpClientRequestImpl write(String chunk) {
        return this.write(Buffer.buffer(chunk));
    }

    @Override
    public HttpClientRequestImpl write(String chunk, String enc) {
        Objects.requireNonNull(enc, "no null encoding accepted");
        return this.write(Buffer.buffer(chunk, enc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(ByteBuf buff, boolean end) {
        HttpClientStream s;
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            this.checkComplete();
            this.checkResponseHandler();
            if (end) {
                if (buff != null && !this.chunked && !this.contentLengthSet()) {
                    this.headers().set(HttpHeaders.CONTENT_LENGTH, (CharSequence)String.valueOf(buff.readableBytes()));
                }
            } else if (!this.chunked && !this.contentLengthSet()) {
                throw new IllegalStateException("You must set the Content-Length header to be the total size of the message body BEFORE sending any data if you are not using HTTP chunked encoding.");
            }
            if (buff == null && !end) {
                return;
            }
            if (buff != null) {
                this.written += (long)buff.readableBytes();
            }
            if ((s = this.stream) == null) {
                if (buff != null) {
                    if (this.pendingChunks == null) {
                        this.pendingChunks = buff;
                    } else {
                        CompositeByteBuf pending;
                        if (this.pendingChunks instanceof CompositeByteBuf) {
                            pending = (CompositeByteBuf)this.pendingChunks;
                        } else {
                            pending = Unpooled.compositeBuffer();
                            pending.addComponent(true, this.pendingChunks);
                            this.pendingChunks = pending;
                        }
                        pending.addComponent(true, buff);
                    }
                }
                if (end) {
                    this.tryComplete();
                    if (this.completionHandler != null) {
                        this.completionHandler.handle(null);
                    }
                }
                this.connect(null);
                return;
            }
        }
        s.writeBuffer(buff, end);
        if (end) {
            s.reportBytesWritten(this.written);
        }
        if (end) {
            Handler<Void> handler;
            HttpClientRequestImpl httpClientRequestImpl2 = this;
            synchronized (httpClientRequestImpl2) {
                this.tryComplete();
                s.endRequest();
                handler = this.completionHandler;
                if (handler == null) {
                    return;
                }
            }
            handler.handle(null);
        }
    }

    @Override
    protected void checkComplete() {
        if (this.completed) {
            throw new IllegalStateException("Request already complete");
        }
    }

    private void checkResponseHandler() {
        if (this.respHandler == null) {
            throw new IllegalStateException("You must set an handler for the HttpClientResponse before connecting");
        }
    }

    synchronized Handler<HttpClientRequest> pushHandler() {
        return this.pushHandler;
    }
}

