/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl.pool;

import io.netty.channel.Channel;
import io.vertx.core.Handler;
import io.vertx.core.http.ConnectionPoolTooBusyException;
import io.vertx.core.http.impl.pool.ConnectionListener;
import io.vertx.core.http.impl.pool.ConnectionProvider;
import io.vertx.core.http.impl.pool.Waiter;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Queue;
import java.util.function.BiConsumer;

public class Pool<C> {
    private static final Logger log = LoggerFactory.getLogger(Pool.class);
    private final ConnectionProvider<C> connector;
    private final BiConsumer<Channel, C> connectionAdded;
    private final BiConsumer<Channel, C> connectionRemoved;
    private final int queueMaxSize;
    private final Queue<Waiter<C>> waitersQueue = new ArrayDeque<Waiter<C>>();
    private int waitersCount;
    private final Deque<Holder<C>> available;
    private final long maxWeight;
    private long weight;
    private boolean closed;
    private final Handler<Void> poolClosed;

    public Pool(ConnectionProvider<C> connector, int queueMaxSize, long maxWeight, Handler<Void> poolClosed, BiConsumer<Channel, C> connectionAdded, BiConsumer<Channel, C> connectionRemoved) {
        this.maxWeight = maxWeight;
        this.connector = connector;
        this.queueMaxSize = queueMaxSize;
        this.poolClosed = poolClosed;
        this.available = new ArrayDeque<Holder<C>>();
        this.connectionAdded = connectionAdded;
        this.connectionRemoved = connectionRemoved;
    }

    public synchronized int waitersInQueue() {
        return this.waitersQueue.size();
    }

    public synchronized int waitersCount() {
        return this.waitersCount;
    }

    public synchronized long weight() {
        return this.weight;
    }

    public synchronized long capacity() {
        return this.available.stream().mapToLong(c -> c.capacity).sum();
    }

    public synchronized boolean getConnection(Waiter<C> waiter) {
        if (this.closed) {
            return false;
        }
        int size = this.waitersQueue.size();
        if (size == 0 && this.acquireConnection(waiter)) {
            ++this.waitersCount;
        } else if (this.queueMaxSize < 0 || size < this.queueMaxSize) {
            ++this.waitersCount;
            this.waitersQueue.add(waiter);
        } else {
            waiter.context.nettyEventLoop().execute(() -> waiter.handleFailure(waiter.context, new ConnectionPoolTooBusyException("Connection pool reached max wait queue size of " + this.queueMaxSize)));
        }
        return true;
    }

    private boolean acquireConnection(Waiter<C> waiter) {
        if (this.available.size() > 0) {
            Holder<C> conn = this.available.peek();
            if (--conn.capacity == 0L) {
                this.available.poll();
            }
            ContextImpl ctx = conn.context;
            ctx.nettyEventLoop().execute(() -> {
                boolean handled = this.deliverToWaiter(conn, waiter);
                Pool pool = this;
                synchronized (pool) {
                    --this.waitersCount;
                    if (!handled) {
                        Pool pool2 = this;
                        synchronized (pool2) {
                            this.recycleConnection(conn, 1, false);
                            this.checkPending();
                        }
                    }
                }
            });
            return true;
        }
        if (this.weight < this.maxWeight) {
            this.weight += this.createConnection(waiter);
            return true;
        }
        return false;
    }

    private void checkPending() {
        Waiter<C> waiter;
        while (this.waitersQueue.size() > 0 && this.acquireConnection(waiter = this.waitersQueue.peek())) {
            this.waitersQueue.poll();
        }
    }

    private long createConnection(final Waiter<C> waiter) {
        final Holder holder = new Holder();
        ConnectionListener listener = new ConnectionListener<C>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConnectSuccess(C conn, long concurrency, Channel channel, ContextImpl context, long initialWeight, long actualWeight) {
                Pool pool = Pool.this;
                synchronized (pool) {
                    Pool.this.initConnection(holder, context, concurrency, conn, channel, initialWeight, actualWeight);
                }
                waiter.initConnection(context, conn);
                pool = Pool.this;
                synchronized (pool) {
                    if (holder.capacity == 0L) {
                        Pool.this.waitersQueue.add(waiter);
                        Pool.this.checkPending();
                        return;
                    }
                    Pool.this.waitersCount--;
                    --holder.capacity;
                    if (holder.capacity > 0L) {
                        Pool.this.available.add(holder);
                    }
                }
                boolean consumed = Pool.this.deliverToWaiter(holder, waiter);
                Pool pool2 = Pool.this;
                synchronized (pool2) {
                    if (!consumed) {
                        Pool.this.recycleConnection(holder, 1, false);
                    }
                    Pool.this.checkPending();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConnectFailure(ContextImpl context, Throwable err, long weight) {
                waiter.handleFailure(context, err);
                Pool pool = Pool.this;
                synchronized (pool) {
                    Pool.this.waitersCount--;
                    Pool pool2 = Pool.this;
                    pool2.weight = pool2.weight - weight;
                    holder.removed = true;
                    Pool.this.checkPending();
                    Pool.this.checkClose();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConcurrencyChange(long concurrency) {
                Pool pool = Pool.this;
                synchronized (pool) {
                    if (holder.removed) {
                        return;
                    }
                    if (holder.concurrency < concurrency) {
                        long diff = concurrency - holder.concurrency;
                        if (holder.capacity == 0L) {
                            Pool.this.available.add(holder);
                        }
                        holder.capacity += diff;
                        holder.concurrency = concurrency;
                        Pool.this.checkPending();
                    } else if (holder.concurrency > concurrency) {
                        throw new UnsupportedOperationException("Not yet implemented");
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRecycle(int capacity, boolean disposable) {
                if (capacity < 0) {
                    throw new IllegalArgumentException("Illegal capacity");
                }
                Pool pool = Pool.this;
                synchronized (pool) {
                    if (holder.removed) {
                        return;
                    }
                    Pool.this.recycle(holder, capacity, disposable);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDiscard() {
                Pool pool = Pool.this;
                synchronized (pool) {
                    if (holder.removed) {
                        return;
                    }
                    Pool.this.closed(holder);
                }
            }
        };
        return this.connector.connect(listener, waiter.context);
    }

    private synchronized void recycle(Holder<C> holder, int capacity, boolean closeable) {
        this.recycleConnection(holder, capacity, closeable);
        this.checkPending();
        this.checkClose();
    }

    private synchronized void closed(Holder<C> holder) {
        this.closeConnection(holder);
        this.checkPending();
        this.checkClose();
    }

    private void closeConnection(Holder<C> holder) {
        holder.removed = true;
        this.connectionRemoved.accept(holder.channel, holder.connection);
        if (holder.capacity > 0L) {
            this.available.remove(holder);
            holder.capacity = 0L;
        }
        this.weight -= holder.weight;
    }

    private boolean deliverToWaiter(Holder<C> conn, Waiter<C> waiter) {
        try {
            return waiter.handleConnection(conn.context, conn.connection);
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    private void recycleConnection(Holder<C> conn, int c, boolean closeable) {
        long newCapacity = conn.capacity + (long)c;
        if (newCapacity > conn.concurrency) {
            log.debug("Attempt to recycle a connection more than permitted");
            return;
        }
        if (closeable && newCapacity == conn.concurrency && this.waitersQueue.isEmpty()) {
            this.available.remove(conn);
            conn.capacity = 0L;
            this.connector.close(conn.connection);
        } else {
            if (conn.capacity == 0L) {
                this.available.add(conn);
            }
            conn.capacity = newCapacity;
        }
    }

    private void initConnection(Holder<C> holder, ContextImpl context, long concurrency, C conn, Channel channel, long oldWeight, long newWeight) {
        this.weight += newWeight - oldWeight;
        holder.context = context;
        holder.concurrency = concurrency;
        holder.connection = conn;
        holder.channel = channel;
        holder.weight = newWeight;
        holder.capacity = concurrency;
        this.connectionAdded.accept(holder.channel, holder.connection);
    }

    private void checkClose() {
        if (this.weight == 0L && this.waitersCount == 0) {
            this.closed = true;
            this.poolClosed.handle(null);
        }
    }

    public static class Holder<C> {
        boolean removed;
        C connection;
        long concurrency;
        long capacity;
        Channel channel;
        ContextImpl context;
        long weight;
    }
}

