/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.vertx.core.http.impl.AssembledLastHttpContent;
import io.vertx.core.http.impl.FrameType;
import io.vertx.core.http.impl.ws.WebSocketFrameImpl;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.net.impl.VertxHandler;

public abstract class VertxHttpHandler<C extends ConnectionBase>
extends VertxHandler<C> {
    private static ByteBuf safeBuffer(ByteBufHolder holder, ByteBufAllocator allocator) {
        return VertxHttpHandler.safeBuffer(holder.content(), allocator);
    }

    @Override
    protected Object decode(Object msg, ByteBufAllocator allocator) throws Exception {
        if (msg instanceof HttpContent) {
            HttpContent content = (HttpContent)msg;
            ByteBuf buf = content.content();
            if (buf != Unpooled.EMPTY_BUFFER && buf.isDirect()) {
                ByteBuf newBuf = VertxHttpHandler.safeBuffer((ByteBufHolder)content, allocator);
                if (msg instanceof LastHttpContent) {
                    LastHttpContent last = (LastHttpContent)msg;
                    return new AssembledLastHttpContent(newBuf, last.trailingHeaders(), last.getDecoderResult());
                }
                return new DefaultHttpContent(newBuf);
            }
        } else if (msg instanceof WebSocketFrame) {
            FrameType frameType;
            ByteBuf payload = VertxHttpHandler.safeBuffer((ByteBufHolder)((WebSocketFrame)msg), allocator);
            boolean isFinal = ((WebSocketFrame)msg).isFinalFragment();
            if (msg instanceof BinaryWebSocketFrame) {
                frameType = FrameType.BINARY;
            } else if (msg instanceof CloseWebSocketFrame) {
                frameType = FrameType.CLOSE;
            } else if (msg instanceof PingWebSocketFrame) {
                frameType = FrameType.PING;
            } else if (msg instanceof PongWebSocketFrame) {
                frameType = FrameType.PONG;
            } else if (msg instanceof TextWebSocketFrame) {
                frameType = FrameType.TEXT;
            } else if (msg instanceof ContinuationWebSocketFrame) {
                frameType = FrameType.CONTINUATION;
            } else {
                throw new IllegalStateException("Unsupported websocket msg " + msg);
            }
            return new WebSocketFrameImpl(frameType, payload, isFinal);
        }
        return msg;
    }
}

