/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.impl.NetClientBase;
import io.vertx.core.net.impl.NetSocketImpl;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.core.spi.metrics.TCPMetrics;

public class NetClientImpl
extends NetClientBase<NetSocketImpl>
implements NetClient,
MetricsProvider {
    private final int idleTimeout;
    private final boolean logEnabled;

    public NetClientImpl(VertxInternal vertx, NetClientOptions options) {
        this(vertx, options, true);
    }

    public NetClientImpl(VertxInternal vertx, NetClientOptions options, boolean useCreatingContext) {
        super(vertx, options, useCreatingContext);
        this.logEnabled = options.getLogActivity();
        this.idleTimeout = options.getIdleTimeout();
    }

    @Override
    public synchronized NetClient connect(int port, String host, Handler<AsyncResult<NetSocket>> connectHandler) {
        this.connect(port, host, null, connectHandler);
        return this;
    }

    @Override
    public NetClient connect(int port, String host, String serverName, Handler<AsyncResult<NetSocket>> connectHandler) {
        this.doConnect(port, host, serverName, connectHandler != null ? ar -> connectHandler.handle(ar.map(s -> s)) : null);
        return this;
    }

    @Override
    protected Object safeObject(Object msg, ByteBufAllocator allocator) {
        if (msg instanceof ByteBuf) {
            return VertxHandler.safeBuffer((ByteBuf)msg, allocator);
        }
        return msg;
    }

    @Override
    protected void initChannel(ChannelPipeline pipeline) {
        if (this.logEnabled) {
            pipeline.addLast("logging", (ChannelHandler)new LoggingHandler());
        }
        if (this.sslHelper.isSSL()) {
            pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        }
        if (this.idleTimeout > 0) {
            pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(0, 0, this.idleTimeout));
        }
    }

    @Override
    protected NetSocketImpl createConnection(VertxInternal vertx, Channel channel, String host, int port, ContextImpl context, SSLHelper helper, TCPMetrics metrics) {
        return new NetSocketImpl(vertx, channel, host, port, context, helper, metrics);
    }

    @Override
    protected void handleMsgReceived(NetSocketImpl conn, Object msg) {
        ByteBuf buf = (ByteBuf)msg;
        conn.handleDataReceived(Buffer.buffer(buf));
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

