/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.ClientOptionsBaseConverter;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.TCPSSLOptions;
import java.util.Objects;

@DataObject(generateConverter=true)
public abstract class ClientOptionsBase
extends TCPSSLOptions {
    public static final int DEFAULT_CONNECT_TIMEOUT = 60000;
    public static final boolean DEFAULT_TRUST_ALL = false;
    public static final String DEFAULT_METRICS_NAME = "";
    private int connectTimeout;
    private boolean trustAll;
    private String metricsName;
    private ProxyOptions proxyOptions;

    public ClientOptionsBase() {
        this.init();
    }

    public ClientOptionsBase(ClientOptionsBase other) {
        super(other);
        this.connectTimeout = other.getConnectTimeout();
        this.trustAll = other.isTrustAll();
        this.metricsName = other.metricsName;
        this.proxyOptions = other.proxyOptions != null ? new ProxyOptions(other.proxyOptions) : null;
    }

    public ClientOptionsBase(JsonObject json) {
        super(json);
        this.init();
        ClientOptionsBaseConverter.fromJson(json, this);
    }

    private void init() {
        this.connectTimeout = 60000;
        this.trustAll = false;
        this.metricsName = DEFAULT_METRICS_NAME;
        this.proxyOptions = null;
    }

    public boolean isTrustAll() {
        return this.trustAll;
    }

    public ClientOptionsBase setTrustAll(boolean trustAll) {
        this.trustAll = trustAll;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public ClientOptionsBase setConnectTimeout(int connectTimeout) {
        if (connectTimeout < 0) {
            throw new IllegalArgumentException("connectTimeout must be >= 0");
        }
        this.connectTimeout = connectTimeout;
        return this;
    }

    public String getMetricsName() {
        return this.metricsName;
    }

    public ClientOptionsBase setMetricsName(String metricsName) {
        this.metricsName = metricsName;
        return this;
    }

    public ClientOptionsBase setProxyOptions(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public ProxyOptions getProxyOptions() {
        return this.proxyOptions;
    }

    @Override
    public ClientOptionsBase setLogActivity(boolean logEnabled) {
        return (ClientOptionsBase)super.setLogActivity(logEnabled);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientOptionsBase)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClientOptionsBase that = (ClientOptionsBase)o;
        if (this.connectTimeout != that.connectTimeout) {
            return false;
        }
        if (this.trustAll != that.trustAll) {
            return false;
        }
        if (!Objects.equals(this.metricsName, that.metricsName)) {
            return false;
        }
        return Objects.equals(this.proxyOptions, that.proxyOptions);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.connectTimeout;
        result = 31 * result + (this.trustAll ? 1 : 0);
        result = 31 * result + (this.metricsName != null ? this.metricsName.hashCode() : 0);
        result = 31 * result + (this.proxyOptions != null ? this.proxyOptions.hashCode() : 0);
        return result;
    }
}

