/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.TrustOptions;

@DataObject
public class JksOptions
implements KeyCertOptions,
TrustOptions,
Cloneable {
    private String password;
    private String path;
    private Buffer value;

    public JksOptions() {
    }

    public JksOptions(JksOptions other) {
        this.password = other.getPassword();
        this.path = other.getPath();
        this.value = other.getValue();
    }

    public JksOptions(JsonObject json) {
        this.password = json.getString("password");
        this.path = json.getString("path");
        byte[] value = json.getBinary("value");
        this.value = value != null ? Buffer.buffer(value) : null;
    }

    public String getPassword() {
        return this.password;
    }

    public JksOptions setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public JksOptions setPath(String path) {
        this.path = path;
        return this;
    }

    public Buffer getValue() {
        return this.value;
    }

    public JksOptions setValue(Buffer value) {
        this.value = value;
        return this;
    }

    @Override
    public JksOptions clone() {
        return new JksOptions(this);
    }
}

