/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.parsetools;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.Arguments;
import java.util.Objects;

public class RecordParser
implements Handler<Buffer> {
    private Buffer buff;
    private int pos;
    private int start;
    private int delimPos;
    private boolean reset;
    private boolean delimited;
    private byte[] delim;
    private int recordSize;
    private Handler<Buffer> output;

    private RecordParser(Handler<Buffer> output) {
        this.output = output;
    }

    public void setOutput(Handler<Buffer> output) {
        Objects.requireNonNull(output, "output");
        this.output = output;
    }

    public static byte[] latin1StringToBytes(String str) {
        byte[] bytes = new byte[str.length()];
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            bytes[i] = (byte)(c & 0xFF);
        }
        return bytes;
    }

    public static RecordParser newDelimited(String delim, Handler<Buffer> output) {
        return RecordParser.newDelimited(RecordParser.latin1StringToBytes(delim), output);
    }

    public static RecordParser newDelimited(byte[] delim, Handler<Buffer> output) {
        RecordParser ls = new RecordParser(output);
        ls.delimitedMode(delim);
        return ls;
    }

    public static RecordParser newFixed(int size, Handler<Buffer> output) {
        Arguments.require(size > 0, "Size must be > 0");
        RecordParser ls = new RecordParser(output);
        ls.fixedSizeMode(size);
        return ls;
    }

    public void delimitedMode(String delim) {
        this.delimitedMode(RecordParser.latin1StringToBytes(delim));
    }

    public void delimitedMode(byte[] delim) {
        Objects.requireNonNull(delim, "delim");
        this.delimited = true;
        this.delim = delim;
        this.delimPos = 0;
        this.reset = true;
    }

    public void fixedSizeMode(int size) {
        Arguments.require(size > 0, "Size must be > 0");
        this.delimited = false;
        this.recordSize = size;
        this.reset = true;
    }

    private void handleParsing() {
        int len = this.buff.length();
        do {
            this.reset = false;
            if (this.delimited) {
                this.parseDelimited();
                continue;
            }
            this.parseFixed();
        } while (this.reset);
        if (this.start == len) {
            this.buff = null;
            this.pos = 0;
        } else {
            this.buff = this.buff.getBuffer(this.start, len);
            this.pos = this.buff.length();
        }
        this.start = 0;
    }

    private void parseDelimited() {
        int len = this.buff.length();
        while (this.pos < len && !this.reset) {
            if (this.buff.getByte(this.pos) == this.delim[this.delimPos]) {
                ++this.delimPos;
                if (this.delimPos == this.delim.length) {
                    Buffer ret = this.buff.getBuffer(this.start, this.pos - this.delim.length + 1);
                    this.start = this.pos + 1;
                    this.delimPos = 0;
                    this.output.handle(ret);
                }
            } else if (this.delimPos > 0) {
                this.pos -= this.delimPos;
                this.delimPos = 0;
            }
            ++this.pos;
        }
    }

    private void parseFixed() {
        int len = this.buff.length();
        while (len - this.start >= this.recordSize && !this.reset) {
            int end = this.start + this.recordSize;
            Buffer ret = this.buff.getBuffer(this.start, end);
            this.start = end;
            this.pos = this.start - 1;
            this.output.handle(ret);
        }
    }

    @Override
    public void handle(Buffer buffer) {
        if (this.buff == null) {
            this.buff = buffer;
        } else {
            this.buff.appendBuffer(buffer);
        }
        this.handleParsing();
    }
}

