/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.impl.ConnectionBase;
import java.util.Map;

public abstract class VertxHandler<C extends ConnectionBase>
extends ChannelDuplexHandler {
    protected final VertxInternal vertx;
    protected final Map<Channel, C> connectionMap;

    protected VertxHandler(VertxInternal vertx, Map<Channel, C> connectionMap) {
        this.vertx = vertx;
        this.connectionMap = connectionMap;
    }

    protected ContextImpl getContext(C connection) {
        return ((ConnectionBase)connection).getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ByteBuf safeBuffer(ByteBuf buf, ByteBufAllocator allocator) {
        if (buf == Unpooled.EMPTY_BUFFER) {
            return buf;
        }
        if (buf.isDirect() || buf instanceof CompositeByteBuf) {
            try {
                if (buf.isReadable()) {
                    ByteBuf buffer = allocator.heapBuffer(buf.readableBytes());
                    buffer.writeBytes(buf);
                    ByteBuf byteBuf = buffer;
                    return byteBuf;
                }
                ByteBuf byteBuf = Unpooled.EMPTY_BUFFER;
                return byteBuf;
            }
            finally {
                buf.release();
            }
        }
        return buf;
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        Channel ch = ctx.channel();
        ConnectionBase conn = (ConnectionBase)this.connectionMap.get(ch);
        if (conn != null) {
            ContextImpl context = this.getContext(conn);
            context.executeSync(conn::handleInterestedOpsChanged);
        }
    }

    public void exceptionCaught(ChannelHandlerContext chctx, Throwable t) throws Exception {
        Channel ch = chctx.channel();
        ConnectionBase connection = (ConnectionBase)this.connectionMap.get(ch);
        if (connection != null) {
            ContextImpl context = this.getContext(connection);
            context.executeSync(() -> {
                try {
                    if (ch.isOpen()) {
                        ch.close();
                    }
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                connection.handleException(t);
            });
        } else {
            ch.close();
        }
    }

    public void channelInactive(ChannelHandlerContext chctx) throws Exception {
        Channel ch = chctx.channel();
        ConnectionBase connection = (ConnectionBase)this.connectionMap.remove(ch);
        if (connection != null) {
            ContextImpl context = this.getContext(connection);
            context.executeSync(connection::handleClosed);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ConnectionBase conn = (ConnectionBase)this.connectionMap.get(ctx.channel());
        if (conn != null) {
            ContextImpl context = this.getContext(conn);
            context.executeSync(conn::endReadAndFlush);
        }
    }

    public void channelRead(ChannelHandlerContext chctx, Object msg) throws Exception {
        ContextImpl context;
        Object message = this.safeObject(msg, chctx.alloc());
        ConnectionBase connection = (ConnectionBase)this.connectionMap.get(chctx.channel());
        if (connection != null) {
            context = this.getContext(connection);
            context.executeSync(connection::startRead);
        } else {
            context = null;
        }
        this.channelRead(connection, context, chctx, message);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent && ((IdleStateEvent)evt).state() == IdleState.ALL_IDLE) {
            ctx.close();
        }
    }

    protected abstract void channelRead(C var1, ContextImpl var2, ChannelHandlerContext var3, Object var4) throws Exception;

    protected abstract Object safeObject(Object var1, ByteBufAllocator var2) throws Exception;
}

