/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.TrustOptions;

@DataObject
public class PfxOptions
implements KeyCertOptions,
TrustOptions,
Cloneable {
    private String password;
    private String path;
    private Buffer value;

    public PfxOptions() {
    }

    public PfxOptions(PfxOptions other) {
        this.password = other.getPassword();
        this.path = other.getPath();
        this.value = other.getValue();
    }

    public PfxOptions(JsonObject json) {
        this.password = json.getString("password");
        this.path = json.getString("path");
        byte[] value = json.getBinary("value");
        this.value = value != null ? Buffer.buffer(value) : null;
    }

    public String getPassword() {
        return this.password;
    }

    public PfxOptions setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public PfxOptions setPath(String path) {
        this.path = path;
        return this;
    }

    public Buffer getValue() {
        return this.value;
    }

    public PfxOptions setValue(Buffer value) {
        this.value = value;
        return this;
    }

    @Override
    public PfxOptions clone() {
        return new PfxOptions(this);
    }
}

