/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.impl.ContextImpl;
import java.lang.ref.WeakReference;

final class VertxThread
extends Thread {
    private final boolean worker;
    private long execStart;
    private WeakReference<ContextImpl> contextRef;

    public VertxThread(Runnable target, String name, boolean worker) {
        super(target, name);
        this.worker = worker;
    }

    ContextImpl getContext() {
        return this.contextRef == null ? null : (ContextImpl)this.contextRef.get();
    }

    void setContext(ContextImpl context) {
        this.contextRef = new WeakReference<ContextImpl>(context);
    }

    public void executeStart() {
        this.execStart = System.nanoTime();
    }

    public void executeEnd() {
        this.execStart = 0L;
    }

    public long startTime() {
        return this.execStart;
    }

    public boolean isWorker() {
        return this.worker;
    }
}

