/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.codegen.annotations.Options;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.KeyStoreOptions;
import io.vertx.core.net.TrustStoreOptions;

@Options
public class JKSOptions
implements KeyStoreOptions,
TrustStoreOptions,
Cloneable {
    private String password;
    private String path;
    private Buffer value;

    public JKSOptions() {
    }

    public JKSOptions(JKSOptions other) {
        this.password = other.getPassword();
        this.path = other.getPath();
        this.value = other.getValue();
    }

    public JKSOptions(JsonObject json) {
        this.password = json.getString("password");
        this.path = json.getString("path");
        byte[] value = json.getBinary("value");
        this.value = value != null ? Buffer.buffer(value) : null;
    }

    public String getPassword() {
        return this.password;
    }

    public JKSOptions setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public JKSOptions setPath(String path) {
        this.path = path;
        return this;
    }

    public Buffer getValue() {
        return this.value;
    }

    public JKSOptions setValue(Buffer value) {
        this.value = value;
        return this;
    }

    @Override
    public JKSOptions clone() {
        return new JKSOptions(this);
    }
}

