/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.impl.AssembledFullHttpRequest;
import io.vertx.core.http.impl.AssembledHttpRequest;
import io.vertx.core.http.impl.ClientConnection;
import io.vertx.core.http.impl.HeadersAdaptor;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.HttpClientResponseImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.impl.LoggerFactory;
import io.vertx.core.net.NetSocket;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeoutException;

public class HttpClientRequestImpl
implements HttpClientRequest {
    private static final Logger log = LoggerFactory.getLogger(HttpClientRequestImpl.class);
    private final String host;
    private final int port;
    private final HttpClientImpl client;
    private final HttpRequest request;
    private final VertxInternal vertx;
    private final HttpMethod method;
    private Handler<HttpClientResponse> respHandler;
    private Handler<Void> endHandler;
    private boolean chunked;
    private Handler<Void> continueHandler;
    private ClientConnection conn;
    private Handler<Void> drainHandler;
    private Handler<Throwable> exceptionHandler;
    private boolean headWritten;
    private boolean completed;
    private ByteBuf pendingChunks;
    private int pendingMaxSize = -1;
    private boolean connecting;
    private boolean writeHead;
    private long written;
    private long currentTimeoutTimerId = -1L;
    private MultiMap headers;
    private boolean exceptionOccurred;
    private long lastDataReceived;

    HttpClientRequestImpl(HttpClientImpl client, HttpMethod method, String host, int port, String relativeURI, VertxInternal vertx) {
        this.host = host;
        this.port = port;
        this.client = client;
        this.request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, this.toNettyHttpMethod(method), relativeURI, false);
        this.chunked = false;
        this.method = method;
        this.vertx = vertx;
    }

    @Override
    public synchronized HttpClientRequest handler(Handler<HttpClientResponse> handler) {
        if (handler != null) {
            this.checkComplete();
            this.respHandler = this.checkConnect(this.method, handler);
        } else {
            this.respHandler = null;
        }
        return this;
    }

    @Override
    public HttpClientRequest pause() {
        return this;
    }

    @Override
    public HttpClientRequest resume() {
        return this;
    }

    @Override
    public synchronized HttpClientRequest endHandler(Handler<Void> endHandler) {
        if (endHandler != null) {
            this.checkComplete();
        }
        this.endHandler = endHandler;
        return this;
    }

    @Override
    public synchronized HttpClientRequestImpl setChunked(boolean chunked) {
        this.checkComplete();
        if (this.written > 0L) {
            throw new IllegalStateException("Cannot set chunked after data has been written on request");
        }
        this.chunked = chunked;
        return this;
    }

    @Override
    public synchronized boolean isChunked() {
        return this.chunked;
    }

    @Override
    public HttpMethod method() {
        return this.method;
    }

    @Override
    public String uri() {
        return this.request.getUri();
    }

    @Override
    public synchronized MultiMap headers() {
        if (this.headers == null) {
            this.headers = new HeadersAdaptor(this.request.headers());
        }
        return this.headers;
    }

    @Override
    public synchronized HttpClientRequest putHeader(String name, String value) {
        this.checkComplete();
        this.headers().set(name, value);
        return this;
    }

    @Override
    public synchronized HttpClientRequest putHeader(String name, Iterable<String> values) {
        this.checkComplete();
        this.headers().set(name, values);
        return this;
    }

    @Override
    public synchronized HttpClientRequestImpl write(Buffer chunk) {
        this.checkComplete();
        this.checkResponseHandler();
        ByteBuf buf = chunk.getByteBuf();
        this.write(buf, false);
        return this;
    }

    @Override
    public synchronized HttpClientRequestImpl write(String chunk) {
        this.checkComplete();
        this.checkResponseHandler();
        return this.write(Buffer.buffer(chunk));
    }

    @Override
    public synchronized HttpClientRequestImpl write(String chunk, String enc) {
        Objects.requireNonNull(enc, "no null encoding accepted");
        this.checkComplete();
        this.checkResponseHandler();
        return this.write(Buffer.buffer(chunk, enc));
    }

    @Override
    public synchronized HttpClientRequest setWriteQueueMaxSize(int maxSize) {
        this.checkComplete();
        if (this.conn != null) {
            this.conn.doSetWriteQueueMaxSize(maxSize);
        } else {
            this.pendingMaxSize = maxSize;
        }
        return this;
    }

    @Override
    public synchronized boolean writeQueueFull() {
        this.checkComplete();
        if (this.conn != null) {
            return this.conn.isNotWritable();
        }
        return false;
    }

    @Override
    public synchronized HttpClientRequest drainHandler(Handler<Void> handler) {
        this.checkComplete();
        this.drainHandler = handler;
        if (this.conn != null) {
            this.conn.getContext().runOnContext(v -> this.conn.handleInterestedOpsChanged());
        }
        return this;
    }

    @Override
    public synchronized HttpClientRequest exceptionHandler(Handler<Throwable> handler) {
        if (handler != null) {
            this.checkComplete();
            this.exceptionHandler = t -> {
                this.cancelOutstandingTimeoutTimer();
                handler.handle((Throwable)t);
            };
        } else {
            this.exceptionHandler = null;
        }
        return this;
    }

    @Override
    public synchronized HttpClientRequest continueHandler(Handler<Void> handler) {
        this.checkComplete();
        this.continueHandler = handler;
        return this;
    }

    @Override
    public synchronized HttpClientRequestImpl sendHead() {
        this.checkComplete();
        this.checkResponseHandler();
        if (this.conn != null) {
            if (!this.headWritten) {
                this.writeHead();
            }
        } else {
            this.connect();
            this.writeHead = true;
        }
        return this;
    }

    @Override
    public synchronized void end(String chunk) {
        this.end(Buffer.buffer(chunk));
    }

    @Override
    public synchronized void end(String chunk, String enc) {
        Objects.requireNonNull(enc, "no null encoding accepted");
        this.end(Buffer.buffer(chunk, enc));
    }

    @Override
    public synchronized void end(Buffer chunk) {
        this.checkComplete();
        this.checkResponseHandler();
        if (!this.chunked && !this.contentLengthSet()) {
            this.headers().set(HttpHeaders.CONTENT_LENGTH, (CharSequence)String.valueOf(chunk.length()));
        }
        this.write(chunk.getByteBuf(), true);
    }

    @Override
    public synchronized void end() {
        this.checkComplete();
        this.checkResponseHandler();
        this.write(Unpooled.EMPTY_BUFFER, true);
    }

    @Override
    public synchronized HttpClientRequest setTimeout(long timeoutMs) {
        this.cancelOutstandingTimeoutTimer();
        this.currentTimeoutTimerId = this.client.getVertx().setTimer(timeoutMs, id -> this.handleTimeout(timeoutMs));
        return this;
    }

    @Override
    public synchronized HttpClientRequest putHeader(CharSequence name, CharSequence value) {
        this.checkComplete();
        this.headers().set(name, value);
        return this;
    }

    @Override
    public synchronized HttpClientRequest putHeader(CharSequence name, Iterable<CharSequence> values) {
        this.checkComplete();
        this.headers().set(name, values);
        return this;
    }

    synchronized void dataReceived() {
        if (this.currentTimeoutTimerId != -1L) {
            this.lastDataReceived = System.currentTimeMillis();
        }
    }

    synchronized void handleDrained() {
        if (this.drainHandler != null) {
            this.drainHandler.handle(null);
        }
    }

    synchronized void handleException(Throwable t) {
        this.cancelOutstandingTimeoutTimer();
        this.exceptionOccurred = true;
        this.getExceptionHandler().handle(t);
    }

    synchronized void handleResponse(HttpClientResponseImpl resp) {
        if (!this.exceptionOccurred) {
            this.cancelOutstandingTimeoutTimer();
            try {
                if (resp.statusCode() == 100) {
                    if (this.continueHandler != null) {
                        this.continueHandler.handle(null);
                    }
                } else {
                    if (this.respHandler != null) {
                        this.respHandler.handle(resp);
                    }
                    if (this.endHandler != null) {
                        this.endHandler.handle(null);
                    }
                }
            }
            catch (Throwable t) {
                this.handleException(t);
            }
        }
    }

    synchronized HttpRequest getRequest() {
        return this.request;
    }

    private Handler<HttpClientResponse> checkConnect(HttpMethod method, Handler<HttpClientResponse> handler) {
        if (method == HttpMethod.CONNECT) {
            handler = this.connectHandler(handler);
        }
        return handler;
    }

    private Handler<HttpClientResponse> connectHandler(Handler<HttpClientResponse> responseHandler) {
        Objects.requireNonNull(responseHandler, "no null responseHandler accepted");
        return resp -> {
            HttpClientResponse response;
            if (resp.statusCode() == 200) {
                NetSocket socket = resp.netSocket();
                socket.pause();
                response = new HttpClientResponse((HttpClientResponse)resp, socket){
                    private boolean resumed;
                    final /* synthetic */ HttpClientResponse val$resp;
                    final /* synthetic */ NetSocket val$socket;
                    {
                        this.val$resp = httpClientResponse;
                        this.val$socket = netSocket;
                    }

                    @Override
                    public int statusCode() {
                        return this.val$resp.statusCode();
                    }

                    @Override
                    public String statusMessage() {
                        return this.val$resp.statusMessage();
                    }

                    @Override
                    public MultiMap headers() {
                        return this.val$resp.headers();
                    }

                    @Override
                    public MultiMap trailers() {
                        return this.val$resp.trailers();
                    }

                    @Override
                    public List<String> cookies() {
                        return this.val$resp.cookies();
                    }

                    @Override
                    public HttpClientResponse bodyHandler(Handler<Buffer> bodyHandler) {
                        this.val$resp.bodyHandler(bodyHandler);
                        return this;
                    }

                    @Override
                    public synchronized NetSocket netSocket() {
                        if (!this.resumed) {
                            this.resumed = true;
                            HttpClientRequestImpl.this.vertx.getContext().runOnContext(v -> this.val$socket.resume());
                        }
                        return this.val$socket;
                    }

                    @Override
                    public HttpClientResponse endHandler(Handler<Void> endHandler) {
                        this.val$resp.endHandler((Handler)endHandler);
                        return this;
                    }

                    @Override
                    public HttpClientResponse handler(Handler<Buffer> handler) {
                        this.val$resp.handler((Handler)handler);
                        return this;
                    }

                    @Override
                    public HttpClientResponse pause() {
                        this.val$resp.pause();
                        return this;
                    }

                    @Override
                    public HttpClientResponse resume() {
                        this.val$resp.resume();
                        return this;
                    }

                    @Override
                    public HttpClientResponse exceptionHandler(Handler<Throwable> handler) {
                        this.val$resp.exceptionHandler((Handler)handler);
                        return this;
                    }
                };
            } else {
                response = resp;
            }
            responseHandler.handle(response);
        };
    }

    private Handler<Throwable> getExceptionHandler() {
        return this.exceptionHandler != null ? this.exceptionHandler : log::error;
    }

    private void cancelOutstandingTimeoutTimer() {
        if (this.currentTimeoutTimerId != -1L) {
            this.client.getVertx().cancelTimer(this.currentTimeoutTimerId);
            this.currentTimeoutTimerId = -1L;
        }
    }

    private void handleTimeout(long timeoutMs) {
        if (this.lastDataReceived == 0L) {
            this.timeout(timeoutMs);
        } else {
            long now = System.currentTimeMillis();
            long timeSinceLastData = now - this.lastDataReceived;
            if (timeSinceLastData >= timeoutMs) {
                this.timeout(timeoutMs);
            } else {
                this.lastDataReceived = 0L;
                this.setTimeout(timeoutMs - timeSinceLastData);
            }
        }
    }

    private void timeout(long timeoutMs) {
        this.handleException(new TimeoutException("The timeout period of " + timeoutMs + "ms has been exceeded"));
    }

    private synchronized void connect() {
        if (!this.connecting) {
            this.client.getConnection(this.port, this.host, conn -> {
                HttpClientRequestImpl httpClientRequestImpl = this;
                synchronized (httpClientRequestImpl) {
                    if (this.exceptionOccurred) {
                        conn.close();
                    } else if (!conn.isClosed()) {
                        this.connected((ClientConnection)conn);
                    } else {
                        this.connect();
                    }
                }
            }, this.exceptionHandler, this.vertx.getOrCreateContext());
            this.connecting = true;
        }
    }

    private void connected(ClientConnection conn) {
        conn.setCurrentRequest(this);
        this.conn = conn;
        if (this.pendingMaxSize != -1) {
            conn.doSetWriteQueueMaxSize(this.pendingMaxSize);
        }
        if (this.pendingChunks != null) {
            ByteBuf pending = this.pendingChunks;
            this.pendingChunks = null;
            if (this.completed) {
                this.writeHeadWithContent(pending, true);
                if (conn.metrics().isEnabled()) {
                    conn.metrics().bytesWritten(conn.remoteAddress(), this.written);
                }
                if (this.respHandler != null) {
                    conn.endRequest();
                }
            } else {
                this.writeHeadWithContent(pending, false);
            }
        } else if (this.completed) {
            this.writeHeadWithContent(Unpooled.EMPTY_BUFFER, true);
            if (conn.metrics().isEnabled()) {
                conn.metrics().bytesWritten(conn.remoteAddress(), this.written);
            }
            if (this.respHandler != null) {
                conn.endRequest();
            }
        } else if (this.writeHead) {
            this.writeHead();
        }
    }

    private boolean contentLengthSet() {
        if (this.headers != null) {
            return this.request.headers().contains(HttpHeaders.CONTENT_LENGTH);
        }
        return false;
    }

    private void writeHead() {
        this.prepareHeaders();
        this.conn.writeToChannel(this.request);
        this.headWritten = true;
    }

    private void writeHeadWithContent(ByteBuf buf, boolean end) {
        this.prepareHeaders();
        if (end) {
            this.conn.writeToChannel(new AssembledFullHttpRequest(this.request, buf));
        } else {
            this.conn.writeToChannel(new AssembledHttpRequest(this.request, buf));
        }
        this.headWritten = true;
    }

    private void prepareHeaders() {
        io.netty.handler.codec.http.HttpHeaders headers = this.request.headers();
        headers.remove(HttpHeaders.TRANSFER_ENCODING);
        if (!headers.contains(HttpHeaders.HOST)) {
            this.request.headers().set(HttpHeaders.HOST, (Object)this.conn.hostHeader());
        }
        if (this.chunked) {
            io.netty.handler.codec.http.HttpHeaders.setTransferEncodingChunked((HttpMessage)this.request);
        }
        if (this.client.getOptions().isTryUseCompression() && this.request.headers().get(HttpHeaders.ACCEPT_ENCODING) == null) {
            this.request.headers().set(HttpHeaders.ACCEPT_ENCODING, (Object)HttpHeaders.DEFLATE_GZIP);
        }
    }

    private void write(ByteBuf buff, boolean end) {
        int readableBytes = buff.readableBytes();
        if (readableBytes == 0 && !end) {
            return;
        }
        if (end) {
            this.completed = true;
        }
        if (!(end || this.chunked || this.contentLengthSet())) {
            throw new IllegalStateException("You must set the Content-Length header to be the total size of the message body BEFORE sending any data if you are not using HTTP chunked encoding.");
        }
        this.written += (long)buff.readableBytes();
        if (this.conn == null) {
            if (this.pendingChunks == null) {
                this.pendingChunks = buff;
            } else {
                CompositeByteBuf pending;
                if (this.pendingChunks instanceof CompositeByteBuf) {
                    pending = (CompositeByteBuf)this.pendingChunks;
                } else {
                    pending = Unpooled.compositeBuffer();
                    pending.addComponent(this.pendingChunks).writerIndex(this.pendingChunks.writerIndex());
                    this.pendingChunks = pending;
                }
                pending.addComponent(buff).writerIndex(pending.writerIndex() + buff.writerIndex());
            }
            this.connect();
        } else {
            if (!this.headWritten) {
                this.writeHeadWithContent(buff, end);
            } else if (end) {
                if (buff.isReadable()) {
                    this.conn.writeToChannel(new DefaultLastHttpContent(buff, false));
                } else {
                    this.conn.writeToChannel(LastHttpContent.EMPTY_LAST_CONTENT);
                }
            } else {
                this.conn.writeToChannel(new DefaultHttpContent(buff));
            }
            if (end) {
                if (this.conn.metrics().isEnabled()) {
                    this.conn.metrics().bytesWritten(this.conn.remoteAddress(), this.written);
                }
                if (this.respHandler != null) {
                    this.conn.endRequest();
                }
            }
        }
    }

    private void checkComplete() {
        if (this.completed) {
            throw new IllegalStateException("Request already complete");
        }
    }

    private void checkResponseHandler() {
        if (this.respHandler == null) {
            throw new IllegalStateException("You must set an handler for the HttpClientResponse before connecting");
        }
    }

    private io.netty.handler.codec.http.HttpMethod toNettyHttpMethod(HttpMethod method) {
        switch (method) {
            case CONNECT: {
                return io.netty.handler.codec.http.HttpMethod.CONNECT;
            }
            case GET: {
                return io.netty.handler.codec.http.HttpMethod.GET;
            }
            case PUT: {
                return io.netty.handler.codec.http.HttpMethod.PUT;
            }
            case POST: {
                return io.netty.handler.codec.http.HttpMethod.POST;
            }
            case DELETE: {
                return io.netty.handler.codec.http.HttpMethod.DELETE;
            }
            case HEAD: {
                return io.netty.handler.codec.http.HttpMethod.HEAD;
            }
            case OPTIONS: {
                return io.netty.handler.codec.http.HttpMethod.OPTIONS;
            }
            case TRACE: {
                return io.netty.handler.codec.http.HttpMethod.TRACE;
            }
            case PATCH: {
                return io.netty.handler.codec.http.HttpMethod.PATCH;
            }
        }
        throw new IllegalArgumentException();
    }
}

