/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.codegen.annotations.Options;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.KeyStoreOptions;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.TrustStoreOptions;

@Options
public class HttpServerOptions
extends NetServerOptions {
    public static final int DEFAULT_PORT = 80;
    public static final boolean DEFAULT_COMPRESSION_SUPPORTED = false;
    public static final int DEFAULT_MAX_WEBSOCKET_FRAME_SIZE = 65536;
    private boolean compressionSupported;
    private int maxWebsocketFrameSize;
    private String websocketSubProtocols;

    public HttpServerOptions(HttpServerOptions other) {
        super(other);
        this.compressionSupported = other.isCompressionSupported();
        this.maxWebsocketFrameSize = other.getMaxWebsocketFrameSize();
        this.websocketSubProtocols = other.getWebsocketSubProtocols();
    }

    public HttpServerOptions(JsonObject json) {
        super(json);
        this.compressionSupported = json.getBoolean("compressionSupported", false);
        this.maxWebsocketFrameSize = json.getInteger("maxWebsocketFrameSize", 65536);
        this.websocketSubProtocols = json.getString("websocketSubProtocols", null);
        this.setPort(json.getInteger("port", 80));
    }

    public HttpServerOptions() {
        this.setPort(80);
        this.compressionSupported = false;
        this.maxWebsocketFrameSize = 65536;
    }

    @Override
    public HttpServerOptions setSendBufferSize(int sendBufferSize) {
        super.setSendBufferSize(sendBufferSize);
        return this;
    }

    @Override
    public HttpServerOptions setReceiveBufferSize(int receiveBufferSize) {
        super.setReceiveBufferSize(receiveBufferSize);
        return this;
    }

    @Override
    public HttpServerOptions setReuseAddress(boolean reuseAddress) {
        super.setReuseAddress(reuseAddress);
        return this;
    }

    @Override
    public HttpServerOptions setTrafficClass(int trafficClass) {
        super.setTrafficClass(trafficClass);
        return this;
    }

    @Override
    public HttpServerOptions setTcpNoDelay(boolean tcpNoDelay) {
        super.setTcpNoDelay(tcpNoDelay);
        return this;
    }

    @Override
    public HttpServerOptions setTcpKeepAlive(boolean tcpKeepAlive) {
        super.setTcpKeepAlive(tcpKeepAlive);
        return this;
    }

    @Override
    public HttpServerOptions setSoLinger(int soLinger) {
        super.setSoLinger(soLinger);
        return this;
    }

    @Override
    public HttpServerOptions setUsePooledBuffers(boolean usePooledBuffers) {
        super.setUsePooledBuffers(usePooledBuffers);
        return this;
    }

    @Override
    public HttpServerOptions setIdleTimeout(int idleTimeout) {
        super.setIdleTimeout(idleTimeout);
        return this;
    }

    @Override
    public HttpServerOptions setSsl(boolean ssl) {
        super.setSsl(ssl);
        return this;
    }

    @Override
    public HttpServerOptions setKeyStoreOptions(KeyStoreOptions keyStore) {
        super.setKeyStoreOptions(keyStore);
        return this;
    }

    @Override
    public HttpServerOptions setTrustStoreOptions(TrustStoreOptions trustStore) {
        super.setTrustStoreOptions(trustStore);
        return this;
    }

    @Override
    public HttpServerOptions addEnabledCipherSuite(String suite) {
        super.addEnabledCipherSuite(suite);
        return this;
    }

    @Override
    public HttpServerOptions setAcceptBacklog(int acceptBacklog) {
        super.setAcceptBacklog(acceptBacklog);
        return this;
    }

    @Override
    public HttpServerOptions setPort(int port) {
        super.setPort(port);
        return this;
    }

    @Override
    public HttpServerOptions setHost(String host) {
        super.setHost(host);
        return this;
    }

    public boolean isCompressionSupported() {
        return this.compressionSupported;
    }

    public HttpServerOptions setCompressionSupported(boolean compressionSupported) {
        this.compressionSupported = compressionSupported;
        return this;
    }

    public int getMaxWebsocketFrameSize() {
        return this.maxWebsocketFrameSize;
    }

    public HttpServerOptions setMaxWebsocketFrameSize(int maxWebsocketFrameSize) {
        this.maxWebsocketFrameSize = maxWebsocketFrameSize;
        return this;
    }

    public HttpServerOptions setWebsocketSubProtocol(String subProtocols) {
        this.websocketSubProtocols = subProtocols;
        return this;
    }

    public String getWebsocketSubProtocols() {
        return this.websocketSubProtocols;
    }

    @Override
    public HttpServerOptions setClientAuthRequired(boolean clientAuthRequired) {
        super.setClientAuthRequired(clientAuthRequired);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpServerOptions)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HttpServerOptions that = (HttpServerOptions)o;
        if (this.compressionSupported != that.compressionSupported) {
            return false;
        }
        if (this.maxWebsocketFrameSize != that.maxWebsocketFrameSize) {
            return false;
        }
        return this.websocketSubProtocols == that.websocketSubProtocols;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.compressionSupported ? 1 : 0);
        result = 31 * result + this.maxWebsocketFrameSize;
        result = 31 * result + (this.websocketSubProtocols != null ? this.websocketSubProtocols.hashCode() : 0);
        return result;
    }
}

