/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.datagram;

import io.vertx.codegen.annotations.Options;
import io.vertx.core.impl.Arguments;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetworkOptions;

@Options
public class DatagramSocketOptions
extends NetworkOptions {
    public static final boolean DEFAULT_BROADCAST = false;
    public static final boolean DEFAULT_LOOPBACK_MODE_DISABLED = true;
    public static final int DEFAULT_MULTICAST_TIME_TO_LIVE = -1;
    public static final String DEFAULT_MULTICAST_NETWORK_INTERFACE = null;
    public static final boolean DEFAULT_REUSE_ADDRESS = false;
    public static final boolean DEFAULT_IPV6 = false;
    private boolean broadcast;
    private boolean loopbackModeDisabled;
    private int multicastTimeToLive;
    private String multicastNetworkInterface;
    private boolean ipV6;

    public DatagramSocketOptions(DatagramSocketOptions other) {
        super(other);
        this.broadcast = other.isBroadcast();
        this.loopbackModeDisabled = other.isLoopbackModeDisabled();
        this.multicastTimeToLive = other.getMulticastTimeToLive();
        this.multicastNetworkInterface = other.getMulticastNetworkInterface();
        this.ipV6 = other.isIpV6();
    }

    public DatagramSocketOptions(JsonObject json) {
        super(json);
        this.broadcast = json.getBoolean("broadcast", false);
        this.loopbackModeDisabled = json.getBoolean("loopbackModeDisabled", true);
        this.multicastTimeToLive = json.getInteger("multicastTimeToLive", -1);
        this.multicastNetworkInterface = json.getString("multicastNetworkInterface", DEFAULT_MULTICAST_NETWORK_INTERFACE);
        this.ipV6 = json.getBoolean("ipV6", false);
        this.setReuseAddress(json.getBoolean("reuseAddress", false));
    }

    public DatagramSocketOptions() {
        this.setReuseAddress(false);
        this.broadcast = false;
        this.loopbackModeDisabled = true;
        this.multicastTimeToLive = -1;
        this.multicastNetworkInterface = DEFAULT_MULTICAST_NETWORK_INTERFACE;
        this.ipV6 = false;
    }

    @Override
    public int getSendBufferSize() {
        return super.getSendBufferSize();
    }

    @Override
    public DatagramSocketOptions setSendBufferSize(int sendBufferSize) {
        super.setSendBufferSize(sendBufferSize);
        return this;
    }

    @Override
    public int getReceiveBufferSize() {
        return super.getReceiveBufferSize();
    }

    @Override
    public DatagramSocketOptions setReceiveBufferSize(int receiveBufferSize) {
        super.setReceiveBufferSize(receiveBufferSize);
        return this;
    }

    @Override
    public DatagramSocketOptions setReuseAddress(boolean reuseAddress) {
        super.setReuseAddress(reuseAddress);
        return this;
    }

    @Override
    public int getTrafficClass() {
        return super.getTrafficClass();
    }

    @Override
    public DatagramSocketOptions setTrafficClass(int trafficClass) {
        super.setTrafficClass(trafficClass);
        return this;
    }

    public boolean isBroadcast() {
        return this.broadcast;
    }

    public DatagramSocketOptions setBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
        return this;
    }

    public boolean isLoopbackModeDisabled() {
        return this.loopbackModeDisabled;
    }

    public DatagramSocketOptions setLoopbackModeDisabled(boolean loopbackModeDisabled) {
        this.loopbackModeDisabled = loopbackModeDisabled;
        return this;
    }

    public int getMulticastTimeToLive() {
        return this.multicastTimeToLive;
    }

    public DatagramSocketOptions setMulticastTimeToLive(int multicastTimeToLive) {
        Arguments.require(multicastTimeToLive >= 0, "multicastTimeToLive must be >= 0");
        this.multicastTimeToLive = multicastTimeToLive;
        return this;
    }

    public String getMulticastNetworkInterface() {
        return this.multicastNetworkInterface;
    }

    public DatagramSocketOptions setMulticastNetworkInterface(String multicastNetworkInterface) {
        this.multicastNetworkInterface = multicastNetworkInterface;
        return this;
    }

    public boolean isIpV6() {
        return this.ipV6;
    }

    public DatagramSocketOptions setIpV6(boolean ipV6) {
        this.ipV6 = ipV6;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatagramSocketOptions)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DatagramSocketOptions that = (DatagramSocketOptions)o;
        if (this.broadcast != that.broadcast) {
            return false;
        }
        if (this.ipV6 != that.ipV6) {
            return false;
        }
        if (this.loopbackModeDisabled != that.loopbackModeDisabled) {
            return false;
        }
        if (this.multicastTimeToLive != that.multicastTimeToLive) {
            return false;
        }
        return !(this.multicastNetworkInterface != null ? !this.multicastNetworkInterface.equals(that.multicastNetworkInterface) : that.multicastNetworkInterface != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.broadcast ? 1 : 0);
        result = 31 * result + (this.loopbackModeDisabled ? 1 : 0);
        result = 31 * result + this.multicastTimeToLive;
        result = 31 * result + (this.multicastNetworkInterface != null ? this.multicastNetworkInterface.hashCode() : 0);
        result = 31 * result + (this.ipV6 ? 1 : 0);
        return result;
    }
}

