/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.eventbus.impl;

import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.eventbus.impl.BaseMessage;

class ShortMessage
extends BaseMessage<Short> {
    ShortMessage(boolean send, String address, Short body) {
        super(send, address, body);
    }

    public ShortMessage(Buffer readBuff) {
        super(readBuff);
    }

    @Override
    protected void readBody(int pos, Buffer readBuff) {
        boolean isNull;
        boolean bl = isNull = readBuff.getByte(pos) == 0;
        if (!isNull) {
            this.body = readBuff.getShort(++pos);
        }
    }

    @Override
    protected void writeBody(Buffer buff) {
        if (this.body == null) {
            buff.appendByte((byte)0);
        } else {
            buff.appendByte((byte)1);
            buff.appendShort((Short)this.body);
        }
    }

    @Override
    protected int getBodyLength() {
        return 1 + (this.body == null ? 0 : 2);
    }

    @Override
    protected Message<Short> copy() {
        return this;
    }

    @Override
    protected byte type() {
        return 10;
    }
}

