/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.sockjs.impl;

import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.vertx.java.core.Handler;
import org.vertx.java.core.MultiMap;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.json.DecodeException;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.shareddata.Shareable;
import org.vertx.java.core.sockjs.SockJSSocket;
import org.vertx.java.core.sockjs.impl.BaseTransport;
import org.vertx.java.core.sockjs.impl.JsonCodec;
import org.vertx.java.core.sockjs.impl.SockJSSocketBase;
import org.vertx.java.core.sockjs.impl.TransportListener;

class Session
extends SockJSSocketBase
implements Shareable {
    private static final Logger log = LoggerFactory.getLogger(Session.class);
    private final Map<String, Session> sessions;
    private final Queue<String> pendingWrites = new LinkedList<String>();
    private final Queue<String> pendingReads = new LinkedList<String>();
    private TransportListener listener;
    private Handler<Buffer> dataHandler;
    private boolean closed;
    private boolean openWritten;
    private final String id;
    private final long timeout;
    private final Handler<SockJSSocket> sockHandler;
    private long heartbeatID = -1L;
    private long timeoutTimerID = -1L;
    private boolean paused;
    private int maxQueueSize = 65536;
    private int messagesSize;
    private Handler<Void> drainHandler;
    private Handler<Void> endHandler;
    private Handler<Throwable> exceptionHandler;
    private boolean handleCalled;
    private InetSocketAddress localAddress;
    private InetSocketAddress remoteAddress;
    private String uri;
    private MultiMap headers;

    Session(VertxInternal vertx, Map<String, Session> sessions, long heartbeatPeriod, Handler<SockJSSocket> sockHandler) {
        this(vertx, sessions, null, -1L, heartbeatPeriod, sockHandler);
    }

    Session(VertxInternal vertx, Map<String, Session> sessions, String id, long timeout, long heartbeatPeriod, Handler<SockJSSocket> sockHandler) {
        super(vertx);
        this.sessions = sessions;
        this.id = id;
        this.timeout = timeout;
        this.sockHandler = sockHandler;
        this.heartbeatID = vertx.setPeriodic(heartbeatPeriod, new Handler<Long>(){

            @Override
            public void handle(Long id) {
                if (Session.this.listener != null) {
                    Session.this.listener.sendFrame("h");
                }
            }
        });
    }

    @Override
    public synchronized SockJSSocket write(Buffer buffer) {
        String msgStr = buffer.toString();
        this.pendingWrites.add(msgStr);
        this.messagesSize += msgStr.length();
        if (this.listener != null) {
            this.writePendingMessages();
        }
        return this;
    }

    @Override
    public synchronized Session dataHandler(Handler<Buffer> handler) {
        this.dataHandler = handler;
        return this;
    }

    @Override
    public synchronized Session pause() {
        this.paused = true;
        return this;
    }

    @Override
    public synchronized Session resume() {
        this.paused = false;
        if (this.dataHandler != null) {
            for (String msg : this.pendingReads) {
                this.dataHandler.handle(new Buffer(msg));
            }
        }
        return this;
    }

    @Override
    public synchronized Session setWriteQueueMaxSize(int maxQueueSize) {
        if (maxQueueSize < 1) {
            throw new IllegalArgumentException("maxQueueSize must be >= 1");
        }
        this.maxQueueSize = maxQueueSize;
        return this;
    }

    @Override
    public synchronized boolean writeQueueFull() {
        return this.messagesSize >= this.maxQueueSize;
    }

    @Override
    public synchronized Session drainHandler(Handler<Void> handler) {
        this.drainHandler = handler;
        return this;
    }

    @Override
    public synchronized Session exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public synchronized Session endHandler(Handler<Void> endHandler) {
        this.endHandler = endHandler;
        return this;
    }

    public synchronized void shutdown() {
        this.doClose();
    }

    @Override
    public synchronized void close() {
        if (this.endHandler != null) {
            this.endHandler.handle(null);
        }
        this.closed = true;
        if (this.listener != null && this.handleCalled) {
            this.listener.sessionClosed();
        }
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public InetSocketAddress localAddress() {
        return this.localAddress;
    }

    @Override
    public MultiMap headers() {
        return this.headers;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    synchronized boolean isClosed() {
        return this.closed;
    }

    synchronized void resetListener() {
        this.listener = null;
        this.setTimer();
    }

    private void cancelTimer() {
        if (this.timeoutTimerID != -1L) {
            this.vertx.cancelTimer(this.timeoutTimerID);
        }
    }

    private void setTimer() {
        if (this.timeout != -1L) {
            this.cancelTimer();
            this.timeoutTimerID = this.vertx.setTimer(this.timeout, new Handler<Long>(){

                @Override
                public void handle(Long id) {
                    Session.this.vertx.cancelTimer(Session.this.heartbeatID);
                    if (Session.this.listener == null) {
                        Session.this.shutdown();
                    }
                    if (Session.this.listener != null) {
                        Session.this.listener.close();
                    }
                }
            });
        }
    }

    synchronized void writePendingMessages() {
        String json = JsonCodec.encode(this.pendingWrites.toArray());
        this.listener.sendFrame("a" + json);
        this.pendingWrites.clear();
        this.messagesSize = 0;
        if (this.drainHandler != null && this.messagesSize <= this.maxQueueSize / 2) {
            Handler<Void> dh = this.drainHandler;
            this.drainHandler = null;
            dh.handle(null);
        }
    }

    synchronized void register(TransportListener lst) {
        if (this.closed) {
            this.writeClosed(lst);
            lst.close();
        } else if (this.listener != null) {
            this.writeClosed(lst, 2010, "Another connection still open");
            lst.close();
        } else {
            this.cancelTimer();
            this.listener = lst;
            if (!this.openWritten) {
                this.writeOpen(lst);
                this.sockHandler.handle(this);
                this.handleCalled = true;
            }
            if (this.listener != null) {
                if (this.closed) {
                    this.writeClosed(lst);
                    this.listener = null;
                    lst.close();
                } else if (!this.pendingWrites.isEmpty()) {
                    this.writePendingMessages();
                }
            }
        }
    }

    private void doClose() {
        System.out.println("**** do close called !!");
        super.close();
        if (this.heartbeatID != -1L) {
            this.vertx.cancelTimer(this.heartbeatID);
        }
        if (this.timeoutTimerID != -1L) {
            this.vertx.cancelTimer(this.timeoutTimerID);
        }
        if (this.id != null) {
            System.out.println("**** removing session!!");
            this.sessions.remove(this.id);
        }
        if (this.endHandler != null) {
            this.endHandler.handle(null);
        }
    }

    private String[] parseMessageString(String msgs) {
        try {
            String[] parts;
            if (msgs.startsWith("[")) {
                parts = (String[])JsonCodec.decodeValue(msgs, String[].class);
            } else {
                String str = (String)JsonCodec.decodeValue(msgs, String.class);
                parts = new String[]{str};
            }
            return parts;
        }
        catch (DecodeException e) {
            return null;
        }
    }

    boolean handleMessages(String messages) {
        String[] msgArr = this.parseMessageString(messages);
        if (msgArr == null) {
            return false;
        }
        if (this.dataHandler != null) {
            for (String msg : msgArr) {
                if (!this.paused) {
                    try {
                        this.dataHandler.handle(new Buffer(msg));
                    }
                    catch (Throwable t) {
                        log.error("Unhandle exception", t);
                    }
                    continue;
                }
                this.pendingReads.add(msg);
            }
        }
        return true;
    }

    void handleException(Throwable t) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(t);
        } else {
            log.error("Unhandled exception", t);
        }
    }

    public void writeClosed(TransportListener lst) {
        this.writeClosed(lst, 3000, "Go away!");
    }

    private void writeClosed(TransportListener lst, int code, String msg) {
        StringBuilder sb = new StringBuilder("c[");
        sb.append(String.valueOf(code)).append(",\"");
        sb.append(msg).append("\"]");
        lst.sendFrame(sb.toString());
    }

    private void writeOpen(TransportListener lst) {
        StringBuilder sb = new StringBuilder("o");
        lst.sendFrame(sb.toString());
        this.openWritten = true;
    }

    void setInfo(InetSocketAddress localAddress, InetSocketAddress remoteAddress, String uri, MultiMap headers) {
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
        this.uri = uri;
        this.headers = BaseTransport.removeCookieHeaders(headers);
    }
}

