/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.sockjs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.AsyncResultHandler;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.VoidHandler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.eventbus.EventBus;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.sockjs.EventBusBridgeHook;
import org.vertx.java.core.sockjs.SockJSSocket;

public class EventBusBridge
implements Handler<SockJSSocket> {
    private static final Logger log = LoggerFactory.getLogger(EventBusBridge.class);
    private static final String DEFAULT_AUTH_ADDRESS = "vertx.basicauthmanager.authorise";
    private static final long DEFAULT_AUTH_TIMEOUT = 300000L;
    private static final long DEFAULT_REPLY_TIMEOUT = 30000L;
    private static final int DEFAULT_MAX_ADDRESS_LENGTH = 200;
    private static final int DEFAULT_MAX_HANDLERS_PER_SOCKET = 1000;
    private static final long DEFAULT_PING_TIMEOUT = 10000L;
    private final Map<String, Auth> authCache = new HashMap<String, Auth>();
    private final Map<SockJSSocket, SockInfo> sockInfos = new HashMap<SockJSSocket, SockInfo>();
    private final List<JsonObject> inboundPermitted;
    private final List<JsonObject> outboundPermitted;
    private final long authTimeout;
    private final String authAddress;
    private final int maxAddressLength;
    private final int maxHandlersPerSocket;
    private final long pingTimeout;
    private final Vertx vertx;
    private final EventBus eb;
    private final Set<String> acceptedReplyAddresses = new HashSet<String>();
    private final Map<String, Pattern> compiledREs = new HashMap<String, Pattern>();
    private EventBusBridgeHook hook;

    private static List<JsonObject> convertArray(JsonArray permitted) {
        ArrayList<JsonObject> l = new ArrayList<JsonObject>();
        for (Object elem : permitted) {
            if (!(elem instanceof JsonObject)) {
                throw new IllegalArgumentException("Permitted must only contain JsonObject: " + elem);
            }
            l.add((JsonObject)elem);
        }
        return l;
    }

    public EventBusBridge(Vertx vertx, JsonArray inboundPermitted, JsonArray outboundPermitted) {
        this(vertx, inboundPermitted, outboundPermitted, 300000L, null);
    }

    public EventBusBridge(Vertx vertx, JsonArray inboundPermitted, JsonArray outboundPermitted, long authTimeout) {
        this(vertx, inboundPermitted, outboundPermitted, authTimeout, null);
    }

    public EventBusBridge(Vertx vertx, JsonArray inboundPermitted, JsonArray outboundPermitted, long authTimeout, String authAddress) {
        this(vertx, inboundPermitted, outboundPermitted, new JsonObject().putNumber("auth_timeout", authTimeout).putString("auth_address", authAddress));
    }

    public EventBusBridge(Vertx vertx, JsonArray inboundPermitted, JsonArray outboundPermitted, JsonObject conf) {
        this.vertx = vertx;
        this.eb = vertx.eventBus();
        this.inboundPermitted = EventBusBridge.convertArray(inboundPermitted);
        this.outboundPermitted = EventBusBridge.convertArray(outboundPermitted);
        long authTimeout = conf.getLong("auth_timeout", 300000L);
        if (authTimeout < 0L) {
            throw new IllegalArgumentException("authTimeout < 0");
        }
        this.authTimeout = authTimeout;
        this.authAddress = conf.getString("auth_address", DEFAULT_AUTH_ADDRESS);
        this.maxAddressLength = conf.getInteger("max_address_length", 200);
        this.maxHandlersPerSocket = conf.getInteger("max_handlers_per_socket", 1000);
        this.pingTimeout = conf.getLong("ping_interval", 10000L);
    }

    private void handleSocketClosed(SockJSSocket sock, Map<String, Handler<Message>> handlers) {
        for (Map.Entry<String, Handler<Message>> entry : handlers.entrySet()) {
            this.handleUnregister(sock, entry.getKey());
            this.eb.unregisterHandler(entry.getKey(), entry.getValue());
        }
        SockInfo info = this.sockInfos.remove(sock);
        if (info != null) {
            PingInfo pingInfo;
            Set<String> auths = info.sockAuths;
            if (auths != null) {
                for (String sessionID : auths) {
                    Auth auth = this.authCache.remove(sessionID);
                    if (auth == null) continue;
                    auth.cancel();
                }
            }
            if ((pingInfo = info.pingInfo) != null) {
                this.vertx.cancelTimer(pingInfo.timerID);
            }
        }
        this.handleSocketClosed(sock);
    }

    private void handleSocketData(SockJSSocket sock, Buffer data, Map<String, Handler<Message>> handlers) {
        String type;
        JsonObject msg = new JsonObject(data.toString());
        switch (type = EventBusBridge.getMandatoryString(msg, "type")) {
            case "send": {
                String address = EventBusBridge.getMandatoryString(msg, "address");
                this.internalHandleSendOrPub(sock, true, msg, address);
                break;
            }
            case "publish": {
                String address = EventBusBridge.getMandatoryString(msg, "address");
                this.internalHandleSendOrPub(sock, false, msg, address);
                break;
            }
            case "register": {
                String address = EventBusBridge.getMandatoryString(msg, "address");
                this.internalHandleRegister(sock, msg, address, handlers);
                break;
            }
            case "unregister": {
                String address = EventBusBridge.getMandatoryString(msg, "address");
                this.internalHandleUnregister(sock, address, handlers);
                break;
            }
            case "ping": {
                this.internalHandlePing(sock);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid type: " + type);
            }
        }
    }

    private void internalHandleSendOrPub(SockJSSocket sock, boolean send, JsonObject msg, String address) {
        if (this.handleSendOrPub(sock, send, msg, address)) {
            this.doSendOrPub(send, sock, address, msg);
        }
    }

    private boolean checkMaxHandlers(SockInfo info) {
        if (info.handlerCount == this.maxHandlersPerSocket) {
            log.error("Refusing to register as max_handlers_per_socket reached already");
            return false;
        }
        return true;
    }

    private void internalHandleRegister(final SockJSSocket sock, JsonObject message, final String address, Map<String, Handler<Message>> handlers) {
        if (address.length() > this.maxAddressLength) {
            log.error("Refusing to register as address length > max_address_length");
            return;
        }
        final SockInfo info = this.sockInfos.get(sock);
        if (info == null) {
            return;
        }
        if (!this.checkMaxHandlers(info)) {
            return;
        }
        if (this.handlePreRegister(sock, address)) {
            final boolean debug = log.isDebugEnabled();
            Match match = this.checkMatches(false, address, message);
            if (match.doesMatch) {
                Handler<Message> handler = new Handler<Message>(){

                    @Override
                    public void handle(Message msg) {
                        Match curMatch = EventBusBridge.this.checkMatches(false, address, msg.body());
                        if (curMatch.doesMatch) {
                            Set<String> sockAuths = info.sockAuths;
                            if (curMatch.requiresAuth && sockAuths == null) {
                                if (debug) {
                                    log.debug("Outbound message for address " + address + " rejected because auth is required and socket is not authed");
                                }
                            } else {
                                EventBusBridge.this.checkAddAccceptedReplyAddress(msg.replyAddress());
                                EventBusBridge.deliverMessage(sock, address, msg);
                            }
                        } else if (debug) {
                            log.debug("Outbound message for address " + address + " rejected because there is no inbound match");
                        }
                    }
                };
                handlers.put(address, handler);
                this.eb.registerHandler(address, (Handler<? extends Message>)handler);
                this.handlePostRegister(sock, address);
                ++info.handlerCount;
            } else if (debug) {
                log.debug("Cannot register handler for address " + address + " because there is no inbound match");
            }
        }
    }

    private void internalHandleUnregister(SockJSSocket sock, String address, Map<String, Handler<Message>> handlers) {
        Handler<Message> handler;
        if (this.handleUnregister(sock, address) && (handler = handlers.remove(address)) != null) {
            this.eb.unregisterHandler(address, handler);
            SockInfo info = this.sockInfos.get(sock);
            if (info == null) {
                return;
            }
            --info.handlerCount;
        }
    }

    private void internalHandlePing(SockJSSocket sock) {
        SockInfo info = this.sockInfos.get(sock);
        if (info != null) {
            info.pingInfo.lastPing = System.currentTimeMillis();
        }
    }

    @Override
    public void handle(final SockJSSocket sock) {
        if (!this.handleSocketCreated(sock)) {
            sock.close();
        } else {
            final HashMap handlers = new HashMap();
            sock.endHandler(new VoidHandler(){

                @Override
                public void handle() {
                    System.out.println("In handlesocketclosed");
                    new Exception().printStackTrace();
                    EventBusBridge.this.handleSocketClosed(sock, handlers);
                }
            });
            sock.dataHandler(new Handler<Buffer>(){

                @Override
                public void handle(Buffer data) {
                    EventBusBridge.this.handleSocketData(sock, data, handlers);
                }
            });
            final PingInfo pingInfo = new PingInfo();
            pingInfo.timerID = this.vertx.setPeriodic(this.pingTimeout, new Handler<Long>(){

                @Override
                public void handle(Long id) {
                    if (System.currentTimeMillis() - pingInfo.lastPing >= EventBusBridge.this.pingTimeout) {
                        sock.close();
                    }
                }
            });
            SockInfo sockInfo = new SockInfo();
            sockInfo.pingInfo = pingInfo;
            this.sockInfos.put(sock, sockInfo);
        }
    }

    private void checkAddAccceptedReplyAddress(final String replyAddress) {
        if (replyAddress != null) {
            this.acceptedReplyAddresses.add(replyAddress);
            this.vertx.setTimer(30000L, new Handler<Long>(){

                @Override
                public void handle(Long id) {
                    EventBusBridge.this.acceptedReplyAddresses.remove(replyAddress);
                }
            });
        }
    }

    private static String getMandatoryString(JsonObject json, String field) {
        String value = json.getString(field);
        if (value == null) {
            throw new IllegalStateException(field + " must be specified for message");
        }
        return value;
    }

    private static JsonObject getMandatoryObject(JsonObject json, String field) {
        JsonObject value = json.getObject(field);
        if (value == null) {
            throw new IllegalStateException(field + " must be specified for message");
        }
        return value;
    }

    private static Object getMandatoryValue(JsonObject json, String field) {
        Object value = json.getValue(field);
        if (value == null) {
            throw new IllegalStateException(field + " must be specified for message");
        }
        return value;
    }

    private static void deliverMessage(SockJSSocket sock, String address, Message message) {
        JsonObject envelope = new JsonObject().putString("address", address).putValue("body", message.body());
        if (message.replyAddress() != null) {
            envelope.putString("replyAddress", message.replyAddress());
        }
        sock.write(new Buffer(envelope.encode()));
    }

    private void doSendOrPub(final boolean send, final SockJSSocket sock, final String address, JsonObject message) {
        final Object body = message.getValue("body");
        final String replyAddress = message.getString("replyAddress");
        if (replyAddress != null && replyAddress.length() > 36) {
            log.error("Will not send message, reply address is > 36 chars");
            return;
        }
        final boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug("Received msg from client in bridge. address:" + address + " message:" + body);
        }
        Match curMatch = this.checkMatches(true, address, body);
        if (curMatch.doesMatch) {
            if (curMatch.requiresAuth) {
                final String sessionID = message.getString("sessionID");
                if (sessionID != null) {
                    this.authorise(message, sessionID, (Handler<AsyncResult<Boolean>>)new AsyncResultHandler<Boolean>(){

                        @Override
                        public void handle(AsyncResult<Boolean> res) {
                            if (res.succeeded()) {
                                if (res.result().booleanValue()) {
                                    EventBusBridge.this.cacheAuthorisation(sessionID, sock);
                                    EventBusBridge.this.checkAndSend(send, address, body, sock, replyAddress);
                                } else if (debug) {
                                    log.debug("Inbound message for address " + address + " rejected because sessionID is not authorised");
                                }
                            } else {
                                log.error("Error in performing authorisation", res.cause());
                            }
                        }
                    });
                } else if (debug) {
                    log.debug("Inbound message for address " + address + " rejected because it requires auth and sessionID is missing");
                }
            } else {
                this.checkAndSend(send, address, body, sock, replyAddress);
            }
        } else if (debug) {
            log.debug("Inbound message for address " + address + " rejected because there is no match");
        }
    }

    private void checkAndSend(boolean send, String address, Object body, final SockJSSocket sock, final String replyAddress) {
        final SockInfo info = this.sockInfos.get(sock);
        if (info == null) {
            return;
        }
        if (replyAddress != null && !this.checkMaxHandlers(info)) {
            return;
        }
        Handler<Message> replyHandler = replyAddress != null ? new Handler<Message>(){

            @Override
            public void handle(Message message) {
                EventBusBridge.this.checkAddAccceptedReplyAddress(message.replyAddress());
                EventBusBridge.deliverMessage(sock, replyAddress, message);
                --info.handlerCount;
            }
        } : null;
        if (log.isDebugEnabled()) {
            log.debug("Forwarding message to address " + address + " on event bus");
        }
        if (send) {
            this.eb.send(address, body, replyHandler);
            if (replyAddress != null) {
                ++info.handlerCount;
            }
        } else {
            this.eb.publish(address, body);
        }
    }

    private void authorise(JsonObject message, String sessionID, final Handler<AsyncResult<Boolean>> handler) {
        if (!this.handleAuthorise(message, sessionID, handler)) {
            final DefaultFutureResult res = new DefaultFutureResult();
            if (this.authCache.containsKey(sessionID)) {
                ((DefaultFutureResult)res.setResult((Object)true)).setHandler(handler);
            } else {
                this.eb.send(this.authAddress, message, new Handler<Message<JsonObject>>(){

                    @Override
                    public void handle(Message<JsonObject> reply) {
                        boolean authed = reply.body().getString("status").equals("ok");
                        ((DefaultFutureResult)res.setResult((Object)authed)).setHandler(handler);
                    }
                });
            }
        }
    }

    private Match checkMatches(boolean inbound, String address, Object body) {
        if (inbound && this.acceptedReplyAddresses.remove(address)) {
            return new Match(true, false);
        }
        List<JsonObject> matches = inbound ? this.inboundPermitted : this.outboundPermitted;
        for (JsonObject matchHolder : matches) {
            boolean matched;
            String matchAddress = matchHolder.getString("address");
            String matchRegex = matchAddress == null ? matchHolder.getString("address_re") : null;
            boolean addressOK = matchAddress == null ? (matchRegex == null ? true : this.regexMatches(matchRegex, address)) : matchAddress.equals(address);
            if (!addressOK || !(matched = EventBusBridge.structureMatches(matchHolder.getObject("match"), body))) continue;
            Boolean b = matchHolder.getBoolean("requires_auth");
            return new Match(true, b != null && b != false);
        }
        return new Match(false, false);
    }

    private boolean regexMatches(String matchRegex, String address) {
        Pattern pattern = this.compiledREs.get(matchRegex);
        if (pattern == null) {
            pattern = Pattern.compile(matchRegex);
            this.compiledREs.put(matchRegex, pattern);
        }
        Matcher m = pattern.matcher(address);
        return m.matches();
    }

    private static boolean structureMatches(JsonObject match, Object bodyObject) {
        if (match == null) {
            return true;
        }
        if (bodyObject == null) {
            return false;
        }
        if (bodyObject instanceof JsonObject) {
            JsonObject body = (JsonObject)bodyObject;
            for (String fieldName : match.getFieldNames()) {
                Object mv = match.getField(fieldName);
                Object bv = body.getField(fieldName);
                if (!(mv instanceof JsonObject ? !EventBusBridge.structureMatches((JsonObject)mv, bv) : !match.getField(fieldName).equals(body.getField(fieldName)))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void cacheAuthorisation(String sessionID, SockJSSocket sock) {
        this.authCache.put(sessionID, new Auth(sessionID, sock));
        SockInfo sockInfo = this.sockInfos.get(sock);
        if (sockInfo == null) {
            return;
        }
        Set<String> sess = sockInfo.sockAuths;
        if (sess == null) {
            sockInfo.sockAuths = sess = new HashSet<String>();
        }
        sess.add(sessionID);
    }

    private void uncacheAuthorisation(String sessionID, SockJSSocket sock) {
        this.authCache.remove(sessionID);
        SockInfo sockInfo = this.sockInfos.get(sock);
        if (sockInfo == null) {
            return;
        }
        Set<String> sess = sockInfo.sockAuths;
        if (sess != null) {
            sess.remove(sessionID);
            if (sess.isEmpty()) {
                sockInfo.sockAuths = null;
            }
        }
    }

    public void setHook(EventBusBridgeHook hook) {
        this.hook = hook;
    }

    public EventBusBridgeHook getHook() {
        return this.hook;
    }

    protected boolean handleSocketCreated(SockJSSocket sock) {
        if (this.hook != null) {
            return this.hook.handleSocketCreated(sock);
        }
        return true;
    }

    protected void handleSocketClosed(SockJSSocket sock) {
        if (this.hook != null) {
            this.hook.handleSocketClosed(sock);
        }
    }

    protected boolean handleSendOrPub(SockJSSocket sock, boolean send, JsonObject msg, String address) {
        if (this.hook != null) {
            return this.hook.handleSendOrPub(sock, send, msg, address);
        }
        return true;
    }

    protected boolean handlePreRegister(SockJSSocket sock, String address) {
        if (this.hook != null) {
            return this.hook.handlePreRegister(sock, address);
        }
        return true;
    }

    protected void handlePostRegister(SockJSSocket sock, String address) {
        if (this.hook != null) {
            this.hook.handlePostRegister(sock, address);
        }
    }

    protected boolean handleUnregister(SockJSSocket sock, String address) {
        if (this.hook != null) {
            return this.hook.handleUnregister(sock, address);
        }
        return true;
    }

    protected boolean handleAuthorise(JsonObject message, String sessionID, Handler<AsyncResult<Boolean>> handler) {
        if (this.hook != null) {
            return this.hook.handleAuthorise(message, sessionID, handler);
        }
        return false;
    }

    private static final class PingInfo {
        long lastPing;
        long timerID;

        private PingInfo() {
        }
    }

    private class Auth {
        private final long timerID;

        Auth(final String sessionID, final SockJSSocket sock) {
            this.timerID = EventBusBridge.this.vertx.setTimer(EventBusBridge.this.authTimeout, new Handler<Long>(){

                @Override
                public void handle(Long id) {
                    EventBusBridge.this.uncacheAuthorisation(sessionID, sock);
                }
            });
        }

        void cancel() {
            EventBusBridge.this.vertx.cancelTimer(this.timerID);
        }
    }

    private static class Match {
        public final boolean doesMatch;
        public final boolean requiresAuth;

        Match(boolean doesMatch, boolean requiresAuth) {
            this.doesMatch = doesMatch;
            this.requiresAuth = requiresAuth;
        }
    }

    private static final class SockInfo {
        Set<String> sockAuths;
        int handlerCount;
        PingInfo pingInfo;

        private SockInfo() {
        }
    }
}

