/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.net.impl;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.ChannelGroupFutureListener;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.net.ssl.SSLContext;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.VoidHandler;
import org.vertx.java.core.impl.Closeable;
import org.vertx.java.core.impl.DefaultContext;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.net.NetServer;
import org.vertx.java.core.net.NetSocket;
import org.vertx.java.core.net.impl.DefaultNetSocket;
import org.vertx.java.core.net.impl.HandlerHolder;
import org.vertx.java.core.net.impl.HandlerManager;
import org.vertx.java.core.net.impl.ServerID;
import org.vertx.java.core.net.impl.TCPSSLHelper;
import org.vertx.java.core.net.impl.VertxEventLoopGroup;
import org.vertx.java.core.net.impl.VertxNetHandler;

public class DefaultNetServer
implements NetServer,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(DefaultNetServer.class);
    private final VertxInternal vertx;
    private final DefaultContext actualCtx;
    private final TCPSSLHelper tcpHelper = new TCPSSLHelper();
    private final Map<Channel, DefaultNetSocket> socketMap = new ConcurrentHashMap<Channel, DefaultNetSocket>();
    private Handler<NetSocket> connectHandler;
    private ChannelGroup serverChannelGroup;
    private boolean listening;
    private volatile ServerID id;
    private DefaultNetServer actualServer;
    private final VertxEventLoopGroup availableWorkers = new VertxEventLoopGroup();
    private final HandlerManager<NetSocket> handlerManager = new HandlerManager(this.availableWorkers);
    private String host;
    private volatile int port;
    private ChannelFuture bindFuture;
    private Queue<Runnable> bindListeners = new ConcurrentLinkedQueue<Runnable>();
    private boolean listenersRun;

    public DefaultNetServer(VertxInternal vertx) {
        this.vertx = vertx;
        this.actualCtx = vertx.getOrCreateContext();
        this.actualCtx.addCloseHook(this);
        this.tcpHelper.setReuseAddress(true);
    }

    @Override
    public NetServer connectHandler(Handler<NetSocket> connectHandler) {
        this.connectHandler = connectHandler;
        return this;
    }

    @Override
    public NetServer listen(int port) {
        this.listen(port, "0.0.0.0", null);
        return this;
    }

    @Override
    public NetServer listen(int port, Handler<AsyncResult<NetServer>> listenHandler) {
        this.listen(port, "0.0.0.0", listenHandler);
        return this;
    }

    @Override
    public NetServer listen(int port, String host) {
        this.listen(port, host, null);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetServer listen(int port, final String host, final Handler<AsyncResult<NetServer>> listenHandler) {
        if (this.connectHandler == null) {
            throw new IllegalStateException("Set connect handler first");
        }
        if (this.listening) {
            throw new IllegalStateException("Listen already called");
        }
        this.listening = true;
        this.host = host;
        Map<ServerID, DefaultNetServer> map = this.vertx.sharedNetServers();
        synchronized (map) {
            this.id = new ServerID(port, host);
            DefaultNetServer shared = this.vertx.sharedNetServers().get(this.id);
            if (shared == null || port == 0) {
                this.serverChannelGroup = new DefaultChannelGroup("vertx-acceptor-channels", (EventExecutor)GlobalEventExecutor.INSTANCE);
                ServerBootstrap bootstrap = new ServerBootstrap();
                bootstrap.group((EventLoopGroup)this.availableWorkers);
                bootstrap.channel(NioServerSocketChannel.class);
                this.tcpHelper.checkSSL(this.vertx);
                bootstrap.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel ch) throws Exception {
                        ChannelPipeline pipeline = ch.pipeline();
                        if (DefaultNetServer.this.tcpHelper.isSSL()) {
                            SslHandler sslHandler = DefaultNetServer.this.tcpHelper.createSslHandler(DefaultNetServer.this.vertx, false);
                            pipeline.addLast("ssl", (ChannelHandler)sslHandler);
                        }
                        if (DefaultNetServer.this.tcpHelper.isSSL()) {
                            pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
                        }
                        pipeline.addLast("handler", (ChannelHandler)new ServerHandler());
                    }
                });
                this.tcpHelper.applyConnectionOptions(bootstrap);
                if (this.connectHandler != null) {
                    this.handlerManager.addHandler(this.connectHandler, this.actualCtx);
                }
                try {
                    InetSocketAddress addr = new InetSocketAddress(InetAddress.getByName(host), port);
                    this.bindFuture = bootstrap.bind((SocketAddress)addr).addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            DefaultNetServer.this.runListeners();
                        }
                    });
                    this.addListener(new Runnable(){

                        @Override
                        public void run() {
                            if (DefaultNetServer.this.bindFuture.isSuccess()) {
                                log.trace("Net server listening on " + host + ":" + DefaultNetServer.this.bindFuture.channel().localAddress());
                                DefaultNetServer.this.port = ((InetSocketAddress)DefaultNetServer.this.bindFuture.channel().localAddress()).getPort();
                                DefaultNetServer.this.id = new ServerID(DefaultNetServer.this.port, ((DefaultNetServer)DefaultNetServer.this).id.host);
                                DefaultNetServer.this.vertx.sharedNetServers().put(DefaultNetServer.this.id, DefaultNetServer.this);
                            } else {
                                DefaultNetServer.this.vertx.sharedNetServers().remove(DefaultNetServer.this.id);
                            }
                        }
                    });
                    this.serverChannelGroup.add((Object)this.bindFuture.channel());
                }
                catch (Throwable t) {
                    if (listenHandler != null) {
                        this.vertx.runOnContext(new VoidHandler(){

                            @Override
                            protected void handle() {
                                listenHandler.handle(new DefaultFutureResult<Throwable>(t));
                            }
                        });
                    } else {
                        this.actualCtx.reportException(t);
                    }
                    this.listening = false;
                    return this;
                }
                if (port != 0) {
                    this.vertx.sharedNetServers().put(this.id, this);
                }
                this.actualServer = this;
            } else {
                this.checkConfigs(this.actualServer, this);
                this.actualServer = shared;
                this.port = shared.port();
                if (this.connectHandler != null) {
                    this.actualServer.handlerManager.addHandler(this.connectHandler, this.actualCtx);
                }
            }
            this.actualServer.addListener(new Runnable(){

                @Override
                public void run() {
                    if (listenHandler != null) {
                        DefaultFutureResult<Object> res;
                        if (DefaultNetServer.this.actualServer.bindFuture.isSuccess()) {
                            res = new DefaultFutureResult<DefaultNetServer>(DefaultNetServer.this);
                        } else {
                            DefaultNetServer.this.listening = false;
                            res = new DefaultFutureResult<Throwable>(DefaultNetServer.this.actualServer.bindFuture.cause());
                        }
                        DefaultNetServer.this.actualCtx.execute(DefaultNetServer.this.actualServer.bindFuture.channel().eventLoop(), new Runnable(){

                            @Override
                            public void run() {
                                listenHandler.handle(res);
                            }
                        });
                    } else if (!DefaultNetServer.this.actualServer.bindFuture.isSuccess()) {
                        DefaultNetServer.this.actualCtx.reportException(DefaultNetServer.this.actualServer.bindFuture.cause());
                        DefaultNetServer.this.listening = false;
                    }
                }
            });
        }
        return this;
    }

    private synchronized void addListener(Runnable runner) {
        if (!this.listenersRun) {
            this.bindListeners.add(runner);
        } else {
            runner.run();
        }
    }

    private synchronized void runListeners() {
        Runnable runner;
        while ((runner = this.bindListeners.poll()) != null) {
            runner.run();
        }
        this.listenersRun = true;
    }

    @Override
    public void close() {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Handler<AsyncResult<Void>> done) {
        if (!this.listening) {
            if (done != null) {
                this.executeCloseDone(this.actualCtx, done, null);
            }
            return;
        }
        this.listening = false;
        Map<ServerID, DefaultNetServer> map = this.vertx.sharedNetServers();
        synchronized (map) {
            if (this.actualServer != null) {
                this.actualServer.handlerManager.removeHandler(this.connectHandler, this.actualCtx);
                if (this.actualServer.handlerManager.hasHandlers()) {
                    if (done != null) {
                        this.executeCloseDone(this.actualCtx, done, null);
                    }
                } else {
                    this.actualServer.actualClose(this.actualCtx, done);
                }
            }
        }
        this.actualCtx.removeCloseHook(this);
    }

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public int port() {
        return this.port;
    }

    @Override
    public boolean isTCPNoDelay() {
        return this.tcpHelper.isTCPNoDelay();
    }

    @Override
    public int getSendBufferSize() {
        return this.tcpHelper.getSendBufferSize();
    }

    @Override
    public int getReceiveBufferSize() {
        return this.tcpHelper.getReceiveBufferSize();
    }

    @Override
    public boolean isTCPKeepAlive() {
        return this.tcpHelper.isTCPKeepAlive();
    }

    @Override
    public boolean isReuseAddress() {
        return this.tcpHelper.isReuseAddress();
    }

    @Override
    public int getSoLinger() {
        return this.tcpHelper.getSoLinger();
    }

    @Override
    public int getTrafficClass() {
        return this.tcpHelper.getTrafficClass();
    }

    @Override
    public int getAcceptBacklog() {
        return this.tcpHelper.getAcceptBacklog();
    }

    @Override
    public NetServer setTCPNoDelay(boolean tcpNoDelay) {
        this.checkListening();
        this.tcpHelper.setTCPNoDelay(tcpNoDelay);
        return this;
    }

    @Override
    public NetServer setSendBufferSize(int size) {
        this.checkListening();
        this.tcpHelper.setSendBufferSize(size);
        return this;
    }

    @Override
    public NetServer setReceiveBufferSize(int size) {
        this.checkListening();
        this.tcpHelper.setReceiveBufferSize(size);
        return this;
    }

    @Override
    public NetServer setTCPKeepAlive(boolean keepAlive) {
        this.checkListening();
        this.tcpHelper.setTCPKeepAlive(keepAlive);
        return this;
    }

    @Override
    public NetServer setReuseAddress(boolean reuse) {
        this.checkListening();
        this.tcpHelper.setReuseAddress(reuse);
        return this;
    }

    @Override
    public NetServer setSoLinger(int linger) {
        this.checkListening();
        this.tcpHelper.setSoLinger(linger);
        return this;
    }

    @Override
    public NetServer setTrafficClass(int trafficClass) {
        this.checkListening();
        this.tcpHelper.setTrafficClass(trafficClass);
        return this;
    }

    @Override
    public NetServer setAcceptBacklog(int backlog) {
        this.checkListening();
        this.tcpHelper.setAcceptBacklog(backlog);
        return this;
    }

    @Override
    public boolean isSSL() {
        return this.tcpHelper.isSSL();
    }

    @Override
    public String getKeyStorePath() {
        return this.tcpHelper.getKeyStorePath();
    }

    @Override
    public String getKeyStorePassword() {
        return this.tcpHelper.getKeyStorePassword();
    }

    @Override
    public String getTrustStorePath() {
        return this.tcpHelper.getTrustStorePath();
    }

    @Override
    public String getTrustStorePassword() {
        return this.tcpHelper.getTrustStorePassword();
    }

    @Override
    public boolean isClientAuthRequired() {
        return this.tcpHelper.getClientAuth() == TCPSSLHelper.ClientAuth.REQUIRED;
    }

    @Override
    public NetServer setSSL(boolean ssl) {
        this.checkListening();
        this.tcpHelper.setSSL(ssl);
        return this;
    }

    @Override
    public NetServer setSSLContext(SSLContext sslContext) {
        this.checkListening();
        this.tcpHelper.setExternalSSLContext(sslContext);
        return this;
    }

    @Override
    public NetServer setKeyStorePath(String path) {
        this.checkListening();
        this.tcpHelper.setKeyStorePath(path);
        return this;
    }

    @Override
    public NetServer setKeyStorePassword(String pwd) {
        this.checkListening();
        this.tcpHelper.setKeyStorePassword(pwd);
        return this;
    }

    @Override
    public NetServer setTrustStorePath(String path) {
        this.checkListening();
        this.tcpHelper.setTrustStorePath(path);
        return this;
    }

    @Override
    public NetServer setTrustStorePassword(String pwd) {
        this.checkListening();
        this.tcpHelper.setTrustStorePassword(pwd);
        return this;
    }

    @Override
    public NetServer setClientAuthRequired(boolean required) {
        this.checkListening();
        this.tcpHelper.setClientAuthRequired(required);
        return this;
    }

    @Override
    public NetServer setUsePooledBuffers(boolean pooledBuffers) {
        this.checkListening();
        this.tcpHelper.setUsePooledBuffers(pooledBuffers);
        return this;
    }

    @Override
    public boolean isUsePooledBuffers() {
        return this.tcpHelper.isUsePooledBuffers();
    }

    private void actualClose(final DefaultContext closeContext, final Handler<AsyncResult<Void>> done) {
        if (this.id != null) {
            this.vertx.sharedNetServers().remove(this.id);
        }
        for (DefaultNetSocket sock : this.socketMap.values()) {
            sock.close();
        }
        this.vertx.setContext(closeContext);
        ChannelGroupFuture fut = this.serverChannelGroup.close();
        fut.addListener((GenericFutureListener)new ChannelGroupFutureListener(){

            public void operationComplete(ChannelGroupFuture fut) throws Exception {
                DefaultNetServer.this.executeCloseDone(closeContext, done, (Exception)fut.cause());
            }
        });
    }

    private void checkConfigs(DefaultNetServer currentServer, DefaultNetServer newServer) {
    }

    private void executeCloseDone(DefaultContext closeContext, final Handler<AsyncResult<Void>> done, final Exception e) {
        if (done != null) {
            closeContext.execute(new Runnable(){

                @Override
                public void run() {
                    done.handle(new DefaultFutureResult<Exception>(e));
                }
            });
        }
    }

    private void checkListening() {
        if (this.listening) {
            throw new IllegalStateException("Can't set property when server is listening");
        }
    }

    private class ServerHandler
    extends VertxNetHandler {
        public ServerHandler() {
            super(DefaultNetServer.this.vertx, DefaultNetServer.this.socketMap);
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            final Channel ch = ctx.channel();
            EventLoop worker = ch.eventLoop();
            final HandlerHolder<NetSocket> handler = DefaultNetServer.this.handlerManager.chooseHandler(worker);
            if (handler == null) {
                return;
            }
            if (DefaultNetServer.this.tcpHelper.isSSL()) {
                SslHandler sslHandler = (SslHandler)ch.pipeline().get(SslHandler.class);
                Future fut = sslHandler.handshakeFuture();
                fut.addListener((GenericFutureListener)new GenericFutureListener<Future<Channel>>(){

                    public void operationComplete(Future<Channel> future) throws Exception {
                        if (future.isSuccess()) {
                            ServerHandler.this.connected(ch, handler);
                        } else {
                            log.error("Client from origin " + ch.remoteAddress() + " failed to connect over ssl");
                        }
                    }
                });
            } else {
                this.connected(ch, handler);
            }
        }

        private void connected(final Channel ch, final HandlerHolder<NetSocket> handler) {
            handler.context.execute(ch.eventLoop(), new Runnable(){

                @Override
                public void run() {
                    ServerHandler.this.doConnected(ch, handler);
                }
            });
        }

        private void doConnected(Channel ch, HandlerHolder<NetSocket> handler) {
            DefaultNetSocket sock = new DefaultNetSocket(this.vertx, ch, handler.context, DefaultNetServer.this.tcpHelper, false);
            DefaultNetServer.this.socketMap.put(ch, sock);
            handler.handler.handle(sock);
        }
    }
}

