/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.eventbus.impl;

import io.netty.util.CharsetUtil;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.eventbus.ReplyException;
import org.vertx.java.core.eventbus.ReplyFailure;
import org.vertx.java.core.eventbus.impl.BaseMessage;

public class ReplyFailureMessage
extends BaseMessage<ReplyException> {
    private byte[] encoded;

    ReplyFailureMessage(String address, ReplyException body) {
        super(true, address, body);
    }

    public ReplyFailureMessage(Buffer readBuff) {
        super(readBuff);
    }

    @Override
    protected void readBody(int pos, Buffer readBuff) {
        String message;
        boolean isNull;
        byte i = readBuff.getByte(pos);
        ReplyFailure rf = ReplyFailure.fromInt(i);
        int failureCode = readBuff.getInt(++pos);
        boolean bl = isNull = readBuff.getByte(pos += 4) == 0;
        if (!isNull) {
            int strLength = readBuff.getInt(++pos);
            byte[] bytes = readBuff.getBytes(pos += 4, pos + strLength);
            message = new String(bytes, CharsetUtil.UTF_8);
        } else {
            message = null;
        }
        this.body = new ReplyException(rf, failureCode, message);
    }

    @Override
    protected void writeBody(Buffer buff) {
        buff.appendByte((byte)((ReplyException)this.body).failureType().toInt());
        buff.appendInt(((ReplyException)this.body).failureCode());
        if (((ReplyException)this.body).getMessage() == null) {
            buff.appendByte((byte)0);
        } else {
            buff.appendByte((byte)1);
            buff.appendInt(this.encoded.length);
            buff.appendBytes(this.encoded);
        }
    }

    @Override
    protected int getBodyLength() {
        if (((ReplyException)this.body).getMessage() == null) {
            return 6;
        }
        this.encoded = ((ReplyException)this.body).getMessage().getBytes(CharsetUtil.UTF_8);
        return 10 + this.encoded.length;
    }

    @Override
    protected Message<ReplyException> copy() {
        return this;
    }

    @Override
    protected byte type() {
        return 100;
    }
}

